/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadaptor;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.kaha.ListContainer;
import org.apache.activemq.kaha.MapContainer;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.kaha.StoreEntry;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.kahadaptor.ConsumerMessageRef;
import org.apache.activemq.store.kahadaptor.ConsumerMessageRefMarshaller;
import org.apache.activemq.store.kahadaptor.KahaMessageStore;
import org.apache.activemq.store.kahadaptor.TopicSubAck;
import org.apache.activemq.store.kahadaptor.TopicSubContainer;

public class KahaTopicMessageStore
extends KahaMessageStore
implements TopicMessageStore {
    protected ListContainer<TopicSubAck> ackContainer;
    protected Map<Object, TopicSubContainer> subscriberMessages = new ConcurrentHashMap<Object, TopicSubContainer>();
    private Map<String, SubscriptionInfo> subscriberContainer;
    private Store store;

    public KahaTopicMessageStore(Store store, MapContainer<MessageId, Message> messageContainer, ListContainer<TopicSubAck> ackContainer, MapContainer<String, SubscriptionInfo> subsContainer, ActiveMQDestination destination) throws IOException {
        super(messageContainer, destination);
        this.store = store;
        this.ackContainer = ackContainer;
        this.subscriberContainer = subsContainer;
        for (String key : this.subscriberContainer.keySet()) {
            this.addSubscriberMessageContainer(key);
        }
    }

    @Override
    public synchronized void addMessage(ConnectionContext context, Message message) throws IOException {
        int subscriberCount = this.subscriberMessages.size();
        if (subscriberCount > 0) {
            MessageId id = message.getMessageId();
            StoreEntry messageEntry = this.messageContainer.place(id, message);
            TopicSubAck tsa = new TopicSubAck();
            tsa.setCount(subscriberCount);
            tsa.setMessageEntry(messageEntry);
            StoreEntry ackEntry = this.ackContainer.placeLast(tsa);
            for (TopicSubContainer container : this.subscriberMessages.values()) {
                ConsumerMessageRef ref = new ConsumerMessageRef();
                ref.setAckEntry(ackEntry);
                ref.setMessageEntry(messageEntry);
                ref.setMessageId(id);
                container.add(ref);
            }
        }
    }

    @Override
    public synchronized void acknowledge(ConnectionContext context, String clientId, String subscriptionName, MessageId messageId, MessageAck ack) throws IOException {
        String subcriberId = this.getSubscriptionKey(clientId, subscriptionName);
        TopicSubContainer container = this.subscriberMessages.get(subcriberId);
        if (container != null) {
            TopicSubAck tsa;
            ConsumerMessageRef ref = container.remove(messageId);
            if (container.isEmpty()) {
                container.reset();
            }
            if (ref != null && (tsa = this.ackContainer.get(ref.getAckEntry())) != null) {
                if (tsa.decrementCount() <= 0) {
                    StoreEntry entry = ref.getAckEntry();
                    entry = this.ackContainer.refresh(entry);
                    this.ackContainer.remove(entry);
                    entry = tsa.getMessageEntry();
                    entry = this.messageContainer.refresh(entry);
                    this.messageContainer.remove(entry);
                } else {
                    this.ackContainer.update(ref.getAckEntry(), tsa);
                }
            }
        }
    }

    @Override
    public synchronized SubscriptionInfo lookupSubscription(String clientId, String subscriptionName) throws IOException {
        return this.subscriberContainer.get(this.getSubscriptionKey(clientId, subscriptionName));
    }

    @Override
    public synchronized void addSubsciption(SubscriptionInfo info, boolean retroactive) throws IOException {
        String key = this.getSubscriptionKey(info.getClientId(), info.getSubscriptionName());
        if (!this.subscriberContainer.containsKey(key)) {
            this.subscriberContainer.put(key, info);
        }
        this.addSubscriberMessageContainer(key);
    }

    @Override
    public synchronized void deleteSubscription(String clientId, String subscriptionName) throws IOException {
        String key = this.getSubscriptionKey(clientId, subscriptionName);
        this.removeSubscriberMessageContainer(key);
    }

    @Override
    public synchronized void recoverSubscription(String clientId, String subscriptionName, MessageRecoveryListener listener) throws Exception {
        block1: {
            ConsumerMessageRef ref;
            Message msg;
            String key = this.getSubscriptionKey(clientId, subscriptionName);
            TopicSubContainer container = this.subscriberMessages.get(key);
            if (container == null) break block1;
            Iterator i = container.iterator();
            while (i.hasNext() && ((msg = (Message)this.messageContainer.get((ref = (ConsumerMessageRef)i.next()).getMessageEntry())) == null || this.recoverMessage(listener, msg))) {
            }
        }
    }

    @Override
    public synchronized void recoverNextMessages(String clientId, String subscriptionName, int maxReturned, MessageRecoveryListener listener) throws Exception {
        String key = this.getSubscriptionKey(clientId, subscriptionName);
        TopicSubContainer container = this.subscriberMessages.get(key);
        if (container != null) {
            int count = 0;
            StoreEntry entry = container.getBatchEntry();
            if (entry == null) {
                entry = container.getEntry();
            } else if ((entry = container.refreshEntry(entry)) != null) {
                entry = container.getNextEntry(entry);
            }
            if (entry != null) {
                do {
                    ConsumerMessageRef consumerRef;
                    Message msg;
                    if ((msg = (Message)this.messageContainer.getValue((consumerRef = container.get(entry)).getMessageEntry())) != null) {
                        this.recoverMessage(listener, msg);
                        ++count;
                        container.setBatchEntry(msg.getMessageId().toString(), entry);
                        continue;
                    }
                    container.reset();
                } while ((entry = container.getNextEntry(entry)) != null && count < maxReturned && listener.hasSpace());
            }
        }
    }

    @Override
    public synchronized void delete() {
        super.delete();
        this.ackContainer.clear();
        this.subscriberContainer.clear();
    }

    @Override
    public SubscriptionInfo[] getAllSubscriptions() throws IOException {
        return this.subscriberContainer.values().toArray(new SubscriptionInfo[this.subscriberContainer.size()]);
    }

    protected String getSubscriptionKey(String clientId, String subscriberName) {
        String result = clientId + ":";
        result = result + (subscriberName != null ? subscriberName : "NOT_SET");
        return result;
    }

    protected MapContainer addSubscriberMessageContainer(Object key) throws IOException {
        MapContainer container = this.store.getMapContainer(key, "topic-subs");
        container.setKeyMarshaller(Store.MESSAGEID_MARSHALLER);
        ConsumerMessageRefMarshaller marshaller = new ConsumerMessageRefMarshaller();
        container.setValueMarshaller(marshaller);
        TopicSubContainer tsc = new TopicSubContainer(container);
        this.subscriberMessages.put(key, tsc);
        return container;
    }

    protected synchronized void removeSubscriberMessageContainer(Object key) throws IOException {
        this.subscriberContainer.remove(key);
        TopicSubContainer container = this.subscriberMessages.remove(key);
        if (container != null) {
            Iterator i = container.iterator();
            while (i.hasNext()) {
                TopicSubAck tsa;
                ConsumerMessageRef ref = (ConsumerMessageRef)i.next();
                if (ref == null || (tsa = this.ackContainer.get(ref.getAckEntry())) == null) continue;
                if (tsa.decrementCount() <= 0) {
                    this.ackContainer.remove(ref.getAckEntry());
                    this.messageContainer.remove(tsa.getMessageEntry());
                    continue;
                }
                this.ackContainer.update(ref.getAckEntry(), tsa);
            }
            container.clear();
        }
        this.store.deleteListContainer(key, "topic-subs");
    }

    @Override
    public synchronized int getMessageCount(String clientId, String subscriberName) throws IOException {
        String key = this.getSubscriptionKey(clientId, subscriberName);
        TopicSubContainer container = this.subscriberMessages.get(key);
        return container != null ? container.size() : 0;
    }

    @Override
    public synchronized void removeAllMessages(ConnectionContext context) throws IOException {
        this.messageContainer.clear();
        this.ackContainer.clear();
        for (TopicSubContainer container : this.subscriberMessages.values()) {
            container.clear();
        }
    }

    @Override
    public synchronized void resetBatching(String clientId, String subscriptionName) {
        String key = this.getSubscriptionKey(clientId, subscriptionName);
        TopicSubContainer topicSubContainer = this.subscriberMessages.get(key);
        if (topicSubContainer != null) {
            topicSubContainer.reset();
        }
    }
}

