/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import java.util.LinkedList;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import org.apache.activemq.MessageAvailableListener;
import org.apache.activemq.web.AjaxWebClient;
import org.apache.activemq.web.UndeliveredAjaxMessage;
import org.eclipse.jetty.continuation.Continuation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AjaxListener
implements MessageAvailableListener {
    private static final Logger LOG = LoggerFactory.getLogger(AjaxListener.class);
    private long maximumReadTimeout;
    private AjaxWebClient client;
    private long lastAccess;
    private Continuation continuation;
    private LinkedList<UndeliveredAjaxMessage> undeliveredMessages = new LinkedList();

    AjaxListener(AjaxWebClient client, long maximumReadTimeout) {
        this.client = client;
        this.maximumReadTimeout = maximumReadTimeout;
        this.access();
    }

    public void access() {
        this.lastAccess = System.currentTimeMillis();
    }

    public synchronized void setContinuation(Continuation continuation) {
        this.continuation = continuation;
    }

    public LinkedList<UndeliveredAjaxMessage> getUndeliveredMessages() {
        return this.undeliveredMessages;
    }

    @Override
    public synchronized void onMessageAvailable(MessageConsumer consumer) {
        block10: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("message for " + consumer + " continuation=" + this.continuation);
            }
            if (this.continuation != null) {
                try {
                    Message message = consumer.receive(10L);
                    LOG.debug("message is " + message);
                    if (message == null) break block10;
                    if (this.continuation.isSuspended()) {
                        LOG.debug("Resuming suspended continuation " + this.continuation);
                        this.continuation.setAttribute("undelivered_message", (Object)new UndeliveredAjaxMessage(message, consumer));
                        this.continuation.resume();
                        break block10;
                    }
                    LOG.debug("Message available, but continuation is already resumed.  Buffer for next time.");
                    this.bufferMessageForDelivery(message, consumer);
                }
                catch (Exception e) {
                    LOG.error("Error receiving message " + e, e);
                }
            } else if (System.currentTimeMillis() - this.lastAccess > 2L * this.maximumReadTimeout) {
                new Thread(){

                    @Override
                    public void run() {
                        AjaxListener.this.client.closeConsumers();
                    }
                }.start();
            } else {
                try {
                    Message message = consumer.receive(10L);
                    this.bufferMessageForDelivery(message, consumer);
                }
                catch (Exception e) {
                    LOG.error("Error receiving message " + e, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bufferMessageForDelivery(Message message, MessageConsumer consumer) {
        if (message != null) {
            LinkedList<UndeliveredAjaxMessage> linkedList = this.undeliveredMessages;
            synchronized (linkedList) {
                this.undeliveredMessages.addLast(new UndeliveredAjaxMessage(message, consumer));
            }
        }
    }
}

