/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileConfiguration;
import org.apache.camel.component.file.GenericFileConsumer;
import org.apache.camel.component.file.GenericFileDefaultSorter;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileExist;
import org.apache.camel.component.file.GenericFileFilter;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.component.file.GenericFileProducer;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.processor.idempotent.MemoryIdempotentRepository;
import org.apache.camel.spi.BrowsableEndpoint;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.Language;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericFileEndpoint<T>
extends ScheduledPollEndpoint
implements BrowsableEndpoint {
    protected static final transient String DEFAULT_STRATEGYFACTORY_CLASS = "org.apache.camel.component.file.strategy.GenericFileProcessStrategyFactory";
    protected static final transient int DEFAULT_IDEMPOTENT_CACHE_SIZE = 1000;
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    protected GenericFileProcessStrategy<T> processStrategy;
    protected GenericFileConfiguration configuration;
    protected IdempotentRepository<String> inProgressRepository = new MemoryIdempotentRepository();
    protected String localWorkDirectory;
    protected boolean autoCreate = true;
    protected boolean startingDirectoryMustExist;
    protected boolean directoryMustExist;
    protected int bufferSize = 131072;
    protected GenericFileExist fileExist = GenericFileExist.Override;
    protected boolean noop;
    protected boolean recursive;
    protected boolean delete;
    protected boolean flatten;
    protected int maxMessagesPerPoll;
    protected int maxDepth = Integer.MAX_VALUE;
    protected int minDepth;
    protected String tempPrefix;
    protected Expression tempFileName;
    protected boolean eagerDeleteTargetFile = true;
    protected String include;
    protected String exclude;
    protected String charset;
    protected Expression fileName;
    protected Expression move;
    protected Expression moveFailed;
    protected Expression preMove;
    protected Boolean idempotent;
    protected IdempotentRepository<String> idempotentRepository;
    protected GenericFileFilter<T> filter;
    protected Comparator<GenericFile<T>> sorter;
    protected Comparator<Exchange> sortBy;
    protected String readLock = "none";
    protected long readLockCheckInterval = 1000L;
    protected long readLockTimeout = 10000L;
    protected GenericFileExclusiveReadLockStrategy<T> exclusiveReadLockStrategy;
    protected boolean keepLastModified;
    protected String doneFileName;

    public GenericFileEndpoint() {
    }

    public GenericFileEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public abstract GenericFileConsumer<T> createConsumer(Processor var1) throws Exception;

    @Override
    public abstract GenericFileProducer<T> createProducer() throws Exception;

    public abstract Exchange createExchange(GenericFile<T> var1);

    public abstract String getScheme();

    public abstract char getFileSeparator();

    public abstract boolean isAbsolute(String var1);

    public String getGeneratedFileName(Message message) {
        return StringHelper.sanitize(message.getMessageId());
    }

    public GenericFileProcessStrategy<T> getGenericFileProcessStrategy() {
        if (this.processStrategy == null) {
            this.processStrategy = this.createGenericFileStrategy();
            this.log.debug("Using Generic file process strategy: {}", this.processStrategy);
        }
        return this.processStrategy;
    }

    @Override
    public List<Exchange> getExchanges() {
        final ArrayList<Exchange> answer = new ArrayList<Exchange>();
        Consumer consumer = null;
        try {
            consumer = this.createConsumer(null);
            ((GenericFileConsumer)consumer).setCustomProcessor(new Processor(){

                @Override
                public void process(Exchange exchange) throws Exception {
                    answer.add(exchange);
                }
            });
            ((ScheduledPollConsumer)consumer).setStartScheduler(false);
            ServiceHelper.startService(consumer);
            ((GenericFileConsumer)consumer).poll();
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        finally {
            try {
                ServiceHelper.stopService(consumer);
            }
            catch (Exception e) {
                this.log.debug("Error stopping consumer used for browsing exchanges. This exception will be ignored", e);
            }
        }
        return answer;
    }

    protected GenericFileProcessStrategy<T> createGenericFileStrategy() {
        Class<?> factory = null;
        try {
            FactoryFinder finder = this.getCamelContext().getFactoryFinder("META-INF/services/org/apache/camel/component/");
            this.log.trace("Using FactoryFinder: {}", finder);
            factory = finder.findClass(this.getScheme(), "strategy.factory.", CamelContext.class);
        }
        catch (ClassNotFoundException e) {
            this.log.trace("'strategy.factory.class' not found", e);
        }
        catch (IOException e) {
            this.log.trace("No strategy factory defined in 'META-INF/services/org/apache/camel/component/'", e);
        }
        if (factory == null) {
            block12: {
                try {
                    this.log.trace("Using ClassResolver to resolve class: {}", (Object)DEFAULT_STRATEGYFACTORY_CLASS);
                    factory = this.getCamelContext().getClassResolver().resolveClass(DEFAULT_STRATEGYFACTORY_CLASS);
                }
                catch (Exception e) {
                    this.log.trace("Cannot load class: {}", (Object)DEFAULT_STRATEGYFACTORY_CLASS, (Object)e);
                }
                try {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("Using classloader: {} to resolve class: {}", this.getClass().getClassLoader(), (Object)DEFAULT_STRATEGYFACTORY_CLASS);
                    }
                    factory = this.getCamelContext().getClassResolver().resolveClass(DEFAULT_STRATEGYFACTORY_CLASS, this.getClass().getClassLoader());
                }
                catch (Exception e) {
                    if (!this.log.isTraceEnabled()) break block12;
                    this.log.trace("Cannot load class: {} using classloader: " + this.getClass().getClassLoader(), (Object)DEFAULT_STRATEGYFACTORY_CLASS, (Object)e);
                }
            }
            if (factory == null) {
                throw new TypeNotPresentException("org.apache.camel.component.file.strategy.GenericFileProcessStrategyFactory class not found", null);
            }
        }
        try {
            Method factoryMethod = factory.getMethod("createGenericFileProcessStrategy", CamelContext.class, Map.class);
            Map<String, Object> params = this.getParamsAsMap();
            this.log.debug("Parameters for Generic file process strategy {}", params);
            return (GenericFileProcessStrategy)ObjectHelper.invokeMethod(factoryMethod, null, this.getCamelContext(), params);
        }
        catch (NoSuchMethodException e) {
            throw new TypeNotPresentException(factory.getSimpleName() + ".createGenericFileProcessStrategy method not found", e);
        }
    }

    public boolean isNoop() {
        return this.noop;
    }

    public void setNoop(boolean noop) {
        this.noop = noop;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    public String getExclude() {
        return this.exclude;
    }

    public void setExclude(String exclude) {
        this.exclude = exclude;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public boolean isFlatten() {
        return this.flatten;
    }

    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public Expression getMove() {
        return this.move;
    }

    public void setMove(Expression move) {
        this.move = move;
    }

    public void setMoveFailed(String fileLanguageExpression) {
        String expression = this.configureMoveOrPreMoveExpression(fileLanguageExpression);
        this.moveFailed = this.createFileLanguageExpression(expression);
    }

    public Expression getMoveFailed() {
        return this.moveFailed;
    }

    public void setMoveFailed(Expression moveFailed) {
        this.moveFailed = moveFailed;
    }

    public void setMove(String fileLanguageExpression) {
        String expression = this.configureMoveOrPreMoveExpression(fileLanguageExpression);
        this.move = this.createFileLanguageExpression(expression);
    }

    public Expression getPreMove() {
        return this.preMove;
    }

    public void setPreMove(Expression preMove) {
        this.preMove = preMove;
    }

    public void setPreMove(String fileLanguageExpression) {
        String expression = this.configureMoveOrPreMoveExpression(fileLanguageExpression);
        this.preMove = this.createFileLanguageExpression(expression);
    }

    public Expression getFileName() {
        return this.fileName;
    }

    public void setFileName(Expression fileName) {
        this.fileName = fileName;
    }

    public void setFileName(String fileLanguageExpression) {
        this.fileName = this.createFileLanguageExpression(fileLanguageExpression);
    }

    public String getDoneFileName() {
        return this.doneFileName;
    }

    public void setDoneFileName(String doneFileName) {
        this.doneFileName = doneFileName;
    }

    public Boolean isIdempotent() {
        return this.idempotent != null ? this.idempotent : false;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        IOHelper.validateCharset(charset);
        this.charset = charset;
    }

    boolean isIdempotentSet() {
        return this.idempotent != null;
    }

    public void setIdempotent(Boolean idempotent) {
        this.idempotent = idempotent;
    }

    public IdempotentRepository<String> getIdempotentRepository() {
        return this.idempotentRepository;
    }

    public void setIdempotentRepository(IdempotentRepository<String> idempotentRepository) {
        this.idempotentRepository = idempotentRepository;
    }

    public GenericFileFilter<T> getFilter() {
        return this.filter;
    }

    public void setFilter(GenericFileFilter<T> filter) {
        this.filter = filter;
    }

    public Comparator<GenericFile<T>> getSorter() {
        return this.sorter;
    }

    public void setSorter(Comparator<GenericFile<T>> sorter) {
        this.sorter = sorter;
    }

    public Comparator<Exchange> getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(Comparator<Exchange> sortBy) {
        this.sortBy = sortBy;
    }

    public void setSortBy(String expression) {
        this.setSortBy(expression, false);
    }

    public void setSortBy(String expression, boolean reverse) {
        this.setSortBy(GenericFileDefaultSorter.sortByFileLanguage(this.getCamelContext(), expression, reverse));
    }

    public String getTempPrefix() {
        return this.tempPrefix;
    }

    public void setTempPrefix(String tempPrefix) {
        this.tempPrefix = tempPrefix;
        this.setTempFileName(tempPrefix + "${file:onlyname}");
    }

    public Expression getTempFileName() {
        return this.tempFileName;
    }

    public void setTempFileName(Expression tempFileName) {
        this.tempFileName = tempFileName;
    }

    public void setTempFileName(String tempFileNameExpression) {
        this.tempFileName = this.createFileLanguageExpression(tempFileNameExpression);
    }

    public boolean isEagerDeleteTargetFile() {
        return this.eagerDeleteTargetFile;
    }

    public void setEagerDeleteTargetFile(boolean eagerDeleteTargetFile) {
        this.eagerDeleteTargetFile = eagerDeleteTargetFile;
    }

    public GenericFileConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new GenericFileConfiguration();
        }
        return this.configuration;
    }

    public void setConfiguration(GenericFileConfiguration configuration) {
        this.configuration = configuration;
    }

    public GenericFileExclusiveReadLockStrategy<T> getExclusiveReadLockStrategy() {
        return this.exclusiveReadLockStrategy;
    }

    public void setExclusiveReadLockStrategy(GenericFileExclusiveReadLockStrategy<T> exclusiveReadLockStrategy) {
        this.exclusiveReadLockStrategy = exclusiveReadLockStrategy;
    }

    public String getReadLock() {
        return this.readLock;
    }

    public void setReadLock(String readLock) {
        this.readLock = readLock;
    }

    public long getReadLockCheckInterval() {
        return this.readLockCheckInterval;
    }

    public void setReadLockCheckInterval(long readLockCheckInterval) {
        this.readLockCheckInterval = readLockCheckInterval;
    }

    public long getReadLockTimeout() {
        return this.readLockTimeout;
    }

    public void setReadLockTimeout(long readLockTimeout) {
        this.readLockTimeout = readLockTimeout;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("BufferSize must be a positive value, was " + bufferSize);
        }
        this.bufferSize = bufferSize;
    }

    public GenericFileExist getFileExist() {
        return this.fileExist;
    }

    public void setFileExist(GenericFileExist fileExist) {
        this.fileExist = fileExist;
    }

    public boolean isAutoCreate() {
        return this.autoCreate;
    }

    public void setAutoCreate(boolean autoCreate) {
        this.autoCreate = autoCreate;
    }

    public boolean isStartingDirectoryMustExist() {
        return this.startingDirectoryMustExist;
    }

    public void setStartingDirectoryMustExist(boolean startingDirectoryMustExist) {
        this.startingDirectoryMustExist = startingDirectoryMustExist;
    }

    public boolean isDirectoryMustExist() {
        return this.directoryMustExist;
    }

    public void setDirectoryMustExist(boolean directoryMustExist) {
        this.directoryMustExist = directoryMustExist;
    }

    public GenericFileProcessStrategy<T> getProcessStrategy() {
        return this.processStrategy;
    }

    public void setProcessStrategy(GenericFileProcessStrategy<T> processStrategy) {
        this.processStrategy = processStrategy;
    }

    public String getLocalWorkDirectory() {
        return this.localWorkDirectory;
    }

    public void setLocalWorkDirectory(String localWorkDirectory) {
        this.localWorkDirectory = localWorkDirectory;
    }

    public int getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public int getMinDepth() {
        return this.minDepth;
    }

    public void setMinDepth(int minDepth) {
        this.minDepth = minDepth;
    }

    public IdempotentRepository<String> getInProgressRepository() {
        return this.inProgressRepository;
    }

    public void setInProgressRepository(IdempotentRepository<String> inProgressRepository) {
        this.inProgressRepository = inProgressRepository;
    }

    public boolean isKeepLastModified() {
        return this.keepLastModified;
    }

    public void setKeepLastModified(boolean keepLastModified) {
        this.keepLastModified = keepLastModified;
    }

    public void configureMessage(GenericFile<T> file, Message message) {
        message.setBody(file);
        if (this.flatten) {
            message.setHeader("CamelFileName", file.getFileNameOnly());
        } else {
            String name = file.isAbsolute() ? file.getAbsoluteFilePath() : file.getRelativeFilePath();
            String endpointPath = this.getConfiguration().getDirectory() + this.getFileSeparator();
            if (ObjectHelper.isNotEmpty(endpointPath) && name.startsWith(endpointPath)) {
                name = ObjectHelper.after(name, endpointPath);
            }
            message.setHeader("CamelFileName", name);
        }
    }

    public void configureExchange(Exchange exchange) {
        if (this.getCharset() != null) {
            exchange.setProperty("CamelCharsetName", this.getCharset());
        }
    }

    protected String configureMoveOrPreMoveExpression(String expression) {
        if (StringHelper.hasStartToken(expression, "simple")) {
            return expression;
        }
        expression = FileUtil.stripTrailingSeparator(expression);
        StringBuilder sb = new StringBuilder();
        if (!this.isAbsolute(expression)) {
            sb.append("${file:parent}");
            sb.append(this.getFileSeparator());
        }
        sb.append(expression);
        sb.append(this.getFileSeparator());
        sb.append("${file:onlyname}");
        return sb.toString();
    }

    protected Map<String, Object> getParamsAsMap() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.isNoop()) {
            params.put("noop", Boolean.toString(true));
        }
        if (this.isDelete()) {
            params.put("delete", Boolean.toString(true));
        }
        if (this.move != null) {
            params.put("move", this.move);
        }
        if (this.moveFailed != null) {
            params.put("moveFailed", this.moveFailed);
        }
        if (this.preMove != null) {
            params.put("preMove", this.preMove);
        }
        if (this.exclusiveReadLockStrategy != null) {
            params.put("exclusiveReadLockStrategy", this.exclusiveReadLockStrategy);
        }
        if (this.readLock != null) {
            params.put("readLock", this.readLock);
        }
        if (this.readLockCheckInterval > 0L) {
            params.put("readLockCheckInterval", this.readLockCheckInterval);
        }
        if (this.readLockTimeout > 0L) {
            params.put("readLockTimeout", this.readLockTimeout);
        }
        return params;
    }

    private Expression createFileLanguageExpression(String expression) {
        Language language = expression.contains("$") ? this.getCamelContext().resolveLanguage("file") : this.getCamelContext().resolveLanguage("constant");
        return language.createExpression(expression);
    }

    protected String createDoneFileName(String fileName) {
        String pattern = this.getDoneFileName();
        ObjectHelper.notEmpty(pattern, "doneFileName", pattern);
        String path = FileUtil.onlyPath(fileName);
        String onlyName = FileUtil.stripPath(fileName);
        pattern = pattern.replaceFirst("\\$\\{file:name\\}", onlyName);
        pattern = pattern.replaceFirst("\\$simple\\{file:name\\}", onlyName);
        pattern = pattern.replaceFirst("\\$\\{file:name.noext\\}", FileUtil.stripExt(onlyName));
        pattern = pattern.replaceFirst("\\$simple\\{file:name.noext\\}", FileUtil.stripExt(onlyName));
        if (StringHelper.hasStartToken(pattern, "simple")) {
            throw new ExpressionIllegalSyntaxException(fileName + ". Cannot resolve reminder: " + pattern);
        }
        String answer = pattern;
        if (ObjectHelper.isNotEmpty(path) && ObjectHelper.isNotEmpty(pattern)) {
            answer = path + this.getFileSeparator() + pattern;
            answer = path + File.separator + pattern;
        }
        if (this.getConfiguration().needToNormalize()) {
            answer = FileUtil.normalizePath(answer);
        }
        return answer;
    }

    protected boolean isDoneFile(String fileName) {
        String pattern = this.getDoneFileName();
        ObjectHelper.notEmpty(pattern, "doneFileName", pattern);
        if (!StringHelper.hasStartToken(pattern, "simple")) {
            return pattern.equals(fileName);
        }
        boolean prefix = pattern.indexOf("${") > 0;
        pattern = pattern.replaceFirst("\\$\\{file:name\\}", "");
        pattern = pattern.replaceFirst("\\$simple\\{file:name\\}", "");
        pattern = pattern.replaceFirst("\\$\\{file:name.noext\\}", "");
        if (StringHelper.hasStartToken(pattern = pattern.replaceFirst("\\$simple\\{file:name.noext\\}", ""), "simple")) {
            throw new ExpressionIllegalSyntaxException(fileName + ". Cannot resolve reminder: " + pattern);
        }
        if (prefix) {
            return fileName.startsWith(pattern);
        }
        return fileName.endsWith(pattern);
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.inProgressRepository, this.idempotentRepository);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopServices(this.inProgressRepository, this.idempotentRepository);
    }
}

