/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExist;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.spi.Language;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.LRUCache;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericFileProducer<T>
extends DefaultProducer {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    protected final GenericFileEndpoint<T> endpoint;
    protected GenericFileOperations<T> operations;
    private final LRUCache<String, Lock> locks = new LRUCache(100);

    protected GenericFileProducer(GenericFileEndpoint<T> endpoint, GenericFileOperations<T> operations) {
        super(endpoint);
        this.endpoint = endpoint;
        this.operations = operations;
    }

    public String getFileSeparator() {
        return File.separator;
    }

    public String normalizePath(String name) {
        return FileUtil.normalizePath(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Exchange exchange) throws Exception {
        Lock lock;
        Exchange fileExchange = this.endpoint.createExchange(exchange);
        this.endpoint.configureExchange(fileExchange);
        String target = this.createFileName(exchange);
        LRUCache<String, Lock> lRUCache = this.locks;
        synchronized (lRUCache) {
            lock = this.locks.get(target);
            if (lock == null) {
                lock = new ReentrantLock();
                this.locks.put(target, lock);
            }
        }
        lock.lock();
        try {
            this.processExchange(fileExchange, target);
            ExchangeHelper.copyResults(exchange, fileExchange);
        }
        finally {
            lock.unlock();
        }
    }

    public void setOperations(GenericFileOperations<T> operations) {
        this.operations = operations;
    }

    protected void processExchange(Exchange exchange, String target) throws Exception {
        this.log.trace("Processing file: {} for exchange: {}", (Object)target, (Object)exchange);
        try {
            this.preWriteCheck();
            boolean writeAsTempAndRename = ObjectHelper.isNotEmpty(this.endpoint.getTempFileName());
            String tempTarget = null;
            Boolean targetExists = null;
            if (writeAsTempAndRename) {
                tempTarget = this.createTempFileName(exchange, target);
                this.log.trace("Writing using tempNameFile: {}", (Object)tempTarget);
                targetExists = this.operations.existsFile(target);
                if (targetExists.booleanValue()) {
                    if (this.endpoint.getFileExist() == GenericFileExist.Ignore) {
                        this.log.trace("An existing file already exists: {}. Ignore and do not override it.", (Object)target);
                        return;
                    }
                    if (this.endpoint.getFileExist() == GenericFileExist.Fail) {
                        throw new GenericFileOperationFailedException("File already exist: " + target + ". Cannot write new file.");
                    }
                    if (this.endpoint.isEagerDeleteTargetFile() && this.endpoint.getFileExist() == GenericFileExist.Override) {
                        this.log.trace("Eagerly deleting existing file: {}", (Object)target);
                        if (!this.operations.deleteFile(target)) {
                            throw new GenericFileOperationFailedException("Cannot delete file: " + target);
                        }
                    }
                }
                if (this.operations.existsFile(tempTarget)) {
                    this.log.trace("Deleting existing temp file: {}", (Object)tempTarget);
                    if (!this.operations.deleteFile(tempTarget)) {
                        throw new GenericFileOperationFailedException("Cannot delete file: " + tempTarget);
                    }
                }
            }
            this.writeFile(exchange, tempTarget != null ? tempTarget : target);
            if (tempTarget != null) {
                if (!this.endpoint.isEagerDeleteTargetFile() && targetExists.booleanValue() && this.endpoint.getFileExist() == GenericFileExist.Override) {
                    this.log.trace("Deleting existing file: {}", (Object)target);
                    if (!this.operations.deleteFile(target)) {
                        throw new GenericFileOperationFailedException("Cannot delete file: " + target);
                    }
                }
                this.log.trace("Renaming file: [{}] to: [{}]", (Object)tempTarget, (Object)target);
                boolean renamed = this.operations.renameFile(tempTarget, target);
                if (!renamed) {
                    throw new GenericFileOperationFailedException("Cannot rename file from: " + tempTarget + " to: " + target);
                }
            }
            if (this.endpoint.getDoneFileName() != null) {
                String doneFileName = this.endpoint.createDoneFileName(target);
                ObjectHelper.notEmpty(doneFileName, "doneFileName", this.endpoint);
                DefaultExchange empty = new DefaultExchange(exchange);
                empty.getIn().setBody("");
                this.log.trace("Writing done file: [{}]", (Object)doneFileName);
                if (this.operations.existsFile(doneFileName) && !this.operations.deleteFile(doneFileName)) {
                    throw new GenericFileOperationFailedException("Cannot delete existing done file: " + doneFileName);
                }
                this.writeFile(empty, doneFileName);
            }
            exchange.getIn().setHeader("CamelFileNameProduced", target);
        }
        catch (Exception e) {
            this.handleFailedWrite(exchange, e);
        }
        this.postWriteCheck();
    }

    public void handleFailedWrite(Exchange exchange, Exception exception) throws Exception {
        throw exception;
    }

    public void preWriteCheck() throws Exception {
    }

    public void postWriteCheck() {
    }

    public void writeFile(Exchange exchange, String fileName) throws GenericFileOperationFailedException {
        boolean success;
        if (this.endpoint.isAutoCreate()) {
            String name = FileUtil.normalizePath(fileName);
            File file = new File(name);
            String directory = file.getParent();
            boolean absolute = FileUtil.isAbsolute(file);
            if (directory != null && !this.operations.buildDirectory(directory, absolute)) {
                this.log.debug("Cannot build directory [{}] (could be because of denied permissions)", (Object)directory);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("About to write [{}] to [{}] from exchange [{}]", new Object[]{fileName, this.getEndpoint(), exchange});
        }
        if (!(success = this.operations.storeFile(fileName, exchange))) {
            throw new GenericFileOperationFailedException("Error writing file [" + fileName + "]");
        }
        this.log.debug("Wrote [{}] to [{}]", (Object)fileName, (Object)this.getEndpoint());
    }

    public String createFileName(Exchange exchange) {
        int pos;
        String name = exchange.getIn().getHeader("CamelFileName", String.class);
        Expression expression = this.endpoint.getFileName();
        if (name != null && StringHelper.hasStartToken(name, "simple")) {
            this.log.trace("{} contains a Simple expression: {}", (Object)"CamelFileName", (Object)name);
            Language language = this.getEndpoint().getCamelContext().resolveLanguage("file");
            expression = language.createExpression(name);
        }
        if (expression != null) {
            this.log.trace("Filename evaluated as expression: {}", expression);
            name = expression.evaluate(exchange, String.class);
        }
        if (name != null && this.endpoint.isFlatten() && (pos = Math.max(name.lastIndexOf("/"), name.lastIndexOf("\\"))) != -1) {
            name = name.substring(pos + 1);
        }
        String endpointPath = this.endpoint.getConfiguration().getDirectory();
        String baseDir = "";
        if (endpointPath.length() > 0) {
            boolean trailingSlash;
            baseDir = endpointPath;
            boolean bl = trailingSlash = endpointPath.endsWith("/") || endpointPath.endsWith("\\");
            if (!trailingSlash) {
                baseDir = baseDir + this.getFileSeparator();
            }
        }
        String answer = name != null ? baseDir + name : baseDir + this.endpoint.getGeneratedFileName(exchange.getIn());
        if (this.endpoint.getConfiguration().needToNormalize()) {
            answer = this.normalizePath(answer);
        }
        return answer;
    }

    public String createTempFileName(Exchange exchange, String fileName) {
        String tempName;
        String answer = fileName;
        if (exchange.getIn().getHeader("CamelFileName") == null) {
            exchange.getIn().setHeader("CamelFileName", FileUtil.stripPath(fileName));
            tempName = this.endpoint.getTempFileName().evaluate(exchange, String.class);
            exchange.getIn().removeHeader("CamelFileName");
        } else {
            tempName = this.endpoint.getTempFileName().evaluate(exchange, String.class);
        }
        int pos = Math.max(answer.lastIndexOf("/"), answer.lastIndexOf("\\"));
        if (pos == -1) {
            answer = tempName;
        } else {
            StringBuilder sb = new StringBuilder(answer.substring(0, pos + 1));
            sb.append(tempName);
            answer = sb.toString();
        }
        if (this.endpoint.getConfiguration().needToNormalize()) {
            answer = this.normalizePath(answer);
        }
        return answer;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService(this.locks);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.locks);
        super.doStop();
    }
}

