/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter
public final class NIOConverter {
    private static final transient Logger LOG = LoggerFactory.getLogger(NIOConverter.class);

    private NIOConverter() {
    }

    @Converter
    public static byte[] toByteArray(ByteBuffer buffer) {
        return buffer.array();
    }

    @Converter
    public static String toString(ByteBuffer buffer, Exchange exchange) throws IOException {
        return IOConverter.toString(buffer.array(), exchange);
    }

    @Converter
    public static ByteBuffer toByteBuffer(byte[] data) {
        return ByteBuffer.wrap(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public static ByteBuffer toByteBuffer(File file) throws IOException {
        BufferedInputStream in = null;
        try {
            byte[] buf = new byte[(int)file.length()];
            in = IOHelper.buffered(new FileInputStream(file));
            int sizeLeft = (int)file.length();
            int offset = 0;
            while (sizeLeft > 0) {
                int readSize = ((InputStream)in).read(buf, offset, sizeLeft);
                sizeLeft -= readSize;
                offset += readSize;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(buf);
            return byteBuffer;
        }
        finally {
            IOHelper.close(in, "Failed to close file stream: " + file.getPath(), LOG);
        }
    }

    @Converter
    public static ByteBuffer toByteBuffer(String value, Exchange exchange) {
        String charsetName;
        ByteBuffer buf = ByteBuffer.allocate(value.length());
        byte[] bytes = null;
        if (exchange != null && (charsetName = exchange.getProperty("CamelCharsetName", String.class)) != null) {
            try {
                bytes = value.getBytes(charsetName);
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn("Cannot convert the byte to String with the charset " + charsetName, e);
            }
        }
        if (bytes == null) {
            bytes = value.getBytes();
        }
        buf.put(bytes);
        return buf;
    }

    @Converter
    public static ByteBuffer toByteBuffer(Short value) {
        ByteBuffer buf = ByteBuffer.allocate(2);
        buf.putShort(value);
        return buf;
    }

    @Converter
    public static ByteBuffer toByteBuffer(Integer value) {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.putInt(value);
        return buf;
    }

    @Converter
    public static ByteBuffer toByteBuffer(Long value) {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putLong(value);
        return buf;
    }

    @Converter
    public static ByteBuffer toByteBuffer(Float value) {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.putFloat(value.floatValue());
        return buf;
    }

    @Converter
    public static ByteBuffer toByteBuffer(Double value) {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putDouble(value);
        return buf;
    }

    @Converter
    public static InputStream toInputStream(ByteBuffer bufferbuffer) {
        return IOConverter.toInputStream(NIOConverter.toByteArray(bufferbuffer));
    }
}

