/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.processor.ErrorHandlerSupport;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.SubUnitOfWorkCallback;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.util.AsyncProcessorConverterHelper;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.CamelLogger;
import org.apache.camel.util.EventHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;

public abstract class RedeliveryErrorHandler
extends ErrorHandlerSupport
implements AsyncProcessor {
    private static ScheduledExecutorService executorService;
    protected final String executorServiceRef;
    protected final CamelContext camelContext;
    protected final Processor deadLetter;
    protected final String deadLetterUri;
    protected final Processor output;
    protected final AsyncProcessor outputAsync;
    protected final Processor redeliveryProcessor;
    protected final RedeliveryPolicy redeliveryPolicy;
    protected final Predicate retryWhilePolicy;
    protected final CamelLogger logger;
    protected final boolean useOriginalMessagePolicy;
    protected boolean redeliveryEnabled;

    public RedeliveryErrorHandler(CamelContext camelContext, Processor output, CamelLogger logger, Processor redeliveryProcessor, RedeliveryPolicy redeliveryPolicy, Processor deadLetter, String deadLetterUri, boolean useOriginalMessagePolicy, Predicate retryWhile, String executorServiceRef) {
        ObjectHelper.notNull(camelContext, "CamelContext", this);
        ObjectHelper.notNull(redeliveryPolicy, "RedeliveryPolicy", this);
        this.camelContext = camelContext;
        this.redeliveryProcessor = redeliveryProcessor;
        this.deadLetter = deadLetter;
        this.output = output;
        this.outputAsync = AsyncProcessorConverterHelper.convert(output);
        this.redeliveryPolicy = redeliveryPolicy;
        this.logger = logger;
        this.deadLetterUri = deadLetterUri;
        this.useOriginalMessagePolicy = useOriginalMessagePolicy;
        this.retryWhilePolicy = retryWhile;
        this.executorServiceRef = executorServiceRef;
    }

    @Override
    public boolean supportTransacted() {
        return false;
    }

    @Override
    public boolean isRunAllowed() {
        boolean forceShutdown = this.camelContext.getShutdownStrategy().forceShutdown(this);
        if (forceShutdown) {
            this.log.trace("Run not allowed as ShutdownStrategy is forcing shutting down");
        }
        return !forceShutdown && super.isRunAllowed();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        if (this.output == null) {
            return;
        }
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        return this.processErrorHandler(exchange, callback, new RedeliveryData());
    }

    protected boolean processErrorHandler(final Exchange exchange, final AsyncCallback callback, final RedeliveryData data) {
        boolean done;
        data.original = this.defensiveCopyExchangeIfNeeded(exchange);
        do {
            boolean sync;
            boolean exhausted;
            if (!this.isRunAllowed()) {
                this.log.trace("Run not allowed, will reject executing exchange: {}", exchange);
                if (exchange.getException() == null) {
                    exchange.setException(new RejectedExecutionException());
                }
                callback.done(data.sync);
                return data.sync;
            }
            boolean handle = this.shouldHandleException(exchange);
            if (handle) {
                this.handleException(exchange, data);
            }
            if (exhausted = this.isExhausted(exchange, data)) {
                Processor target = null;
                boolean deliver = true;
                SubUnitOfWorkCallback uowCallback = exchange.getUnitOfWork().getSubUnitOfWorkCallback();
                if (uowCallback != null) {
                    uowCallback.onExhausted(exchange);
                    deliver = false;
                }
                if (deliver) {
                    target = data.failureProcessor != null ? data.failureProcessor : data.deadLetterProcessor;
                }
                boolean sync2 = this.deliverToFailureProcessor(target, exchange, data, callback);
                return sync2;
            }
            if (data.redeliveryCounter > 0) {
                data.redeliveryDelay = this.determineRedeliveryDelay(exchange, data.currentRedeliveryPolicy, data.redeliveryDelay, data.redeliveryCounter);
                if (data.redeliveryDelay > 0L) {
                    if (data.currentRedeliveryPolicy.isAsyncDelayedRedelivery() && !exchange.isTransacted()) {
                        data.sync = false;
                        data.redeliverFromSync = true;
                        AsyncRedeliveryTask task = new AsyncRedeliveryTask(exchange, callback, data);
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("Scheduling redelivery task to run in {} millis for exchangeId: {}", data.redeliveryDelay, (Object)exchange.getExchangeId());
                        }
                        executorService.schedule(task, data.redeliveryDelay, TimeUnit.MILLISECONDS);
                        return false;
                    }
                    try {
                        data.currentRedeliveryPolicy.sleep(data.redeliveryDelay);
                    }
                    catch (InterruptedException e) {
                        exchange.setException(e);
                        exchange.setProperty("CamelRouteStop", Boolean.TRUE);
                        callback.done(data.sync);
                        return data.sync;
                    }
                }
                this.prepareExchangeForRedelivery(exchange, data);
                this.deliverToOnRedeliveryProcessor(exchange, data);
                EventHelper.notifyExchangeRedelivery(exchange.getContext(), exchange, data.redeliveryCounter);
            }
            if (sync = AsyncProcessorHelper.process(this.outputAsync, exchange, new AsyncCallback(){

                @Override
                public void done(boolean sync) {
                    if (sync) {
                        return;
                    }
                    data.sync = false;
                    if (RedeliveryErrorHandler.this.isDone(exchange)) {
                        callback.done(sync);
                        return;
                    }
                    RedeliveryErrorHandler.this.processAsyncErrorHandler(exchange, callback, data);
                }
            })) continue;
            return false;
        } while (!(done = this.isDone(exchange)));
        callback.done(true);
        return true;
    }

    protected long determineRedeliveryDelay(Exchange exchange, RedeliveryPolicy redeliveryPolicy, long redeliveryDelay, int redeliveryCounter) {
        Message message = exchange.getIn();
        Long delay = message.getHeader("CamelRedeliveryDelay", Long.class);
        if (delay == null) {
            delay = redeliveryPolicy.calculateRedeliveryDelay(redeliveryDelay, redeliveryCounter);
            this.log.debug("Redelivery delay calculated as {}", delay);
        } else {
            this.log.debug("Redelivery delay is {} from Message Header [{}]", delay, (Object)"CamelRedeliveryDelay");
        }
        return delay;
    }

    protected void processAsyncErrorHandler(Exchange exchange, AsyncCallback callback, RedeliveryData data) {
        boolean exhausted;
        if (!this.isRunAllowed()) {
            this.log.trace("Run not allowed, will reject executing exchange: {}", exchange);
            if (exchange.getException() == null) {
                exchange.setException(new RejectedExecutionException());
            }
            callback.done(data.sync);
            return;
        }
        boolean handle = this.shouldHandleException(exchange);
        if (handle) {
            this.handleException(exchange, data);
        }
        if (exhausted = this.isExhausted(exchange, data)) {
            Processor target = null;
            boolean deliver = true;
            SubUnitOfWorkCallback uowCallback = exchange.getUnitOfWork().getSubUnitOfWorkCallback();
            if (uowCallback != null) {
                uowCallback.onExhausted(exchange);
                deliver = false;
            }
            if (deliver) {
                target = data.failureProcessor != null ? data.failureProcessor : data.deadLetterProcessor;
            }
            this.deliverToFailureProcessor(target, exchange, data, callback);
            return;
        }
        if (data.redeliveryCounter > 0) {
            AsyncRedeliveryTask task = new AsyncRedeliveryTask(exchange, callback, data);
            data.redeliveryDelay = data.currentRedeliveryPolicy.calculateRedeliveryDelay(data.redeliveryDelay, data.redeliveryCounter);
            if (data.redeliveryDelay > 0L) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Scheduling redelivery task to run in {} millis for exchangeId: {}", data.redeliveryDelay, (Object)exchange.getExchangeId());
                }
                executorService.schedule(task, data.redeliveryDelay, TimeUnit.MILLISECONDS);
            } else {
                executorService.submit(task);
            }
        }
    }

    protected Exchange defensiveCopyExchangeIfNeeded(Exchange exchange) {
        if (this.redeliveryEnabled) {
            return ExchangeHelper.createCopy(exchange, true);
        }
        return null;
    }

    protected boolean shouldHandleException(Exchange exchange) {
        return exchange.getException() != null;
    }

    protected boolean isDone(Exchange exchange) {
        boolean answer = this.isCancelledOrInterrupted(exchange);
        if (!answer) {
            answer = exchange.getException() == null || ExchangeHelper.isFailureHandled(exchange) || ExchangeHelper.isRedeliveryExhausted(exchange);
        }
        this.log.trace("Is exchangeId: {} done? {}", (Object)exchange.getExchangeId(), (Object)answer);
        return answer;
    }

    protected boolean isCancelledOrInterrupted(Exchange exchange) {
        boolean answer = false;
        if (ExchangeHelper.isInterrupted(exchange)) {
            exchange.setProperty("CamelRouteStop", Boolean.TRUE);
            answer = true;
        }
        this.log.trace("Is exchangeId: {} interrupted? {}", (Object)exchange.getExchangeId(), (Object)answer);
        return answer;
    }

    @Override
    public Processor getOutput() {
        return this.output;
    }

    public Processor getDeadLetter() {
        return this.deadLetter;
    }

    public String getDeadLetterUri() {
        return this.deadLetterUri;
    }

    public boolean isUseOriginalMessagePolicy() {
        return this.useOriginalMessagePolicy;
    }

    public RedeliveryPolicy getRedeliveryPolicy() {
        return this.redeliveryPolicy;
    }

    public CamelLogger getLogger() {
        return this.logger;
    }

    protected Predicate getDefaultHandledPredicate() {
        return null;
    }

    protected void prepareExchangeForContinue(Exchange exchange, RedeliveryData data) {
        Exception caught = exchange.getException();
        exchange.setException(null);
        exchange.setProperty("CamelRollbackOnly", null);
        MessageHelper.resetStreamCache(exchange.getIn());
        exchange.getIn().removeHeader("CamelRedelivered");
        exchange.getIn().removeHeader("CamelRedeliveryCounter");
        exchange.getIn().removeHeader("CamelRedeliveryMaxCounter");
        exchange.removeProperty("CamelFailureHandled");
        String msg = "Failed delivery for " + ExchangeHelper.logIds(exchange);
        msg = msg + ". Exhausted after delivery attempt: " + data.redeliveryCounter + " caught: " + caught;
        msg = msg + ". Handled and continue routing.";
        this.logFailedDelivery(false, false, true, exchange, msg, data, null);
    }

    protected void prepareExchangeForRedelivery(Exchange exchange, RedeliveryData data) {
        if (!this.redeliveryEnabled) {
            throw new IllegalStateException("Redelivery is not enabled on " + this + ". Make sure you have configured the error handler properly.");
        }
        ObjectHelper.notNull(data.original, "Defensive copy of Exchange is null", this);
        exchange.setException(null);
        exchange.setProperty("CamelRollbackOnly", null);
        Integer redeliveryCounter = exchange.getIn().getHeader("CamelRedeliveryCounter", Integer.class);
        Integer redeliveryMaxCounter = exchange.getIn().getHeader("CamelRedeliveryMaxCounter", Integer.class);
        Boolean redelivered = exchange.getIn().getHeader("CamelRedelivered", Boolean.class);
        exchange.getIn().copyFrom(data.original.getIn());
        exchange.setOut(null);
        MessageHelper.resetStreamCache(exchange.getIn());
        if (redeliveryCounter != null) {
            exchange.getIn().setHeader("CamelRedeliveryCounter", redeliveryCounter);
        }
        if (redeliveryMaxCounter != null) {
            exchange.getIn().setHeader("CamelRedeliveryMaxCounter", redeliveryMaxCounter);
        }
        if (redelivered != null) {
            exchange.getIn().setHeader("CamelRedelivered", redelivered);
        }
    }

    protected void handleException(Exchange exchange, RedeliveryData data) {
        Exception e = exchange.getException();
        exchange.setProperty("CamelExceptionCaught", e);
        OnExceptionDefinition exceptionPolicy = this.getExceptionPolicy(exchange, e);
        if (exceptionPolicy != null) {
            data.currentRedeliveryPolicy = exceptionPolicy.createRedeliveryPolicy(exchange.getContext(), data.currentRedeliveryPolicy);
            data.handledPredicate = exceptionPolicy.getHandledPolicy();
            data.continuedPredicate = exceptionPolicy.getContinuedPolicy();
            data.retryWhilePredicate = exceptionPolicy.getRetryWhilePolicy();
            data.useOriginalInMessage = exceptionPolicy.isUseOriginalMessage();
            data.asyncDelayedRedelivery = exceptionPolicy.isAsyncDelayedRedelivery(exchange.getContext());
            Processor processor = null;
            UnitOfWork uow = exchange.getUnitOfWork();
            if (uow != null && uow.getRouteContext() != null) {
                String routeId = uow.getRouteContext().getRoute().getId();
                processor = exceptionPolicy.getErrorHandler(routeId);
            } else if (!exceptionPolicy.getErrorHandlers().isEmpty()) {
                this.log.warn("Cannot determine current route from Exchange with id: {}, will fallback and use first error handler.", (Object)exchange.getExchangeId());
                processor = exceptionPolicy.getErrorHandlers().iterator().next();
            }
            if (processor != null) {
                data.failureProcessor = processor;
            }
            if ((processor = exceptionPolicy.getOnRedelivery()) != null) {
                data.onRedeliveryProcessor = processor;
            }
        }
        if (!ExchangeHelper.isFailureHandled(exchange) && !ExchangeHelper.isUnitOfWorkExhausted(exchange)) {
            String msg = "Failed delivery for " + ExchangeHelper.logIds(exchange) + ". On delivery attempt: " + data.redeliveryCounter + " caught: " + e;
            this.logFailedDelivery(true, false, false, exchange, msg, data, e);
        }
        data.redeliveryCounter = this.incrementRedeliveryCounter(exchange, e, data);
    }

    protected void deliverToOnRedeliveryProcessor(Exchange exchange, RedeliveryData data) {
        if (data.onRedeliveryProcessor == null) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Redelivery processor {} is processing Exchange: {} before its redelivered", data.onRedeliveryProcessor, (Object)exchange);
        }
        try {
            data.onRedeliveryProcessor.process(exchange);
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
        this.log.trace("Redelivery processor done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean deliverToFailureProcessor(final Processor processor, final Exchange exchange, final RedeliveryData data, final AsyncCallback callback) {
        boolean sync = true;
        Exception caught = exchange.getException();
        exchange.setException(null);
        final boolean shouldHandle = this.shouldHandled(exchange, data);
        final boolean shouldContinue = this.shouldContinue(exchange, data);
        boolean handled = false;
        if (shouldHandle || shouldContinue) {
            exchange.getIn().removeHeader("CamelRedelivered");
            exchange.getIn().removeHeader("CamelRedeliveryCounter");
            exchange.getIn().removeHeader("CamelRedeliveryMaxCounter");
            exchange.removeProperty("CamelRollbackOnly");
            exchange.removeProperty("CamelUnitOfWorkExhausted");
            handled = true;
        } else {
            this.decrementRedeliveryCounter(exchange);
        }
        if (processor != null) {
            if (data.useOriginalInMessage) {
                this.log.trace("Using the original IN message instead of current");
                Message original = exchange.getUnitOfWork().getOriginalInMessage();
                exchange.setIn(original);
                if (exchange.hasOut()) {
                    this.log.trace("Removing the out message to avoid some uncertain behavior");
                    exchange.setOut(null);
                }
            }
            MessageHelper.resetStreamCache(exchange.getIn());
            this.log.trace("Failure processor {} is processing Exchange: {}", processor, (Object)exchange);
            exchange.setProperty("CamelFailureEndpoint", exchange.getProperty("CamelToEndpoint"));
            AsyncProcessor afp = AsyncProcessorConverterHelper.convert(processor);
            sync = AsyncProcessorHelper.process(afp, exchange, new AsyncCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void done(boolean sync) {
                    RedeliveryErrorHandler.this.log.trace("Failure processor done: {} processing Exchange: {}", processor, (Object)exchange);
                    try {
                        RedeliveryErrorHandler.this.prepareExchangeAfterFailure(exchange, data, shouldHandle, shouldContinue);
                        boolean deadLetterChannel = processor == data.deadLetterProcessor && data.deadLetterProcessor != null;
                        EventHelper.notifyExchangeFailureHandled(exchange.getContext(), exchange, processor, deadLetterChannel);
                    }
                    finally {
                        data.sync &= sync;
                        callback.done(data.sync);
                    }
                }
            });
        } else {
            try {
                this.prepareExchangeAfterFailure(exchange, data, shouldHandle, shouldContinue);
            }
            finally {
                callback.done(data.sync);
            }
        }
        String msg = "Failed delivery for " + ExchangeHelper.logIds(exchange);
        msg = msg + ". Exhausted after delivery attempt: " + data.redeliveryCounter + " caught: " + caught;
        if (processor != null) {
            msg = msg + ". Processed by failure processor: " + processor;
        }
        this.logFailedDelivery(false, handled, false, exchange, msg, data, null);
        return sync;
    }

    protected void prepareExchangeAfterFailure(Exchange exchange, RedeliveryData data, boolean shouldHandle, boolean shouldContinue) {
        boolean alreadySet;
        ExchangeHelper.setFailureHandled(exchange);
        boolean bl = alreadySet = exchange.getProperty("CamelErrorHandlerHandled") != null;
        if (alreadySet) {
            boolean handled = exchange.getProperty("CamelErrorHandlerHandled", Boolean.class);
            this.log.trace("This exchange has already been marked for handling: {}", handled);
            if (handled) {
                exchange.setException(null);
            } else {
                exchange.setException(exchange.getProperty("CamelExceptionCaught", Exception.class));
                exchange.setProperty("CamelFailureEndpoint", exchange.getProperty("CamelToEndpoint"));
            }
            return;
        }
        if (shouldHandle) {
            this.log.trace("This exchange is handled so its marked as not failed: {}", exchange);
            exchange.setProperty("CamelErrorHandlerHandled", Boolean.TRUE);
        } else if (shouldContinue) {
            this.log.trace("This exchange is continued: {}", exchange);
            this.prepareExchangeForContinue(exchange, data);
        } else {
            this.log.trace("This exchange is not handled or continued so its marked as failed: {}", exchange);
            exchange.setProperty("CamelErrorHandlerHandled", Boolean.FALSE);
            exchange.setException(exchange.getProperty("CamelExceptionCaught", Exception.class));
            exchange.setProperty("CamelFailureEndpoint", exchange.getProperty("CamelToEndpoint"));
        }
    }

    private void logFailedDelivery(boolean shouldRedeliver, boolean handled, boolean continued, Exchange exchange, String message, RedeliveryData data, Throwable e) {
        boolean logStackTrace;
        LoggingLevel newLogLevel;
        if (this.logger == null) {
            return;
        }
        if (!exchange.isRollbackOnly()) {
            if (handled && !data.currentRedeliveryPolicy.isLogHandled()) {
                return;
            }
            if (continued && !data.currentRedeliveryPolicy.isLogContinued()) {
                return;
            }
            if (shouldRedeliver && !data.currentRedeliveryPolicy.isLogRetryAttempted()) {
                return;
            }
            if (!shouldRedeliver && !data.currentRedeliveryPolicy.isLogExhausted()) {
                return;
            }
        }
        if (exchange.isRollbackOnly()) {
            newLogLevel = data.currentRedeliveryPolicy.getRetriesExhaustedLogLevel();
            logStackTrace = data.currentRedeliveryPolicy.isLogStackTrace();
        } else if (shouldRedeliver) {
            newLogLevel = data.currentRedeliveryPolicy.getRetryAttemptedLogLevel();
            logStackTrace = data.currentRedeliveryPolicy.isLogRetryStackTrace();
        } else {
            newLogLevel = data.currentRedeliveryPolicy.getRetriesExhaustedLogLevel();
            logStackTrace = data.currentRedeliveryPolicy.isLogStackTrace();
        }
        if (e == null) {
            e = exchange.getProperty("CamelExceptionCaught", Exception.class);
        }
        if (exchange.isRollbackOnly()) {
            Exception cause;
            String msg = "Rollback " + ExchangeHelper.logIds(exchange);
            Throwable throwable = cause = exchange.getException() != null ? exchange.getException() : exchange.getProperty("CamelExceptionCaught", Throwable.class);
            if (cause != null) {
                msg = msg + " due: " + cause.getMessage();
            }
            if (newLogLevel == LoggingLevel.ERROR) {
                this.logger.log(msg, LoggingLevel.WARN);
            } else {
                this.logger.log(msg, newLogLevel);
            }
        } else if (e != null && logStackTrace) {
            this.logger.log(message, e, newLogLevel);
        } else {
            this.logger.log(message, newLogLevel);
        }
    }

    private boolean isExhausted(Exchange exchange, RedeliveryData data) {
        boolean rollbackOnly = exchange.getProperty("CamelRollbackOnly", false, Boolean.class);
        if (rollbackOnly) {
            this.log.trace("This exchange is marked as rollback only, so forcing it to be exhausted: {}", exchange);
            return true;
        }
        if (data.redeliveryCounter == 0) {
            return false;
        }
        boolean redeliver = data.currentRedeliveryPolicy.shouldRedeliver(exchange, data.redeliveryCounter, data.retryWhilePredicate);
        return !redeliver;
    }

    private boolean shouldContinue(Exchange exchange, RedeliveryData data) {
        if (data.continuedPredicate != null) {
            return data.continuedPredicate.matches(exchange);
        }
        return false;
    }

    private boolean shouldHandled(Exchange exchange, RedeliveryData data) {
        if (data.handledPredicate != null) {
            return data.handledPredicate.matches(exchange);
        }
        return false;
    }

    private int incrementRedeliveryCounter(Exchange exchange, Throwable e, RedeliveryData data) {
        Message in = exchange.getIn();
        Integer counter = in.getHeader("CamelRedeliveryCounter", Integer.class);
        int next = 1;
        if (counter != null) {
            next = counter + 1;
        }
        in.setHeader("CamelRedeliveryCounter", next);
        in.setHeader("CamelRedelivered", Boolean.TRUE);
        if (data.currentRedeliveryPolicy.getMaximumRedeliveries() > 0) {
            in.setHeader("CamelRedeliveryMaxCounter", data.currentRedeliveryPolicy.getMaximumRedeliveries());
        }
        return next;
    }

    private void decrementRedeliveryCounter(Exchange exchange) {
        Message in = exchange.getIn();
        Integer counter = in.getHeader("CamelRedeliveryCounter", Integer.class);
        if (counter != null) {
            int prev = counter - 1;
            in.setHeader("CamelRedeliveryCounter", prev);
            in.setHeader("CamelRedelivered", prev > 0 ? Boolean.TRUE : Boolean.FALSE);
        } else {
            in.setHeader("CamelRedeliveryCounter", 0);
            in.setHeader("CamelRedelivered", Boolean.FALSE);
        }
    }

    private boolean determineIfRedeliveryIsEnabled() throws Exception {
        if (this.getRedeliveryPolicy().getMaximumRedeliveries() != 0) {
            return true;
        }
        if (this.retryWhilePolicy != null) {
            return true;
        }
        if (!this.exceptionPolicies.isEmpty()) {
            for (OnExceptionDefinition def : this.exceptionPolicies.values()) {
                Integer max;
                RedeliveryPolicy policy;
                String ref = def.getRedeliveryPolicyRef();
                if (ref != null ? (policy = CamelContextHelper.mandatoryLookup(this.camelContext, ref, RedeliveryPolicy.class)).getMaximumRedeliveries() != 0 : def.getRedeliveryPolicy() != null && (max = CamelContextHelper.parseInteger(this.camelContext, def.getRedeliveryPolicy().getMaximumRedeliveries())) != null && max != 0) {
                    return true;
                }
                if (def.getRetryWhilePolicy() == null && def.getRetryWhile() == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.output, this.outputAsync, this.deadLetter);
        if (executorService == null || executorService.isShutdown()) {
            if (this.executorServiceRef != null) {
                executorService = this.camelContext.getRegistry().lookup(this.executorServiceRef, ScheduledExecutorService.class);
                if (executorService == null) {
                    ExecutorServiceManager manager = this.camelContext.getExecutorServiceManager();
                    ThreadPoolProfile profile = manager.getThreadPoolProfile(this.executorServiceRef);
                    executorService = manager.newScheduledThreadPool((Object)this, this.executorServiceRef, profile);
                }
                if (executorService == null) {
                    throw new IllegalArgumentException("ExecutorServiceRef " + this.executorServiceRef + " not found in registry.");
                }
            } else {
                executorService = this.camelContext.getExecutorServiceManager().newDefaultScheduledThreadPool(this, "ErrorHandlerRedeliveryTask");
            }
        }
        this.redeliveryEnabled = this.determineIfRedeliveryIsEnabled();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Redelivery enabled: {} on error handler: {}", this.redeliveryEnabled, (Object)this);
        }
    }

    @Override
    protected void doStop() throws Exception {
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices(this.deadLetter, this.output, this.outputAsync);
    }

    private class AsyncRedeliveryTask
    implements Callable<Boolean> {
        private final Exchange exchange;
        private final AsyncCallback callback;
        private final RedeliveryData data;

        public AsyncRedeliveryTask(Exchange exchange, AsyncCallback callback, RedeliveryData data) {
            this.exchange = exchange;
            this.callback = callback;
            this.data = data;
        }

        @Override
        public Boolean call() throws Exception {
            RedeliveryErrorHandler.this.prepareExchangeForRedelivery(this.exchange, this.data);
            RedeliveryErrorHandler.this.deliverToOnRedeliveryProcessor(this.exchange, this.data);
            if (RedeliveryErrorHandler.this.log.isTraceEnabled()) {
                RedeliveryErrorHandler.this.log.trace("Redelivering exchangeId: {} -> {} for Exchange: {}", new Object[]{this.exchange.getExchangeId(), RedeliveryErrorHandler.this.outputAsync, this.exchange});
            }
            EventHelper.notifyExchangeRedelivery(this.exchange.getContext(), this.exchange, this.data.redeliveryCounter);
            boolean sync = this.data.redeliverFromSync ? AsyncProcessorHelper.process(RedeliveryErrorHandler.this.outputAsync, this.exchange, new AsyncCallback(){

                @Override
                public void done(boolean doneSync) {
                    RedeliveryErrorHandler.this.log.trace("Redelivering exchangeId: {} done sync: {}", (Object)AsyncRedeliveryTask.this.exchange.getExchangeId(), (Object)doneSync);
                    ((AsyncRedeliveryTask)AsyncRedeliveryTask.this).data.sync = false;
                    if (RedeliveryErrorHandler.this.isDone(AsyncRedeliveryTask.this.exchange)) {
                        AsyncRedeliveryTask.this.callback.done(false);
                        return;
                    }
                    RedeliveryErrorHandler.this.processAsyncErrorHandler(AsyncRedeliveryTask.this.exchange, AsyncRedeliveryTask.this.callback, AsyncRedeliveryTask.this.data);
                }
            }) : AsyncProcessorHelper.process(RedeliveryErrorHandler.this.outputAsync, this.exchange, new AsyncCallback(){

                @Override
                public void done(boolean doneSync) {
                    RedeliveryErrorHandler.this.log.trace("Redelivering exchangeId: {} done sync: {}", (Object)AsyncRedeliveryTask.this.exchange.getExchangeId(), (Object)doneSync);
                    if (doneSync) {
                        return;
                    }
                    ((AsyncRedeliveryTask)AsyncRedeliveryTask.this).data.sync = false;
                    if (RedeliveryErrorHandler.this.isDone(AsyncRedeliveryTask.this.exchange)) {
                        AsyncRedeliveryTask.this.callback.done(doneSync);
                        return;
                    }
                    RedeliveryErrorHandler.this.processAsyncErrorHandler(AsyncRedeliveryTask.this.exchange, AsyncRedeliveryTask.this.callback, AsyncRedeliveryTask.this.data);
                }
            });
            return sync;
        }
    }

    protected class RedeliveryData {
        Exchange original;
        boolean sync = true;
        int redeliveryCounter;
        long redeliveryDelay;
        Predicate retryWhilePredicate;
        boolean redeliverFromSync;
        RedeliveryPolicy currentRedeliveryPolicy;
        Processor deadLetterProcessor;
        Processor failureProcessor;
        Processor onRedeliveryProcessor;
        Predicate handledPredicate;
        Predicate continuedPredicate;
        boolean useOriginalInMessage;
        boolean asyncDelayedRedelivery;

        protected RedeliveryData() {
            this.retryWhilePredicate = RedeliveryErrorHandler.this.retryWhilePolicy;
            this.currentRedeliveryPolicy = RedeliveryErrorHandler.this.redeliveryPolicy;
            this.deadLetterProcessor = RedeliveryErrorHandler.this.deadLetter;
            this.onRedeliveryProcessor = RedeliveryErrorHandler.this.redeliveryProcessor;
            this.handledPredicate = RedeliveryErrorHandler.this.getDefaultHandledPredicate();
            this.useOriginalInMessage = RedeliveryErrorHandler.this.useOriginalMessagePolicy;
            this.asyncDelayedRedelivery = RedeliveryErrorHandler.this.redeliveryPolicy.isAsyncDelayedRedelivery();
        }
    }
}

