/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ProducerCallback;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;

public class WireTapProcessor
extends SendProcessor {
    private final ExecutorService executorService;
    private Expression newExchangeExpression;
    private List<Processor> newExchangeProcessors;
    private boolean copy;
    private Processor onPrepare;

    public WireTapProcessor(Endpoint destination, ExecutorService executorService) {
        super(destination);
        ObjectHelper.notNull(executorService, "executorService");
        this.executorService = executorService;
    }

    public WireTapProcessor(Endpoint destination, ExchangePattern pattern, ExecutorService executorService) {
        super(destination, pattern);
        ObjectHelper.notNull(executorService, "executorService");
        this.executorService = executorService;
    }

    @Override
    public String toString() {
        return "WireTap[" + this.destination.getEndpointUri() + "]";
    }

    @Override
    public String getTraceLabel() {
        return "wireTap(" + this.destination.getEndpointUri() + ")";
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        if (!this.isStarted()) {
            throw new IllegalStateException("WireTapProcessor has not been started: " + this);
        }
        final Exchange wireTapExchange = this.configureExchange(exchange, this.pattern);
        this.executorService.submit(new Callable<Exchange>(){

            @Override
            public Exchange call() throws Exception {
                return WireTapProcessor.this.producerCache.doInProducer(WireTapProcessor.this.destination, wireTapExchange, WireTapProcessor.this.pattern, new ProducerCallback<Exchange>(){

                    @Override
                    public Exchange doInProducer(Producer producer, Exchange exchange, ExchangePattern pattern) throws Exception {
                        WireTapProcessor.this.log.debug(">>>> (wiretap) {} {}", WireTapProcessor.this.destination, (Object)exchange);
                        producer.process(exchange);
                        return exchange;
                    }
                });
            }
        });
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (!this.isStarted()) {
            throw new IllegalStateException("WireTapProcessor has not been started: " + this);
        }
        final Exchange wireTapExchange = this.configureExchange(exchange, this.pattern);
        this.executorService.submit(new Callable<Exchange>(){

            @Override
            public Exchange call() throws Exception {
                return WireTapProcessor.this.producerCache.doInProducer(WireTapProcessor.this.destination, wireTapExchange, WireTapProcessor.this.pattern, new ProducerCallback<Exchange>(){

                    @Override
                    public Exchange doInProducer(Producer producer, Exchange exchange, ExchangePattern pattern) throws Exception {
                        WireTapProcessor.this.log.debug(">>>> (wiretap) {} {}", WireTapProcessor.this.destination, (Object)exchange);
                        producer.process(exchange);
                        return exchange;
                    }
                });
            }
        });
        callback.done(true);
        return true;
    }

    @Override
    protected Exchange configureExchange(Exchange exchange, ExchangePattern pattern) {
        Object body;
        Exchange answer = this.copy ? this.configureCopyExchange(exchange) : this.configureNewExchange(exchange);
        answer.setProperty("CamelToEndpoint", this.destination.getEndpointUri());
        if (this.newExchangeExpression != null && (body = this.newExchangeExpression.evaluate(answer, Object.class)) != null) {
            answer.getIn().setBody(body);
        }
        if (this.newExchangeProcessors != null) {
            for (Processor processor : this.newExchangeProcessors) {
                try {
                    processor.process(answer);
                }
                catch (Exception e) {
                    throw ObjectHelper.wrapRuntimeCamelException(e);
                }
            }
        }
        if (this.onPrepare != null) {
            try {
                this.onPrepare.process(exchange);
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        return answer;
    }

    private Exchange configureCopyExchange(Exchange exchange) {
        Exchange copy = ExchangeHelper.createCorrelatedCopy(exchange, false);
        copy.setPattern(ExchangePattern.InOnly);
        return copy;
    }

    private Exchange configureNewExchange(Exchange exchange) {
        return new DefaultExchange(exchange.getFromEndpoint(), ExchangePattern.InOnly);
    }

    public List<Processor> getNewExchangeProcessors() {
        return this.newExchangeProcessors;
    }

    public void setNewExchangeProcessors(List<Processor> newExchangeProcessors) {
        this.newExchangeProcessors = newExchangeProcessors;
    }

    public Expression getNewExchangeExpression() {
        return this.newExchangeExpression;
    }

    public void setNewExchangeExpression(Expression newExchangeExpression) {
        this.newExchangeExpression = newExchangeExpression;
    }

    public void addNewExchangeProcessor(Processor processor) {
        if (this.newExchangeProcessors == null) {
            this.newExchangeProcessors = new ArrayList<Processor>();
        }
        this.newExchangeProcessors.add(processor);
    }

    public boolean isCopy() {
        return this.copy;
    }

    public void setCopy(boolean copy) {
        this.copy = copy;
    }

    public Processor getOnPrepare() {
        return this.onPrepare;
    }

    public void setOnPrepare(Processor onPrepare) {
        this.onPrepare = onPrepare;
    }
}

