/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.loadbalancer;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.processor.loadbalancer.LoadBalancerSupport;
import org.apache.camel.util.AsyncProcessorConverterHelper;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;

public class FailOverLoadBalancer
extends LoadBalancerSupport
implements Traceable {
    private final List<Class<?>> exceptions;
    private boolean roundRobin;
    private int maximumFailoverAttempts = -1;
    private final AtomicInteger counter = new AtomicInteger(-1);

    public FailOverLoadBalancer() {
        this.exceptions = null;
    }

    public FailOverLoadBalancer(List<Class<?>> exceptions) {
        this.exceptions = exceptions;
        for (Class<?> type : exceptions) {
            if (ObjectHelper.isAssignableFrom(Throwable.class, type)) continue;
            throw new IllegalArgumentException("Class is not an instance of Throwable: " + type);
        }
    }

    public List<Class<?>> getExceptions() {
        return this.exceptions;
    }

    public boolean isRoundRobin() {
        return this.roundRobin;
    }

    public void setRoundRobin(boolean roundRobin) {
        this.roundRobin = roundRobin;
    }

    public int getMaximumFailoverAttempts() {
        return this.maximumFailoverAttempts;
    }

    public void setMaximumFailoverAttempts(int maximumFailoverAttempts) {
        this.maximumFailoverAttempts = maximumFailoverAttempts;
    }

    protected boolean shouldFailOver(Exchange exchange) {
        if (exchange == null) {
            return false;
        }
        boolean answer = false;
        if (exchange.getException() != null) {
            if (this.exceptions == null || this.exceptions.isEmpty()) {
                answer = true;
            } else {
                for (Class<?> exception : this.exceptions) {
                    if (exchange.getException(exception) == null) continue;
                    answer = true;
                    break;
                }
            }
        }
        this.log.trace("Should failover: {} for exchangeId: {}", answer, (Object)exchange.getExchangeId());
        return answer;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        List<Processor> processors = this.getProcessors();
        AtomicInteger index = new AtomicInteger();
        AtomicInteger attempts = new AtomicInteger();
        boolean first = true;
        Exchange copy = null;
        if (this.isRoundRobin()) {
            if (this.counter.incrementAndGet() >= processors.size()) {
                this.counter.set(0);
            }
            index.set(this.counter.get());
        }
        this.log.trace("Failover starting with endpoint index {}", index);
        while (first || this.shouldFailOver(copy)) {
            if (!first) {
                attempts.incrementAndGet();
                if (this.maximumFailoverAttempts > -1 && attempts.get() > this.maximumFailoverAttempts) {
                    this.log.debug("Breaking out of failover after {} failover attempts", attempts);
                    break;
                }
                index.incrementAndGet();
                this.counter.incrementAndGet();
            } else {
                first = false;
            }
            if (index.get() >= processors.size()) {
                if (this.isRoundRobin()) {
                    this.log.trace("Failover is round robin enabled and therefore starting from the first endpoint");
                    index.set(0);
                    this.counter.set(0);
                } else {
                    this.log.trace("Breaking out of failover as we reached the end of endpoints to use for failover");
                    break;
                }
            }
            copy = this.prepareExchangeForFailover(exchange);
            Processor processor = processors.get(index.get());
            boolean sync = this.processExchange(processor, exchange, copy, attempts, index, callback, processors);
            if (!sync) {
                this.log.trace("Processing exchangeId: {} is continued being processed asynchronously", (Object)exchange.getExchangeId());
                return false;
            }
            this.log.trace("Processing exchangeId: {} is continued being processed synchronously", (Object)exchange.getExchangeId());
        }
        if (copy != null) {
            ExchangeHelper.copyResults(exchange, copy);
        }
        this.log.debug("Failover complete for exchangeId: {} >>> {}", (Object)exchange.getExchangeId(), (Object)exchange);
        callback.done(true);
        return true;
    }

    protected Exchange prepareExchangeForFailover(Exchange exchange) {
        return ExchangeHelper.createCopy(exchange, true);
    }

    private boolean processExchange(Processor processor, Exchange exchange, Exchange copy, AtomicInteger attempts, AtomicInteger index, AsyncCallback callback, List<Processor> processors) {
        if (processor == null) {
            throw new IllegalStateException("No processors could be chosen to process " + copy);
        }
        this.log.debug("Processing failover at attempt {} for {}", attempts, (Object)copy);
        AsyncProcessor albp = AsyncProcessorConverterHelper.convert(processor);
        return AsyncProcessorHelper.process(albp, copy, new FailOverAsyncCallback(exchange, copy, attempts, index, callback, processors));
    }

    public String toString() {
        return "FailoverLoadBalancer[" + this.getProcessors() + "]";
    }

    @Override
    public String getTraceLabel() {
        return "failover";
    }

    private final class FailOverAsyncCallback
    implements AsyncCallback {
        private final Exchange exchange;
        private Exchange copy;
        private final AtomicInteger attempts;
        private final AtomicInteger index;
        private final AsyncCallback callback;
        private final List<Processor> processors;

        private FailOverAsyncCallback(Exchange exchange, Exchange copy, AtomicInteger attempts, AtomicInteger index, AsyncCallback callback, List<Processor> processors) {
            this.exchange = exchange;
            this.copy = copy;
            this.attempts = attempts;
            this.index = index;
            this.callback = callback;
            this.processors = processors;
        }

        @Override
        public void done(boolean doneSync) {
            if (doneSync) {
                return;
            }
            while (FailOverLoadBalancer.this.shouldFailOver(this.copy)) {
                this.attempts.incrementAndGet();
                if (FailOverLoadBalancer.this.maximumFailoverAttempts > -1 && this.attempts.get() > FailOverLoadBalancer.this.maximumFailoverAttempts) {
                    FailOverLoadBalancer.this.log.trace("Breaking out of failover after {} failover attempts", this.attempts);
                    break;
                }
                this.index.incrementAndGet();
                FailOverLoadBalancer.this.counter.incrementAndGet();
                if (this.index.get() >= this.processors.size()) {
                    if (FailOverLoadBalancer.this.isRoundRobin()) {
                        FailOverLoadBalancer.this.log.trace("Failover is round robin enabled and therefore starting from the first endpoint");
                        this.index.set(0);
                        FailOverLoadBalancer.this.counter.set(0);
                    } else {
                        FailOverLoadBalancer.this.log.trace("Breaking out of failover as we reached the end of endpoints to use for failover");
                        break;
                    }
                }
                this.copy = FailOverLoadBalancer.this.prepareExchangeForFailover(this.exchange);
                Processor processor = this.processors.get(this.index.get());
                doneSync = FailOverLoadBalancer.this.processExchange(processor, this.exchange, this.copy, this.attempts, this.index, this.callback, this.processors);
                if (doneSync) continue;
                FailOverLoadBalancer.this.log.trace("Processing exchangeId: {} is continued being processed asynchronously", (Object)this.exchange.getExchangeId());
                return;
            }
            if (this.copy != null) {
                ExchangeHelper.copyResults(this.exchange, this.copy);
            }
            FailOverLoadBalancer.this.log.debug("Failover complete for exchangeId: {} >>> {}", (Object)this.exchange.getExchangeId(), (Object)this.exchange);
            this.callback.done(false);
        }
    }
}

