/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.verifier.regexp.xmlschema;

import com.sun.msv.datatype.xsd.DatatypeFactory;
import com.sun.msv.datatype.xsd.QnameType;
import com.sun.msv.driver.textui.Debug;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.xmlschema.ComplexTypeExp;
import com.sun.msv.grammar.xmlschema.ElementDeclExp;
import com.sun.msv.grammar.xmlschema.SimpleTypeExp;
import com.sun.msv.grammar.xmlschema.XMLSchemaSchema;
import com.sun.msv.grammar.xmlschema.XMLSchemaTypeExp;
import com.sun.msv.util.StartTagInfo;
import com.sun.msv.util.StringRef;
import com.sun.msv.verifier.Acceptor;
import com.sun.msv.verifier.regexp.AttributeToken;
import com.sun.msv.verifier.regexp.SimpleAcceptor;
import com.sun.msv.verifier.regexp.xmlschema.XSREDocDecl;
import org.relaxng.datatype.DatatypeException;

public class XSAcceptor
extends SimpleAcceptor {
    public static final String XSINamespace = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XMLSchemaNamespace = "http://www.w3.org/2001/XMLSchema";
    private final XSREDocDecl _docDecl;

    public XSAcceptor(XSREDocDecl docDecl, Expression combined, ElementExp owner, Expression continuation) {
        super(docDecl, combined, owner, continuation);
        this._docDecl = docDecl;
    }

    public Acceptor createClone() {
        return new XSAcceptor(this._docDecl, this.getExpression(), this.owner, this.continuation);
    }

    protected Acceptor createAcceptor(Expression combined, Expression continuation, ElementExp[] primitives, int numPrimitives) {
        if (primitives == null || numPrimitives <= 1) {
            return new XSAcceptor((XSREDocDecl)this.docDecl, combined, primitives == null ? null : primitives[0], continuation);
        }
        return new XSAcceptor((XSREDocDecl)this.docDecl, primitives[0].contentModel.getExpandedExp(this.docDecl.pool), primitives[0], null);
    }

    protected boolean onAttribute(AttributeToken token, StringRef refErr) {
        if (token.namespaceURI.equals(XSINamespace)) {
            token.match(this._docDecl.xsiAttExp);
            return true;
        }
        return super.onAttribute(token, refErr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Acceptor createChildAcceptor(StartTagInfo sti, StringRef refErr) {
        Expression contentModel;
        String type = sti.getAttribute(XSINamespace, "type");
        String nil = sti.getAttribute(XSINamespace, "nil");
        if (type == null && nil == null) {
            return super.createChildAcceptor(sti, refErr);
        }
        this._docDecl.getCCCEC().get(this.getExpression(), sti, true);
        switch (this._docDecl.getCCCEC().numMatchedElements()) {
            case 0: {
                return super.createChildAcceptor(sti, refErr);
            }
            case 1: {
                break;
            }
            default: {
                return super.createChildAcceptor(sti, refErr);
            }
        }
        ElementExp element = this._docDecl.getCCCEC().getMatchedElements()[0];
        if (!(element instanceof ElementDeclExp.XSElementExp)) {
            return super.createChildAcceptor(sti, refErr);
        }
        ElementDeclExp.XSElementExp xe = (ElementDeclExp.XSElementExp)element;
        if (nil != null) {
            if (!xe.parent.isNillable) {
                if (refErr == null) {
                    return null;
                }
                refErr.str = this._docDecl.localizeMessage("XMLSchemaVerifier.NonNillableElement", sti.qName);
                return new XSAcceptor(this._docDecl, Expression.epsilon, (ElementExp)xe, null);
            }
            if (nil.trim().equals("true")) {
                if (!Debug.debug) return new XSAcceptor(this._docDecl, Expression.epsilon, (ElementExp)xe, null);
                System.out.println("xsi:nil is found");
                return new XSAcceptor(this._docDecl, Expression.epsilon, (ElementExp)xe, null);
            }
        }
        if (type == null) {
            return super.createChildAcceptor(sti, refErr);
        }
        String[] typeName = (String[])QnameType.theInstance.createJavaObject(type, sti.context);
        if (typeName == null) {
            return this.onTypeResolutionFailure(sti, type, refErr);
        }
        if (typeName[0].equals(XMLSchemaNamespace)) {
            try {
                contentModel = this._docDecl.grammar.getPool().createData(DatatypeFactory.getTypeByName(typeName[1]));
                return new XSAcceptor(this._docDecl, contentModel, (ElementExp)xe, null);
            }
            catch (DatatypeException e) {
                return this.onTypeResolutionFailure(sti, type, refErr);
            }
        } else {
            XMLSchemaSchema schema = this._docDecl.grammar.getByNamespace(typeName[0]);
            if (schema == null) {
                return this.onTypeResolutionFailure(sti, type, refErr);
            }
            XMLSchemaTypeExp currentType = xe.parent.getTypeDefinition();
            ComplexTypeExp cexp = schema.complexTypes.get(typeName[1]);
            if (cexp != null) {
                if (cexp.isDerivedTypeOf(currentType, xe.parent.block | currentType.getBlock())) {
                    contentModel = cexp;
                    return new XSAcceptor(this._docDecl, contentModel, (ElementExp)xe, null);
                } else {
                    if (!"anyType".equals(currentType.name) || !(currentType instanceof ComplexTypeExp) || !XMLSchemaNamespace.equals(((ComplexTypeExp)currentType).parent.targetNamespace)) return this.onNotSubstitutableType(sti, type, refErr);
                    contentModel = cexp;
                }
                return new XSAcceptor(this._docDecl, contentModel, (ElementExp)xe, null);
            } else {
                SimpleTypeExp sexp = schema.simpleTypes.get(typeName[1]);
                if (sexp == null) {
                    return this.onTypeResolutionFailure(sti, type, refErr);
                }
                if (!(currentType instanceof SimpleTypeExp)) {
                    return this.onNotSubstitutableType(sti, type, refErr);
                }
                SimpleTypeExp curT = (SimpleTypeExp)currentType;
                if (!sexp.getDatatype().isDerivedTypeOf(curT.getDatatype(), !xe.parent.isRestrictionBlocked())) return this.onNotSubstitutableType(sti, type, refErr);
                contentModel = sexp;
            }
        }
        return new XSAcceptor(this._docDecl, contentModel, (ElementExp)xe, null);
    }

    private Acceptor onNotSubstitutableType(StartTagInfo sti, String type, StringRef refErr) {
        if (refErr == null) {
            return null;
        }
        refErr.str = this._docDecl.localizeMessage("XMLSchemaVerifier.NotSubstitutableType", type);
        return super.createChildAcceptor(sti, refErr);
    }

    private Acceptor onTypeResolutionFailure(StartTagInfo sti, String type, StringRef refErr) {
        if (refErr == null) {
            return null;
        }
        refErr.str = this._docDecl.localizeMessage("XMLSchemaVerifier.UndefinedType", type);
        return super.createChildAcceptor(sti, refErr);
    }
}

