/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.apache.cxf.aegis.type.AegisType;
import org.apache.cxf.aegis.type.TypeCreator;
import org.apache.cxf.aegis.type.TypeMapping;
import org.apache.cxf.aegis.type.basic.Base64Type;
import org.apache.cxf.aegis.type.basic.BigDecimalType;
import org.apache.cxf.aegis.type.basic.BigIntegerType;
import org.apache.cxf.aegis.type.basic.BooleanType;
import org.apache.cxf.aegis.type.basic.ByteType;
import org.apache.cxf.aegis.type.basic.CalendarType;
import org.apache.cxf.aegis.type.basic.CharacterAsStringType;
import org.apache.cxf.aegis.type.basic.CharacterType;
import org.apache.cxf.aegis.type.basic.DateTimeType;
import org.apache.cxf.aegis.type.basic.DoubleType;
import org.apache.cxf.aegis.type.basic.FloatType;
import org.apache.cxf.aegis.type.basic.IntType;
import org.apache.cxf.aegis.type.basic.LongType;
import org.apache.cxf.aegis.type.basic.ObjectType;
import org.apache.cxf.aegis.type.basic.ShortType;
import org.apache.cxf.aegis.type.basic.SqlDateType;
import org.apache.cxf.aegis.type.basic.StringType;
import org.apache.cxf.aegis.type.basic.TimeType;
import org.apache.cxf.aegis.type.basic.TimestampType;
import org.apache.cxf.aegis.type.basic.URIType;
import org.apache.cxf.aegis.type.java5.DurationType;
import org.apache.cxf.aegis.type.java5.XMLGregorianCalendarType;
import org.apache.cxf.aegis.type.mtom.AbstractXOPType;
import org.apache.cxf.aegis.type.mtom.DataHandlerType;
import org.apache.cxf.aegis.type.mtom.DataSourceType;
import org.apache.cxf.aegis.type.xml.DocumentType;
import org.apache.cxf.aegis.type.xml.JDOMDocumentType;
import org.apache.cxf.aegis.type.xml.JDOMElementType;
import org.apache.cxf.aegis.type.xml.SourceType;
import org.apache.cxf.aegis.type.xml.XMLStreamReaderType;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.XMLSchemaQNames;
import org.w3c.dom.Document;

public class DefaultTypeMapping
implements TypeMapping {
    public static final String DEFAULT_MAPPING_URI = "urn:org.apache.cxf.aegis.types";
    private static final Logger LOG = LogUtils.getL7dLogger(DefaultTypeMapping.class);
    private Map<Type, AegisType> class2Type;
    private Map<QName, AegisType> xml2Type;
    private Map<Type, QName> class2xml;
    private TypeMapping nextTM;
    private TypeCreator typeCreator;
    private String identifierURI;

    public DefaultTypeMapping(String identifierURI, TypeMapping defaultTM) {
        this(identifierURI);
        this.nextTM = defaultTM;
    }

    public DefaultTypeMapping() {
        this(DEFAULT_MAPPING_URI);
    }

    public DefaultTypeMapping(String identifierURI) {
        this.identifierURI = identifierURI == null ? DEFAULT_MAPPING_URI : identifierURI;
        this.class2Type = Collections.synchronizedMap(new HashMap());
        this.class2xml = Collections.synchronizedMap(new HashMap());
        this.xml2Type = Collections.synchronizedMap(new HashMap());
    }

    public boolean isRegistered(Type javaType) {
        boolean registered = this.class2Type.containsKey(javaType);
        if (!registered && this.nextTM != null) {
            registered = this.nextTM.isRegistered(javaType);
        }
        return registered;
    }

    public boolean isRegistered(QName xmlType) {
        boolean registered = this.xml2Type.containsKey(xmlType);
        if (!registered && this.nextTM != null) {
            registered = this.nextTM.isRegistered(xmlType);
        }
        return registered;
    }

    public void register(Type javaType, QName xmlType, AegisType type) {
        type.setSchemaType(xmlType);
        type.setTypeClass(javaType);
        this.register(type);
    }

    public void register(AegisType type) {
        type.setTypeMapping(this);
        if (type.getType() != null) {
            this.class2xml.put(type.getType(), type.getSchemaType());
            this.class2Type.put(type.getType(), type);
        }
        if (type.getSchemaType() != null) {
            this.xml2Type.put(type.getSchemaType(), type);
        }
        if (type.getType() == null && type.getSchemaType() == null) {
            LOG.warning("The type " + type.getClass().getName() + " supports neither serialization (non-null TypeClass)" + " nor deserialization (non-null SchemaType).");
        }
    }

    public void removeType(AegisType type) {
        if (!this.xml2Type.containsKey(type.getSchemaType())) {
            this.nextTM.removeType(type);
        } else {
            this.xml2Type.remove(type.getSchemaType());
            this.class2Type.remove(type.getType());
            this.class2xml.remove(type.getType());
        }
    }

    public AegisType getType(Type javaType) {
        AegisType type = this.class2Type.get(javaType);
        if (type == null && this.nextTM != null) {
            type = this.nextTM.getType(javaType);
        }
        return type;
    }

    public AegisType getType(QName xmlType) {
        AegisType type = this.xml2Type.get(xmlType);
        if (type == null && this.nextTM != null) {
            type = this.nextTM.getType(xmlType);
        }
        return type;
    }

    public QName getTypeQName(Type clazz) {
        QName qname2 = this.class2xml.get(clazz);
        if (qname2 == null && this.nextTM != null) {
            qname2 = this.nextTM.getTypeQName(clazz);
        }
        return qname2;
    }

    public TypeCreator getTypeCreator() {
        return this.typeCreator;
    }

    public void setTypeCreator(TypeCreator typeCreator) {
        this.typeCreator = typeCreator;
        typeCreator.setTypeMapping(this);
    }

    public TypeMapping getParent() {
        return this.nextTM;
    }

    private static void defaultRegister(TypeMapping tm, boolean defaultNillable, Class class1, QName name, AegisType type) {
        if (!defaultNillable) {
            type.setNillable(false);
        }
        tm.register(class1, name, type);
    }

    private static void fillStandardMappings(TypeMapping tm, boolean defaultNillable, boolean enableMtomXmime, boolean enableJDOM) {
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, BigDecimal.class, XMLSchemaQNames.XSD_DECIMAL, new BigDecimalType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, BigInteger.class, XMLSchemaQNames.XSD_INTEGER, new BigIntegerType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, Boolean.class, XMLSchemaQNames.XSD_BOOLEAN, new BooleanType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, Calendar.class, XMLSchemaQNames.XSD_DATETIME, new CalendarType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, java.util.Date.class, XMLSchemaQNames.XSD_DATETIME, new DateTimeType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, Float.class, XMLSchemaQNames.XSD_FLOAT, new FloatType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, Double.class, XMLSchemaQNames.XSD_DOUBLE, new DoubleType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, Integer.class, XMLSchemaQNames.XSD_INT, new IntType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, Long.class, XMLSchemaQNames.XSD_LONG, new LongType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, Object.class, XMLSchemaQNames.XSD_ANY, new ObjectType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, Byte.class, XMLSchemaQNames.XSD_BYTE, new ByteType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, Short.class, XMLSchemaQNames.XSD_SHORT, new ShortType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, Source.class, XMLSchemaQNames.XSD_ANY, new SourceType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, String.class, XMLSchemaQNames.XSD_STRING, new StringType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, Time.class, XMLSchemaQNames.XSD_TIME, new TimeType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, Timestamp.class, XMLSchemaQNames.XSD_DATETIME, new TimestampType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, URI.class, XMLSchemaQNames.XSD_URI, new URIType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, XMLStreamReader.class, XMLSchemaQNames.XSD_ANY, new XMLStreamReaderType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, Boolean.TYPE, XMLSchemaQNames.XSD_BOOLEAN, new BooleanType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, byte[].class, XMLSchemaQNames.XSD_BASE64, new Base64Type());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, Double.TYPE, XMLSchemaQNames.XSD_DOUBLE, new DoubleType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, Float.TYPE, XMLSchemaQNames.XSD_FLOAT, new FloatType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, Integer.TYPE, XMLSchemaQNames.XSD_INT, new IntType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, Short.TYPE, XMLSchemaQNames.XSD_SHORT, new ShortType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, Byte.TYPE, XMLSchemaQNames.XSD_BYTE, new ByteType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, Long.TYPE, XMLSchemaQNames.XSD_LONG, new LongType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, Date.class, XMLSchemaQNames.XSD_DATETIME, new SqlDateType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, Date.class, XMLSchemaQNames.XSD_DATE, new SqlDateType());
        QName mtomBase64 = XMLSchemaQNames.XSD_BASE64;
        if (enableMtomXmime) {
            mtomBase64 = AbstractXOPType.XML_MIME_BASE64;
        }
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, DataSource.class, mtomBase64, new DataSourceType(enableMtomXmime, null));
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, DataHandler.class, mtomBase64, new DataHandlerType(enableMtomXmime, null));
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, Document.class, XMLSchemaQNames.XSD_ANY, new DocumentType());
        if (enableJDOM) {
            DefaultTypeMapping.registerJDOMTypes(tm, defaultNillable);
        }
    }

    private static void registerJDOMTypes(TypeMapping tm, boolean defaultNillable) {
        try {
            Class<?> jdomDocClass = ClassLoaderUtils.loadClass("org.jdom.Document", DefaultTypeMapping.class);
            DefaultTypeMapping.defaultRegister(tm, defaultNillable, jdomDocClass, XMLSchemaQNames.XSD_ANY, new JDOMDocumentType());
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            Class<?> jdomElementClass = ClassLoaderUtils.loadClass("org.jdom.Element", DefaultTypeMapping.class);
            DefaultTypeMapping.defaultRegister(tm, defaultNillable, jdomElementClass, XMLSchemaQNames.XSD_ANY, new JDOMElementType());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static DefaultTypeMapping createSoap11TypeMapping(boolean defaultNillable, boolean enableMtomXmime) {
        return DefaultTypeMapping.createSoap11TypeMapping(defaultNillable, enableMtomXmime, false);
    }

    public static DefaultTypeMapping createSoap11TypeMapping(boolean defaultNillable, boolean enableMtomXmime, boolean enableJDOM) {
        DefaultTypeMapping soapTM = new DefaultTypeMapping("http://schemas.xmlsoap.org/soap/encoding/");
        DefaultTypeMapping.fillStandardMappings(soapTM, defaultNillable, enableMtomXmime, enableJDOM);
        DefaultTypeMapping.defaultRegister(soapTM, defaultNillable, Boolean.TYPE, Soap11.ENCODED_BOOLEAN, new BooleanType());
        DefaultTypeMapping.defaultRegister(soapTM, defaultNillable, Character.TYPE, Soap11.ENCODED_CHAR, new CharacterType());
        DefaultTypeMapping.defaultRegister(soapTM, defaultNillable, Integer.TYPE, Soap11.ENCODED_INT, new IntType());
        DefaultTypeMapping.defaultRegister(soapTM, defaultNillable, Short.TYPE, Soap11.ENCODED_SHORT, new ShortType());
        DefaultTypeMapping.defaultRegister(soapTM, defaultNillable, Double.TYPE, Soap11.ENCODED_DOUBLE, new DoubleType());
        DefaultTypeMapping.defaultRegister(soapTM, defaultNillable, Float.TYPE, Soap11.ENCODED_FLOAT, new FloatType());
        DefaultTypeMapping.defaultRegister(soapTM, defaultNillable, Long.TYPE, Soap11.ENCODED_LONG, new LongType());
        DefaultTypeMapping.defaultRegister(soapTM, defaultNillable, Character.TYPE, Soap11.ENCODED_CHAR, new CharacterType());
        DefaultTypeMapping.defaultRegister(soapTM, defaultNillable, Character.class, Soap11.ENCODED_CHAR, new CharacterType());
        DefaultTypeMapping.defaultRegister(soapTM, defaultNillable, String.class, Soap11.ENCODED_STRING, new StringType());
        DefaultTypeMapping.defaultRegister(soapTM, defaultNillable, Boolean.class, Soap11.ENCODED_BOOLEAN, new BooleanType());
        DefaultTypeMapping.defaultRegister(soapTM, defaultNillable, Integer.class, Soap11.ENCODED_INT, new IntType());
        DefaultTypeMapping.defaultRegister(soapTM, defaultNillable, Short.class, Soap11.ENCODED_SHORT, new ShortType());
        DefaultTypeMapping.defaultRegister(soapTM, defaultNillable, Double.class, Soap11.ENCODED_DOUBLE, new DoubleType());
        DefaultTypeMapping.defaultRegister(soapTM, defaultNillable, Float.class, Soap11.ENCODED_FLOAT, new FloatType());
        DefaultTypeMapping.defaultRegister(soapTM, defaultNillable, Long.class, Soap11.ENCODED_LONG, new LongType());
        DefaultTypeMapping.defaultRegister(soapTM, defaultNillable, java.util.Date.class, Soap11.ENCODED_DATETIME, new DateTimeType());
        DefaultTypeMapping.defaultRegister(soapTM, defaultNillable, Date.class, Soap11.ENCODED_DATETIME, new SqlDateType());
        DefaultTypeMapping.defaultRegister(soapTM, defaultNillable, Calendar.class, Soap11.ENCODED_DATETIME, new CalendarType());
        DefaultTypeMapping.defaultRegister(soapTM, defaultNillable, byte[].class, Soap11.ENCODED_BASE64, new Base64Type());
        DefaultTypeMapping.defaultRegister(soapTM, defaultNillable, BigDecimal.class, Soap11.ENCODED_DECIMAL, new BigDecimalType());
        DefaultTypeMapping.defaultRegister(soapTM, defaultNillable, BigInteger.class, Soap11.ENCODED_INTEGER, new BigIntegerType());
        return soapTM;
    }

    public static DefaultTypeMapping createDefaultTypeMapping(boolean defaultNillable, boolean enableMtomXmime) {
        return DefaultTypeMapping.createDefaultTypeMapping(defaultNillable, enableMtomXmime, false);
    }

    public static DefaultTypeMapping createDefaultTypeMapping(boolean defaultNillable, boolean enableMtomXmime, boolean enableJDOM) {
        DefaultTypeMapping tm = new DefaultTypeMapping("http://www.w3.org/2001/XMLSchema");
        DefaultTypeMapping.fillStandardMappings(tm, defaultNillable, enableMtomXmime, enableJDOM);
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, Character.class, CharacterAsStringType.CHARACTER_AS_STRING_TYPE_QNAME, new CharacterAsStringType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, Character.TYPE, CharacterAsStringType.CHARACTER_AS_STRING_TYPE_QNAME, new CharacterAsStringType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, Duration.class, XMLSchemaQNames.XSD_DURATION, new DurationType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, XMLGregorianCalendar.class, XMLSchemaQNames.XSD_DATE, new XMLGregorianCalendarType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, XMLGregorianCalendar.class, XMLSchemaQNames.XSD_TIME, new XMLGregorianCalendarType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, XMLGregorianCalendar.class, XMLSchemaQNames.XSD_G_DAY, new XMLGregorianCalendarType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, XMLGregorianCalendar.class, XMLSchemaQNames.XSD_G_MONTH, new XMLGregorianCalendarType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, XMLGregorianCalendar.class, XMLSchemaQNames.XSD_G_MONTH_DAY, new XMLGregorianCalendarType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, XMLGregorianCalendar.class, XMLSchemaQNames.XSD_G_YEAR, new XMLGregorianCalendarType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, XMLGregorianCalendar.class, XMLSchemaQNames.XSD_G_YEAR_MONTH, new XMLGregorianCalendarType());
        DefaultTypeMapping.defaultRegister(tm, defaultNillable, XMLGregorianCalendar.class, XMLSchemaQNames.XSD_DATETIME, new XMLGregorianCalendarType());
        return tm;
    }

    public String getMappingIdentifierURI() {
        return this.identifierURI;
    }

    public void setMappingIdentifierURI(String uri) {
        this.identifierURI = uri;
    }
}

