/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.xml.jdom;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.aegis.util.stax.JDOMNamespaceContext;
import org.apache.cxf.aegis.xml.AbstractMessageWriter;
import org.apache.cxf.aegis.xml.MessageWriter;
import org.apache.cxf.aegis.xml.jdom.AttributeWriter;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;

public class JDOMWriter
extends AbstractMessageWriter {
    private Element element;

    public JDOMWriter(Element element) {
        this.element = element;
    }

    public void writeValue(Object value) {
        if (value != null) {
            this.element.addContent(value.toString());
        }
    }

    public void writeValue(Object value, String ns, String attr) {
        String prefix = JDOMWriter.getUniquePrefix(this.element, ns);
        this.element.setAttribute(new Attribute(attr, value.toString(), Namespace.getNamespace(prefix, ns)));
    }

    public MessageWriter getElementWriter(String name) {
        return this.getElementWriter(name, this.element.getNamespaceURI());
    }

    public MessageWriter getElementWriter(String name, String namespace) {
        String prefix = JDOMWriter.getUniquePrefix(this.element, namespace);
        Element child = new Element(name, Namespace.getNamespace(prefix, namespace));
        this.element.addContent(child);
        return new JDOMWriter(child);
    }

    public MessageWriter getElementWriter(QName qname2) {
        return this.getElementWriter(qname2.getLocalPart(), qname2.getNamespaceURI());
    }

    public String getPrefixForNamespace(String namespace) {
        return JDOMWriter.getUniquePrefix(this.element, namespace);
    }

    public XMLStreamWriter getXMLStreamWriter() {
        throw new UnsupportedOperationException("Stream writing not supported from a W3CDOMWriter.");
    }

    public String getPrefixForNamespace(String namespace, String hint) {
        return JDOMWriter.getUniquePrefix(this.element, namespace);
    }

    public MessageWriter getAttributeWriter(String name) {
        Attribute att = new Attribute(name, "", this.element.getNamespace());
        this.element.setAttribute(att);
        return new AttributeWriter(att);
    }

    public MessageWriter getAttributeWriter(String name, String namespace) {
        Attribute att;
        if (namespace != null && namespace.length() > 0) {
            String prefix = JDOMWriter.getUniquePrefix(this.element, namespace);
            att = new Attribute(name, "", Namespace.getNamespace(prefix, namespace));
        } else {
            att = new Attribute(name, "");
        }
        this.element.setAttribute(att);
        return new AttributeWriter(att);
    }

    public MessageWriter getAttributeWriter(QName qname2) {
        return this.getAttributeWriter(qname2.getLocalPart(), qname2.getNamespaceURI());
    }

    public void close() {
    }

    private static String getUniquePrefix(Element el) {
        int n = 1;
        String nsPrefix;
        while (el.getNamespace(nsPrefix = "ns" + n) != null) {
            ++n;
        }
        return nsPrefix;
    }

    private static String getUniquePrefix(Element element, String namespaceURI) {
        String prefix = JDOMNamespaceContext.rawGetPrefix(element, namespaceURI);
        if (prefix == null) {
            if ("".equals(namespaceURI)) {
                return "";
            }
            prefix = JDOMWriter.getUniquePrefix(element);
            element.addNamespaceDeclaration(Namespace.getNamespace(prefix, namespaceURI));
        }
        return prefix;
    }
}

