/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.codehaus.jra.ResourceUtil;

public class URIMapper {
    private List<ResourceInfo> resources = new ArrayList<ResourceInfo>();
    private Map<OperationInfo, String> locations = new HashMap<OperationInfo, String>();
    private Map<OperationInfo, String> verbs = new HashMap<OperationInfo, String>();

    public BindingOperationInfo getOperation(String uri, String verb, Message m) {
        ArrayList<ResourceInfo> bestMatch = new ArrayList<ResourceInfo>();
        int bestScore = 0;
        for (ResourceInfo r : this.resources) {
            if (!r.getVerb().equals(verb)) continue;
            int newScore = ResourceUtil.getMatchScore(uri, r.getUri());
            if (newScore > bestScore) {
                bestMatch.clear();
                bestScore = newScore;
            }
            if (newScore < bestScore) continue;
            bestMatch.add(r);
        }
        if (bestScore > -1 && !bestMatch.isEmpty()) {
            if (bestMatch.size() == 1) {
                return ((ResourceInfo)bestMatch.get(0)).getOperation();
            }
            bestScore = -1;
            ResourceInfo newBest = null;
            for (ResourceInfo r : bestMatch) {
                int newScore;
                String newUri = r.getUri();
                if (newUri.charAt(newUri.length() - 1) == '}') {
                    newUri = newUri.substring(0, newUri.lastIndexOf(123));
                }
                if ((newScore = ResourceUtil.getMatchScore(uri, newUri)) <= bestScore) continue;
                bestScore = newScore;
                newBest = r;
            }
            return newBest.getOperation();
        }
        return null;
    }

    public void bind(BindingOperationInfo bop, String uri, String verb) {
        ResourceInfo info = new ResourceInfo();
        info.setUri(uri);
        info.setVerb(verb);
        info.setOperation(bop);
        this.locations.put(bop.getOperationInfo(), uri);
        this.verbs.put(bop.getOperationInfo(), verb);
        if (bop.getOperationInfo().getUnwrappedOperation() != null) {
            this.locations.put(bop.getUnwrappedOperation().getOperationInfo(), uri);
            this.verbs.put(bop.getUnwrappedOperation().getOperationInfo(), verb);
        }
        this.resources.add(info);
    }

    public String getLocation(BindingOperationInfo bop) {
        return this.locations.get(bop.getOperationInfo());
    }

    public String getVerb(BindingOperationInfo bop) {
        return this.verbs.get(bop.getOperationInfo());
    }

    public List getParameters(MessageInfo msgInfo, String path) {
        String resource = this.locations.get(msgInfo.getOperation());
        Map<String, String> paramMap = ResourceUtil.getURIParameters(path, resource);
        ArrayList<String> params = new ArrayList<String>(msgInfo.getMessageParts().size());
        int i = 0;
        for (MessagePartInfo p : msgInfo.getMessageParts()) {
            params.add(i, paramMap.get(p.getName().getLocalPart()));
            ++i;
        }
        return params;
    }

    public static class ResourceInfo {
        private String uri;
        private String verb;
        private BindingOperationInfo operation;

        public BindingOperationInfo getOperation() {
            return this.operation;
        }

        public void setOperation(BindingOperationInfo operation) {
            this.operation = operation;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public String getVerb() {
            return this.verb;
        }

        public void setVerb(String verb) {
            this.verb = verb;
        }
    }
}

