/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.discovery.local;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalDiscoveryUtils {
    private static final Logger LOG = Logger.getLogger(LocalDiscoveryUtils.class.getName());
    private static final String REMOTE_SERVICES_HEADER_NAME = "Remote-Service";
    private static final String REMOTE_SERVICES_DIRECTORY = "OSGI-INF/remote-service/";
    private static final String REMOTE_SERVICES_NS = "http://www.osgi.org/xmlns/sd/v1.0.0";
    private static final String REMOTE_SERVICES_ADMIN_NS = "http://www.osgi.org/xmlns/rsa/v1.0.0";
    private static final String SERVICE_DESCRIPTION_ELEMENT = "service-description";
    private static final String ENDPOINT_DESCRIPTION_ELEMENT = "endpoint-description";
    private static final String PROVIDE_INTERFACE_ELEMENT = "provide";
    private static final String PROVIDE_INTERFACE_NAME_ATTRIBUTE = "interface";
    private static final String PROPERTY_ELEMENT = "property";
    private static final String PROPERTY_NAME_ATTRIBUTE = "name";
    private static final String PROPERTY_VALUE_ATTRIBUTE = "value";
    private static final String PROPERTY_VALUE_TYPE_ATTRIBUTE = "value-type";
    private static final String PROPERTY_INTERFACE_ATTRIBUTE = "interface";
    private static final String INTERFACE_SEPARATOR = ":";
    static boolean addEndpointID = true;

    private LocalDiscoveryUtils() {
    }

    public static List<EndpointDescription> getAllEndpointDescriptions(Bundle b) {
        List<Element> elements = LocalDiscoveryUtils.getAllDescriptionElements(b);
        ArrayList<EndpointDescription> eds = new ArrayList<EndpointDescription>(elements.size());
        for (Element el : elements) {
            if (ENDPOINT_DESCRIPTION_ELEMENT.equals(el.getName())) {
                eds.add(LocalDiscoveryUtils.getEndpointDescription(el));
                continue;
            }
            if (!SERVICE_DESCRIPTION_ELEMENT.equals(el.getName())) continue;
            eds.add(LocalDiscoveryUtils.getLegacyEndpointDescription(el));
        }
        return eds;
    }

    public static EndpointDescription getEndpointDescription(Element endpointDescriptionElement) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List properties = endpointDescriptionElement.getChildren(PROPERTY_ELEMENT, Namespace.getNamespace(REMOTE_SERVICES_ADMIN_NS));
        for (Element prop : properties) {
            boolean handled = LocalDiscoveryUtils.handleArray(prop, map);
            if (handled || (handled = LocalDiscoveryUtils.handleCollection(prop, map)) || (handled = LocalDiscoveryUtils.handleXML(prop, map))) continue;
            String name = prop.getAttributeValue(PROPERTY_NAME_ATTRIBUTE);
            String value = prop.getAttributeValue(PROPERTY_VALUE_ATTRIBUTE);
            if (value == null) {
                value = prop.getText();
            }
            String type = LocalDiscoveryUtils.getTypeName(prop);
            map.put(name, LocalDiscoveryUtils.instantiate(type, value));
        }
        return new EndpointDescription(map);
    }

    private static EndpointDescription getLegacyEndpointDescription(Element el) {
        Object uri;
        Namespace ns = Namespace.getNamespace(REMOTE_SERVICES_NS);
        List<String> iNames = LocalDiscoveryUtils.getProvidedInterfaces(el.getChildren(PROVIDE_INTERFACE_ELEMENT, ns));
        Map<String, Object> remoteProps = LocalDiscoveryUtils.getProperties(el.getChildren(PROPERTY_ELEMENT, ns));
        if (remoteProps.get("objectClass") == null) {
            remoteProps.put("objectClass", iNames.toArray(new String[0]));
        }
        if ((uri = remoteProps.get("org.apache.cxf.ws.address")) == null) {
            uri = remoteProps.get("osgi.remote.configuration.pojo.address");
        }
        if (uri == null) {
            String firstIntf = iNames.get(0);
            uri = "http://localhost:9000/" + firstIntf.replace('.', '/');
        }
        remoteProps.put("endpoint.id", uri.toString());
        Object exportedConfigs = remoteProps.get("service.exported.configs");
        if (exportedConfigs == null) {
            exportedConfigs = "org.apache.cxf.ws";
        }
        remoteProps.put("service.imported.configs", exportedConfigs);
        Iterator<String> it = remoteProps.keySet().iterator();
        while (it.hasNext()) {
            if (!it.next().startsWith("service.exported.")) continue;
            it.remove();
        }
        return new EndpointDescription(remoteProps);
    }

    private static String getTypeName(Element prop) {
        String type = prop.getAttributeValue(PROPERTY_VALUE_TYPE_ATTRIBUTE);
        if (type == null) {
            type = "String";
        }
        return type;
    }

    private static boolean handleArray(Element prop, Map<String, Object> map) {
        Element arrayEl = prop.getChild("array", Namespace.getNamespace(REMOTE_SERVICES_ADMIN_NS));
        if (arrayEl == null) {
            return false;
        }
        List values = arrayEl.getChildren(PROPERTY_VALUE_ATTRIBUTE, Namespace.getNamespace(REMOTE_SERVICES_ADMIN_NS));
        String type = LocalDiscoveryUtils.getTypeName(prop);
        Class<Constable> cls = null;
        if ("long".equals(type)) {
            cls = Long.TYPE;
        } else if ("double".equals(type)) {
            cls = Double.TYPE;
        } else if ("float".equals(type)) {
            cls = Float.TYPE;
        } else if ("int".equals(type)) {
            cls = Integer.TYPE;
        } else if ("byte".equals(type)) {
            cls = Byte.TYPE;
        } else if ("boolean".equals(type)) {
            cls = Boolean.TYPE;
        } else if ("short".equals(type)) {
            cls = Short.TYPE;
        }
        try {
            if (cls == null) {
                cls = ClassLoader.getSystemClassLoader().loadClass("java.lang." + type);
            }
            Object array = Array.newInstance(cls, values.size());
            for (int i = 0; i < values.size(); ++i) {
                Element vEl = (Element)values.get(i);
                Object val = LocalDiscoveryUtils.handleValue(vEl, type);
                Array.set(array, i, val);
            }
            String name = prop.getAttributeValue(PROPERTY_NAME_ATTRIBUTE);
            map.put(name, array);
            return true;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Could not create array for Endpoint Description", e);
            return false;
        }
    }

    private static boolean handleCollection(Element prop, Map<String, Object> map) {
        AbstractCollection col = null;
        Element el = prop.getChild("list", Namespace.getNamespace(REMOTE_SERVICES_ADMIN_NS));
        if (el != null) {
            col = new ArrayList();
        } else {
            el = prop.getChild("set", Namespace.getNamespace(REMOTE_SERVICES_ADMIN_NS));
            if (el != null) {
                col = new HashSet();
            }
        }
        if (el == null) {
            return false;
        }
        String type = LocalDiscoveryUtils.getTypeName(prop);
        List values = el.getChildren(PROPERTY_VALUE_ATTRIBUTE, Namespace.getNamespace(REMOTE_SERVICES_ADMIN_NS));
        for (Element val : values) {
            Object obj = LocalDiscoveryUtils.handleValue(val, type);
            col.add(obj);
        }
        String name = prop.getAttributeValue(PROPERTY_NAME_ATTRIBUTE);
        map.put(name, col);
        return true;
    }

    private static boolean handleXML(Element prop, Map<String, Object> map) {
        String sb = LocalDiscoveryUtils.readXML(prop);
        if (sb == null) {
            return false;
        }
        String name = prop.getAttributeValue(PROPERTY_NAME_ATTRIBUTE);
        map.put(name, sb);
        return true;
    }

    private static String readXML(Element prop) {
        Element el = prop.getChild("xml", Namespace.getNamespace(REMOTE_SERVICES_ADMIN_NS));
        if (el == null) {
            return null;
        }
        String type = LocalDiscoveryUtils.getTypeName(prop);
        if (!"String".equals(type)) {
            LOG.warning("Embedded XML must be of type String, found: " + type);
            return null;
        }
        XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat());
        StringBuilder sb = new StringBuilder();
        List children = el.getChildren();
        for (Element child : children) {
            sb.append(outputter.outputString(child));
        }
        return sb.toString();
    }

    private static Object handleValue(Element val, String type) {
        String xml = LocalDiscoveryUtils.readXML(val);
        if (xml != null) {
            return xml;
        }
        return LocalDiscoveryUtils.instantiate(type, val.getText());
    }

    private static Object instantiate(String type, String value) {
        if ("String".equals(type)) {
            return value;
        }
        value = value.trim();
        String boxedType = null;
        if ("long".equals(type)) {
            boxedType = "Long";
        } else if ("double".equals(type)) {
            boxedType = "Double";
        } else if ("float".equals(type)) {
            boxedType = "Float";
        } else if ("int".equals(type)) {
            boxedType = "Integer";
        } else if ("byte".equals(type)) {
            boxedType = "Byte";
        } else if ("char".equals(type)) {
            boxedType = "Character";
        } else if ("boolean".equals(type)) {
            boxedType = "Boolean";
        } else if ("short".equals(type)) {
            boxedType = "Short";
        }
        if (boxedType == null) {
            boxedType = type;
        }
        String javaType = "java.lang." + boxedType;
        try {
            if (boxedType.equals("Character")) {
                return new Character(value.charAt(0));
            }
            Class<?> cls = ClassLoader.getSystemClassLoader().loadClass(javaType);
            Constructor<?> ctor = cls.getConstructor(String.class);
            return ctor.newInstance(value);
        }
        catch (Exception e) {
            LOG.warning("Could not create Endpoint Property of type " + type + " and value " + value);
            return null;
        }
    }

    static List<Element> getAllDescriptionElements(Bundle b) {
        String header = null;
        Dictionary headers = b.getHeaders();
        if (headers != null) {
            header = (String)headers.get(REMOTE_SERVICES_HEADER_NAME);
        }
        if (header == null) {
            header = REMOTE_SERVICES_DIRECTORY;
        }
        String dir = header.toString();
        String filePattern = "*.xml";
        if (dir.endsWith("/")) {
            dir = dir.substring(0, dir.length() - 1);
        } else {
            int idx = dir.lastIndexOf(47);
            if (idx >= 0 & dir.length() > idx) {
                filePattern = dir.substring(idx + 1);
                dir = dir.substring(0, idx);
            } else {
                filePattern = dir;
                dir = "";
            }
        }
        Enumeration urls = b.findEntries(dir, filePattern, false);
        if (urls == null) {
            return Collections.emptyList();
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        while (urls.hasMoreElements()) {
            URL resourceURL = (URL)urls.nextElement();
            try {
                elements.addAll(LocalDiscoveryUtils.getElements(resourceURL.openStream()));
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Problem parsing: " + resourceURL, ex);
            }
        }
        return elements;
    }

    private static Map<String, Object> getProperties(List<Element> elements) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (Element p : elements) {
            String key = p.getAttributeValue(PROPERTY_NAME_ATTRIBUTE);
            String value = p.getAttributeValue(PROPERTY_VALUE_ATTRIBUTE);
            if (value == null) {
                value = p.getTextTrim();
            }
            String iface = p.getAttributeValue("interface");
            if (key == null) continue;
            props.put(iface == null || iface.length() == 0 ? key : key + INTERFACE_SEPARATOR + iface, value);
        }
        return props;
    }

    private static List<String> getProvidedInterfaces(List<Element> elements) {
        ArrayList<String> names = new ArrayList<String>();
        for (Element p : elements) {
            String name = p.getAttributeValue("interface");
            if (name == null) continue;
            names.add(name);
        }
        return names;
    }

    public static List<String> getStringPlusProperty(ServiceReference sr, String key) {
        Object value = sr.getProperty(key);
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof String) {
            return Collections.singletonList((String)value);
        }
        if (value instanceof String[]) {
            String[] values = (String[])value;
            ArrayList<String> result = new ArrayList<String>(values.length);
            for (String v : values) {
                if (v == null) continue;
                result.add(v);
            }
            return Collections.unmodifiableList(result);
        }
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            ArrayList<String> result = new ArrayList<String>(values.size());
            for (Object v : values) {
                if (v == null || !(v instanceof String)) continue;
                result.add((String)v);
            }
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    public static String getEndpointDescriptionXML(Map m) {
        Document d = new Document();
        Namespace ns = Namespace.getNamespace(REMOTE_SERVICES_ADMIN_NS);
        Element rootEl = new Element("endpoint-descriptions", ns);
        d.setRootElement(rootEl);
        Element contentEl = new Element(ENDPOINT_DESCRIPTION_ELEMENT, ns);
        rootEl.addContent(contentEl);
        for (Map.Entry entry : m.entrySet()) {
            String key = entry.getKey().toString();
            Object val = entry.getValue();
            Element propEl = new Element(PROPERTY_ELEMENT, ns);
            propEl.setAttribute(PROPERTY_NAME_ATTRIBUTE, key);
            if (val.getClass().isArray()) {
                Element arrayEl = new Element("array", ns);
                propEl.addContent(arrayEl);
                for (Object o : LocalDiscoveryUtils.normalizeArray(val)) {
                    LocalDiscoveryUtils.setValueType(propEl, o);
                    Element valueEl = new Element(PROPERTY_VALUE_ATTRIBUTE, ns);
                    arrayEl.addContent(valueEl);
                    valueEl.addContent(o.toString());
                }
            } else if (val instanceof List) {
                Element listEl = new Element("list", ns);
                propEl.addContent(listEl);
                LocalDiscoveryUtils.handleCollectionValue(ns, (Collection)val, propEl, listEl);
            } else if (val instanceof Set) {
                Element setEl = new Element("set", ns);
                propEl.addContent(setEl);
                LocalDiscoveryUtils.handleCollectionValue(ns, (Collection)val, propEl, setEl);
            } else {
                LocalDiscoveryUtils.setValueType(propEl, val);
                propEl.setAttribute(PROPERTY_VALUE_ATTRIBUTE, val.toString());
            }
            contentEl.addContent(propEl);
        }
        return new XMLOutputter(Format.getPrettyFormat()).outputString(d);
    }

    private static Object[] normalizeArray(Object val) {
        ArrayList<Serializable> l = new ArrayList<Serializable>();
        if (val instanceof int[]) {
            int[] ia;
            for (int i : ia = (int[])val) {
                l.add(Integer.valueOf(i));
            }
        } else if (val instanceof long[]) {
            long[] la;
            for (long i : la = (long[])val) {
                l.add(Long.valueOf(i));
            }
        } else if (val instanceof float[]) {
            float[] fa;
            for (float f : fa = (float[])val) {
                l.add(Float.valueOf(f));
            }
        } else if (val instanceof byte[]) {
            byte[] ba;
            for (byte b : ba = (byte[])val) {
                l.add(Byte.valueOf(b));
            }
        } else if (val instanceof boolean[]) {
            boolean[] ba;
            for (boolean b : ba = (boolean[])val) {
                l.add(Boolean.valueOf(b));
            }
        } else if (val instanceof short[]) {
            short[] sa;
            for (short s : sa = (short[])val) {
                l.add(Short.valueOf(s));
            }
        } else if (val instanceof char[]) {
            char[] ca;
            for (char c : ca = (char[])val) {
                l.add(Character.valueOf(c));
            }
        } else {
            return (Object[])val;
        }
        return l.toArray();
    }

    private static void handleCollectionValue(Namespace ns, Collection val, Element propEl, Element listEl) {
        for (Object o : val) {
            LocalDiscoveryUtils.setValueType(propEl, o);
            Element valueEl = new Element(PROPERTY_VALUE_ATTRIBUTE, ns);
            listEl.addContent(valueEl);
            valueEl.addContent(o.toString());
        }
    }

    private static void setValueType(Element propEl, Object val) {
        if (val instanceof String) {
            return;
        }
        String dataType = val.getClass().getName();
        if (dataType.startsWith("java.lang.")) {
            dataType = dataType.substring("java.lang.".length());
        }
        propEl.setAttribute(PROPERTY_VALUE_TYPE_ATTRIBUTE, dataType);
    }

    public static List<Element> getElements(InputStream in) throws JDOMException, IOException {
        ArrayList<Element> elements = new ArrayList<Element>();
        Document d = new SAXBuilder().build(in);
        if (d.getRootElement().getNamespaceURI().equals(REMOTE_SERVICES_ADMIN_NS)) {
            elements.addAll(d.getRootElement().getChildren(ENDPOINT_DESCRIPTION_ELEMENT, Namespace.getNamespace(REMOTE_SERVICES_ADMIN_NS)));
        }
        Namespace nsOld = Namespace.getNamespace(REMOTE_SERVICES_NS);
        elements.addAll(d.getRootElement().getChildren(SERVICE_DESCRIPTION_ELEMENT, nsOld));
        return elements;
    }
}

