/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.discovery.zookeeper;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.cxf.dosgi.discovery.zookeeper.EndpointListenerImpl;
import org.apache.cxf.dosgi.discovery.zookeeper.Util;
import org.apache.cxf.dosgi.discovery.zookeeper.ZooKeeperDiscovery;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.remoteserviceadmin.EndpointListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointListenerFactory
implements ServiceFactory {
    public static final String DISCOVERY_ZOOKEEPER_ID = "org.apache.cxf.dosgi.discovery.zookeeper";
    private Logger LOG = Logger.getLogger(EndpointListenerFactory.class.getName());
    private BundleContext bctx;
    private ZooKeeperDiscovery discovery;
    private List<EndpointListenerImpl> listeners = new ArrayList<EndpointListenerImpl>();
    private ServiceRegistration serviceRegistartion;

    public EndpointListenerFactory(ZooKeeperDiscovery zooKeeperDiscovery, BundleContext bctx) {
        this.bctx = bctx;
        this.discovery = zooKeeperDiscovery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(Bundle b, ServiceRegistration sr) {
        this.LOG.fine("new EndpointListener from factory");
        List<EndpointListenerImpl> list = this.listeners;
        synchronized (list) {
            EndpointListenerImpl epl = new EndpointListenerImpl(this.discovery, this.bctx);
            this.listeners.add(epl);
            return epl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ungetService(Bundle b, ServiceRegistration sr, Object s) {
        this.LOG.fine("remove EndpointListener");
        List<EndpointListenerImpl> list = this.listeners;
        synchronized (list) {
            if (this.listeners.contains(s)) {
                EndpointListenerImpl epl = (EndpointListenerImpl)s;
                epl.close();
                this.listeners.remove(epl);
            }
        }
    }

    public synchronized void start() {
        this.serviceRegistartion = this.bctx.registerService(EndpointListener.class.getName(), (Object)this, null);
        this.updateServiceRegistration();
    }

    private void updateServiceRegistration() {
        Properties props = new Properties();
        props.put("endpoint.listener.scope", "(&(objectClass=*)(endpoint.framework.uuid=" + Util.getUUID(this.bctx) + "))");
        props.put(DISCOVERY_ZOOKEEPER_ID, "true");
        this.serviceRegistartion.setProperties((Dictionary)props);
    }

    public synchronized void stop() {
        if (this.serviceRegistartion != null) {
            this.serviceRegistartion.unregister();
        }
        for (EndpointListenerImpl epl : this.listeners) {
            epl.close();
        }
    }

    protected List<EndpointListenerImpl> getListeners() {
        return this.listeners;
    }
}

