/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.discovery.zookeeper;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.dosgi.discovery.local.LocalDiscoveryUtils;
import org.apache.cxf.dosgi.discovery.zookeeper.Util;
import org.apache.cxf.dosgi.discovery.zookeeper.ZooKeeperDiscovery;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.osgi.framework.BundleContext;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointListener;

public class EndpointListenerImpl
implements EndpointListener {
    private Logger LOG = Logger.getLogger(EndpointListenerImpl.class.getName());
    private ZooKeeperDiscovery discovery;
    private BundleContext bctx;
    private List<EndpointDescription> endpoints = new ArrayList<EndpointDescription>();
    private boolean closed = false;

    public EndpointListenerImpl(ZooKeeperDiscovery zooKeeperDiscovery, BundleContext bctx) {
        this.bctx = bctx;
        this.discovery = zooKeeperDiscovery;
    }

    private ZooKeeper getZooKeeper() {
        return this.discovery.getZookeeper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endpointAdded(EndpointDescription endpoint, String matchedFilter) {
        this.LOG.info("endpointDescription added: " + endpoint);
        if (this.closed) {
            return;
        }
        List<EndpointDescription> list = this.endpoints;
        synchronized (list) {
            if (this.endpoints.contains(endpoint)) {
                return;
            }
            try {
                List<String> interfaces = endpoint.getInterfaces();
                String endpointKey = EndpointListenerImpl.getKey(endpoint.getId());
                ZooKeeper zk = this.getZooKeeper();
                for (String name : interfaces) {
                    String path = Util.getZooKeeperPath(name);
                    String fullPath = path + '/' + endpointKey;
                    this.LOG.info("Creating ZooKeeper node: " + fullPath);
                    EndpointListenerImpl.ensurePath(path, zk);
                    zk.create(fullPath, EndpointListenerImpl.getData(endpoint), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
                }
                this.endpoints.add(endpoint);
            }
            catch (Exception ex) {
                this.LOG.log(Level.SEVERE, "Exception while processing the addition of a ServicePublication.", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endpointRemoved(EndpointDescription endpoint, String matchedFilter) {
        this.LOG.info("endpointDescription removed: " + endpoint);
        if (this.closed) {
            return;
        }
        List<EndpointDescription> list = this.endpoints;
        synchronized (list) {
            if (!this.endpoints.contains(endpoint)) {
                return;
            }
            try {
                this.removeEndpoint(endpoint);
                this.endpoints.remove(endpoint);
            }
            catch (Exception ex) {
                this.LOG.log(Level.SEVERE, "Exception while processing the removal of a ServicePublication.", ex);
            }
        }
    }

    private void removeEndpoint(EndpointDescription endpoint) throws UnknownHostException, URISyntaxException, InterruptedException, KeeperException {
        List<String> interfaces = endpoint.getInterfaces();
        String endpointKey = EndpointListenerImpl.getKey(endpoint.getId());
        ZooKeeper zk = this.getZooKeeper();
        for (String name : interfaces) {
            String path = Util.getZooKeeperPath(name);
            String fullPath = path + '/' + endpointKey;
            this.LOG.fine("Removing ZooKeeper node: " + fullPath);
            zk.delete(fullPath, -1);
        }
    }

    private static void ensurePath(String path, ZooKeeper zk) throws KeeperException, InterruptedException {
        StringBuilder current = new StringBuilder();
        String[] tree = path.split("/");
        for (int i = 0; i < tree.length; ++i) {
            if (tree[i].length() == 0) continue;
            current.append('/');
            current.append(tree[i]);
            if (zk.exists(current.toString(), false) != null) continue;
            zk.create(current.toString(), new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
    }

    static byte[] getData(EndpointDescription sr) throws IOException {
        String s = LocalDiscoveryUtils.getEndpointDescriptionXML(sr.getProperties());
        return s.getBytes();
    }

    static String getKey(String endpoint) throws UnknownHostException, URISyntaxException {
        URI uri = new URI(endpoint);
        StringBuilder sb = new StringBuilder();
        sb.append(uri.getHost());
        sb.append("#");
        sb.append(uri.getPort());
        sb.append("#");
        sb.append(uri.getPath().replace('/', '#'));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.LOG.fine("removing all service publications");
        List<EndpointDescription> list = this.endpoints;
        synchronized (list) {
            for (EndpointDescription ed : this.endpoints) {
                try {
                    this.removeEndpoint(ed);
                }
                catch (Exception ex) {
                    this.LOG.log(Level.SEVERE, "Exception while processing the removal of a ServicePublication.", ex);
                }
            }
            this.endpoints.clear();
        }
    }
}

