/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.discovery.zookeeper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cxf.dosgi.discovery.zookeeper.InterfaceMonitor;
import org.apache.cxf.dosgi.discovery.zookeeper.Util;
import org.apache.cxf.dosgi.discovery.zookeeper.ZooKeeperDiscovery;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointListenerTrackerCustomizer
implements ServiceTrackerCustomizer {
    private static final Logger LOG = Logger.getLogger(EndpointListenerTrackerCustomizer.class.getName());
    private ZooKeeperDiscovery zooKeeperDiscovery;
    private static final Pattern OBJECTCLASS_PATTERN = Pattern.compile(".*\\(objectClass=([^)]+)\\).*");
    private Map<String, Interest> interestingScopes = new HashMap<String, Interest>();
    private Map<ServiceReference, List<String>> handledEndpointlisteners = new HashMap<ServiceReference, List<String>>();
    private BundleContext bctx;

    public EndpointListenerTrackerCustomizer(ZooKeeperDiscovery zooKeeperDiscovery, BundleContext bc) {
        this.zooKeeperDiscovery = zooKeeperDiscovery;
        this.bctx = bc;
    }

    @Override
    public Object addingService(ServiceReference sref) {
        LOG.fine("addingService: " + sref);
        this.handleEndpointListener(sref);
        return sref;
    }

    @Override
    public void modifiedService(ServiceReference sref, Object service) {
        LOG.fine("modifiedService: " + sref);
        this.handleEndpointListener(sref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEndpointListener(ServiceReference sref) {
        for (String key : sref.getPropertyKeys()) {
            LOG.finest("modifiedService: property: " + key + " => " + sref.getProperty(key));
        }
        if ("true".equals(sref.getProperty("org.apache.cxf.dosgi.discovery.zookeeper"))) {
            LOG.finest("found my own endpointListener ... skipping it");
            return;
        }
        String[] scopes = Util.getScopes(sref);
        LOG.info("trying to discover services for scopes[" + scopes.length + "]: ");
        if (scopes != null) {
            for (String scope : scopes) {
                LOG.info("Scope: " + scope);
            }
        }
        if (scopes.length > 0) {
            for (String scope : scopes) {
                LOG.fine("***********  Handling scope: " + scope);
                if ("".equals(scope) || scope == null) {
                    LOG.warning("skipping empty scope from EndpointListener from " + sref.getBundle().getSymbolicName());
                    continue;
                }
                String objClass = this.getObjectClass(scope);
                LOG.fine("***********  objectClass: " + objClass);
                Map<String, Interest> map = this.interestingScopes;
                synchronized (map) {
                    Map<ServiceReference, List<String>> map2 = this.handledEndpointlisteners;
                    synchronized (map2) {
                        Interest interest = this.interestingScopes.get(scope);
                        if (interest == null) {
                            interest = new Interest();
                            this.interestingScopes.put(scope, interest);
                        }
                        if (!interest.relatedServiceListeners.contains(sref)) {
                            interest.relatedServiceListeners.add(sref);
                        }
                        if (interest.im != null) {
                            interest.im.close();
                            interest.im = null;
                        }
                        InterfaceMonitor dm = this.createInterfaceMonitor(scope, objClass, interest);
                        dm.start();
                        interest.im = dm;
                        List<String> handledScopes = this.handledEndpointlisteners.get(sref);
                        if (handledScopes == null) {
                            handledScopes = new ArrayList<String>(1);
                            this.handledEndpointlisteners.put(sref, handledScopes);
                        }
                        if (!handledScopes.contains(scope)) {
                            handledScopes.add(scope);
                        }
                    }
                }
            }
        }
    }

    private String getObjectClass(String scope) {
        Matcher m = OBJECTCLASS_PATTERN.matcher(scope);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    @Override
    public void removedService(ServiceReference sref, Object service) {
        LOG.info("removedService: " + sref);
        List<String> handledScopes = this.handledEndpointlisteners.get(sref);
        if (handledScopes != null) {
            for (String scope : handledScopes) {
                Interest i = this.interestingScopes.get(scope);
                if (i == null) continue;
                i.relatedServiceListeners.remove(sref);
                if (i.relatedServiceListeners.size() != 0) continue;
                i.im.close();
                this.interestingScopes.remove(scope);
            }
            this.handledEndpointlisteners.remove(sref);
        }
    }

    protected Map<String, Interest> getInterestingScopes() {
        return this.interestingScopes;
    }

    protected Map<ServiceReference, List<String>> getHandledEndpointlisteners() {
        return this.handledEndpointlisteners;
    }

    protected InterfaceMonitor createInterfaceMonitor(String scope, String objClass, Interest interest) {
        InterfaceMonitor dm = new InterfaceMonitor(this.zooKeeperDiscovery.getZookeeper(), objClass, interest, scope, this.bctx);
        return dm;
    }

    protected static class Interest {
        List<ServiceReference> relatedServiceListeners = new ArrayList<ServiceReference>(1);
        InterfaceMonitor im;

        protected Interest() {
        }
    }
}

