/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.discovery.zookeeper;

import java.io.ByteArrayInputStream;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.dosgi.discovery.local.LocalDiscoveryUtils;
import org.apache.cxf.dosgi.discovery.zookeeper.DataMonitorListener;
import org.apache.cxf.dosgi.discovery.zookeeper.EndpointListenerTrackerCustomizer;
import org.apache.cxf.dosgi.discovery.zookeeper.InterfaceMonitor;
import org.apache.cxf.dosgi.discovery.zookeeper.Util;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.jdom.Element;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceDataMonitorListenerImpl
implements DataMonitorListener {
    private static final Logger LOG = Logger.getLogger(InterfaceDataMonitorListenerImpl.class.getName());
    final ZooKeeper zookeeper;
    final String znode;
    final String interFace;
    final EndpointListenerTrackerCustomizer.Interest discoveredServiceTracker;
    final String scope;
    final boolean recursive;
    final InterfaceMonitor parent;
    private final BundleContext bctx;
    private Map<String, Map<String, Object>> nodes = new HashMap<String, Map<String, Object>>();

    public InterfaceDataMonitorListenerImpl(ZooKeeper zk, String intf, EndpointListenerTrackerCustomizer.Interest dst, String scope, BundleContext bc, InterfaceMonitor interfaceMonitor) {
        this.parent = interfaceMonitor;
        this.zookeeper = zk;
        this.znode = Util.getZooKeeperPath(intf);
        this.recursive = intf == null || "".equals(intf);
        this.interFace = intf;
        this.discoveredServiceTracker = dst;
        this.bctx = bc;
        this.scope = scope;
        LOG.fine("InterfaceDataMonitorListenerImpl is recursive: " + this.recursive);
    }

    @Override
    public synchronized void change() {
        HashMap<String, Map<String, Object>> newNodes = new HashMap<String, Map<String, Object>>();
        Map<String, Map<String, Object>> prevNodes = this.nodes;
        LOG.info("Zookeeper callback on node: " + this.znode);
        this.processChildren(this.znode, newNodes, prevNodes);
        LOG.fine("processChildren done nodes that are missing now and need to be removed: " + prevNodes.values());
        for (Map<String, Object> props : prevNodes.values()) {
            EndpointDescription epd = new EndpointDescription(props);
            block3: for (ServiceReference sref : this.discoveredServiceTracker.relatedServiceListeners) {
                String[] scopes;
                if (!(this.bctx.getService(sref) instanceof EndpointListener)) continue;
                EndpointListener epl = (EndpointListener)this.bctx.getService(sref);
                for (String currentScope : scopes = Util.getScopes(sref)) {
                    LOG.fine("matching " + epd + " against " + currentScope);
                    Filter f = null;
                    try {
                        f = FrameworkUtil.createFilter((String)currentScope);
                        Properties d = new Properties();
                        Set<Map.Entry<String, Object>> entries = props.entrySet();
                        for (Map.Entry<String, Object> entry : entries) {
                            ((Dictionary)d).put(entry.getKey(), entry.getValue());
                        }
                        if (!f.match((Dictionary)d)) continue;
                        LOG.fine("MATCHED " + epd + "against " + currentScope);
                        LOG.info("calling EndpointListener endpointRemoved: " + epl + "from bundle " + sref.getBundle().getSymbolicName() + " for endpoint: " + epd);
                        epl.endpointRemoved(epd, currentScope);
                        continue block3;
                    }
                    catch (InvalidSyntaxException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.nodes = newNodes;
    }

    private boolean processChildren(String znode, Map<String, Map<String, Object>> newNodes, Map<String, Map<String, Object>> prevNodes) {
        try {
            LOG.info("Processing the children of " + znode);
            List<String> children = this.zookeeper.getChildren(znode, false);
            boolean foundANode = false;
            for (String child : children) {
                String newNode;
                Map<String, Object> p = this.processChild(znode, child, prevNodes.get(child));
                if (p != null) {
                    LOG.fine("found new node " + znode + "/[" + child + "]   ( []->child )  props: " + p.values());
                    newNodes.put(child, p);
                    prevNodes.remove(child);
                    foundANode = true;
                }
                if (!this.recursive || !this.processChildren(newNode = znode + '/' + child, newNodes, prevNodes)) continue;
                this.zookeeper.getChildren(newNode, this.parent);
            }
            return foundANode;
        }
        catch (KeeperException e) {
            LOG.log(Level.SEVERE, "Problem processing Zookeeper node: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            LOG.log(Level.SEVERE, "Problem processing Zookeeper node: " + e.getMessage(), e);
        }
        return false;
    }

    private Map<String, Object> processChild(String znode, String child, Map<String, Object> prevVal) {
        String node = znode + '/' + child;
        try {
            Stat s = this.zookeeper.exists(node, false);
            if (s.getDataLength() <= 0) {
                return null;
            }
            byte[] data = this.zookeeper.getData(node, false, null);
            LOG.info("Child: " + node);
            List<Element> elements = LocalDiscoveryUtils.getElements(new ByteArrayInputStream(data));
            EndpointDescription epd = null;
            if (elements.size() <= 0) {
                LOG.warning("No Discovery information found for node: " + node);
                return null;
            }
            epd = LocalDiscoveryUtils.getEndpointDescription(elements.get(0));
            LOG.finest("Properties: " + epd.getProperties());
            if (prevVal == null) {
                this.notifyListeners(epd, false);
            } else if (!((Object)prevVal).equals(epd.getProperties())) {
                // empty if block
            }
            return epd.getProperties();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Problem processing Zookeeper callback: " + e.getMessage(), e);
            return null;
        }
    }

    public void inform(ServiceReference sref) {
        LOG.fine("need to inform the service reference of maybe already existing endpoints");
    }

    private void notifyListeners(EndpointDescription epd, boolean isRemoval) {
        System.out.println("****************  notifyListeners(" + epd + "  ,  " + isRemoval + ")");
        block2: for (ServiceReference sref : this.discoveredServiceTracker.relatedServiceListeners) {
            String[] scopes;
            if (!(this.bctx.getService(sref) instanceof EndpointListener)) continue;
            EndpointListener epl = (EndpointListener)this.bctx.getService(sref);
            for (String currentScope : scopes = Util.getScopes(sref)) {
                try {
                    Filter f = FrameworkUtil.createFilter((String)currentScope);
                    Properties d = new Properties();
                    Map<String, Object> props = epd.getProperties();
                    Set<Map.Entry<String, Object>> entries = props.entrySet();
                    for (Map.Entry<String, Object> entry : entries) {
                        ((Dictionary)d).put(entry.getKey(), entry.getValue());
                    }
                    LOG.fine("matching " + epd + " against " + currentScope);
                    if (!f.match((Dictionary)d)) continue;
                    LOG.fine("MATCHED " + epd + "against " + currentScope);
                    LOG.info("scheduling EndpointListener call for listener ; " + epl + "  from bundle  " + sref.getBundle().getSymbolicName() + " based on scope [" + currentScope + "]");
                    if (isRemoval) {
                        epl.endpointRemoved(epd, currentScope);
                        continue block2;
                    }
                    epl.endpointAdded(epd, currentScope);
                    continue block2;
                }
                catch (InvalidSyntaxException e) {
                    LOG.warning("skipping scope [" + currentScope + "] of endpoint listener from bundle " + sref.getBundle().getSymbolicName() + " becaue it is invalid: " + e.getMessage());
                }
            }
        }
    }
}

