/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.discovery.zookeeper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    static final String PATH_PREFIX = "/osgi/service_registry";

    static Collection<String> getMultiValueProperty(Object property2) {
        if (property2 instanceof Collection) {
            return (Collection)property2;
        }
        if (property2 instanceof String[]) {
            return Arrays.asList((String[])property2);
        }
        if (property2 == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(property2.toString());
    }

    static String getZooKeeperPath(String name) {
        if (name == null || "".equals(name)) {
            return PATH_PREFIX;
        }
        return "/osgi/service_registry/" + name.replace('.', '/');
    }

    static String[] getStringPlusProperty(Object property2) {
        if (property2 instanceof String) {
            String[] ret = new String[]{(String)property2};
            return ret;
        }
        if (property2 instanceof String[]) {
            return (String[])property2;
        }
        if (property2 instanceof Collection) {
            Collection col = (Collection)property2;
            String[] ret = new String[col.size()];
            int x = 0;
            for (Object s : col) {
                ret[x] = (String)s;
                ++x;
            }
            return ret;
        }
        return new String[0];
    }

    public static String[] getScopes(ServiceReference sref) {
        String[] scopes = Util.getStringPlusProperty(sref.getProperty("endpoint.listener.scope"));
        ArrayList<String> normalizedScopes = new ArrayList<String>(scopes.length);
        for (String scope : scopes) {
            if (scope == null || "".equals(scope)) continue;
            normalizedScopes.add(scope);
        }
        return normalizedScopes.toArray(new String[normalizedScopes.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUUID(BundleContext bc) {
        String string = "org.osgi.framework.uuid";
        synchronized ("org.osgi.framework.uuid") {
            String uuid = bc.getProperty("org.osgi.framework.uuid");
            if (uuid == null) {
                uuid = UUID.randomUUID().toString();
                System.setProperty("org.osgi.framework.uuid", uuid);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return uuid;
        }
    }
}

