/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.dosgi.dsw.OsgiService;
import org.apache.cxf.dosgi.dsw.qos.IntentMap;
import org.apache.cxf.dosgi.dsw.service.RemoteServiceAdminCore;
import org.apache.cxf.ws.policy.spring.PolicyNamespaceHandler;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.springframework.osgi.context.support.OsgiBundleXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OsgiUtils {
    private static final Logger LOG = Logger.getLogger(OsgiUtils.class.getName());
    private static final String REMOTE_SERVICES_HEADER_NAME = "Remote-Service";
    private static final String REMOTE_SERVICES_DIRECTORY = "OSGI-INF/remote-service";
    private static final String REMOTE_SERVICES_NS = "http://www.osgi.org/xmlns/sd/v1.0.0";
    private static Map<Long, IntentMap> intentMaps = new HashMap<Long, IntentMap>();
    static final String[] INTENT_MAP = new String[]{"/OSGI-INF/cxf/intents/intent-map.xml"};
    private static final String SERVICE_DESCRIPTION_ELEMENT = "service-description";

    private OsgiUtils() {
    }

    public static List<Element> getAllDescriptionElements(Bundle b) {
        Enumeration urls;
        String directory = null;
        Dictionary headers = b.getHeaders();
        if (headers != null) {
            directory = (String)headers.get(REMOTE_SERVICES_HEADER_NAME);
        }
        if (directory == null) {
            directory = REMOTE_SERVICES_DIRECTORY;
        }
        if ((urls = b.findEntries(directory.toString(), "*.xml", false)) == null) {
            return Collections.emptyList();
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        while (urls.hasMoreElements()) {
            URL resourceURL = (URL)urls.nextElement();
            try {
                Document d = new SAXBuilder().build(resourceURL.openStream());
                Namespace ns = Namespace.getNamespace(REMOTE_SERVICES_NS);
                elements.addAll(d.getRootElement().getChildren(SERVICE_DESCRIPTION_ELEMENT, ns));
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Problem parsing: " + resourceURL, ex);
            }
        }
        return elements;
    }

    public static Filter createFilter(BundleContext bc, String filterValue) {
        if (filterValue == null) {
            return null;
        }
        try {
            return bc.createFilter(filterValue);
        }
        catch (InvalidSyntaxException ex) {
            System.out.println("Invalid filter expression " + filterValue);
        }
        catch (Exception ex) {
            System.out.println("Problem creating a Filter from " + filterValue);
        }
        return null;
    }

    public static String[] parseIntents(String intentsSequence) {
        return intentsSequence == null ? new String[]{} : intentsSequence.split(" ");
    }

    public static String formatIntents(String[] intents) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String intent : intents) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(intent);
        }
        return sb.toString();
    }

    public static <T> OsgiService<T> getOsgiService(BundleContext bc, Class<T> serviceClass) {
        block3: {
            try {
                Object o;
                ServiceReference sr = bc.getServiceReference(serviceClass.getName());
                if (sr != null && (o = bc.getService(sr)) != null && serviceClass.isAssignableFrom(o.getClass())) {
                    return new OsgiService<Object>(sr, o);
                }
            }
            catch (Exception ex) {
                if (!LOG.isLoggable(Level.FINE)) break block3;
                LOG.fine("Problem retrieving an OSGI service " + serviceClass.getName() + ", exception : " + ex.getMessage());
            }
        }
        return null;
    }

    public static IntentMap getIntentMap(BundleContext bundleContext) {
        IntentMap im = OsgiUtils.readIntentMap(bundleContext);
        if (im == null) {
            LOG.log(Level.FINE, "Using default intent map");
            im = new IntentMap();
            im.setIntents(new HashMap<String, Object>());
        }
        return im;
    }

    static IntentMap readIntentMap(BundleContext bundleContext) {
        if (!intentMaps.containsKey(bundleContext.getBundle().getBundleId())) {
            ArrayList<String> springIntentLocations = new ArrayList<String>();
            for (String mapFile : INTENT_MAP) {
                if (bundleContext.getBundle().getResource(mapFile) == null) {
                    LOG.info("Could not find intent map file " + mapFile);
                    return null;
                }
                springIntentLocations.add("classpath:" + mapFile);
            }
            try {
                Thread.currentThread().setContextClassLoader(PolicyNamespaceHandler.class.getClassLoader());
                LOG.fine("Loading Intent map from " + springIntentLocations);
                System.out.println("Loading Intent map from " + springIntentLocations);
                OsgiBundleXmlApplicationContext ctx = new OsgiBundleXmlApplicationContext(springIntentLocations.toArray(new String[0]));
                ctx.setPublishContextAsService(false);
                ctx.setBundleContext(bundleContext);
                ctx.refresh();
                LOG.fine("application context: " + ctx);
                System.out.println("application context: " + ctx);
                IntentMap im = (IntentMap)ctx.getBean("intentMap");
                LOG.fine("retrieved intent map: " + im);
                System.out.println("retrieved intent map: " + im);
                Thread.currentThread().setContextClassLoader(RemoteServiceAdminCore.class.getClassLoader());
                intentMaps.put(bundleContext.getBundle().getBundleId(), im);
                return im;
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Intent map load failed: ", t);
                return null;
            }
        }
        return intentMaps.get(bundleContext.getBundle().getBundleId());
    }

    public static Filter createFilterFromProperties(BundleContext bc, Dictionary properties) {
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(&");
        Enumeration keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            String value = properties.get(key).toString();
            sb.append('(').append(key).append('=').append(value).append(')');
        }
        sb.append(')');
        return OsgiUtils.createFilter(bc, sb.toString());
    }

    public static boolean getBooleanProperty(Map sd, String name) {
        Object value = sd.get(name);
        return OsgiUtils.toBoolean(value);
    }

    public static boolean toBoolean(Object value) {
        return value instanceof Boolean && (Boolean)value != false || value instanceof String && Boolean.parseBoolean((String)value);
    }

    public static Collection<String> getMultiValueProperty(Object property2) {
        if (property2 == null) {
            return null;
        }
        if (property2 instanceof Collection) {
            return (Collection)property2;
        }
        if (property2 instanceof String[]) {
            return Arrays.asList((String[])property2);
        }
        return Collections.singleton(property2.toString());
    }

    public static String getProperty(EndpointDescription sd, String name) {
        Object o = sd.getProperties().get(name);
        if (o != null && o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public static String getProperty(Map dict, String name) {
        Object o = dict.get(name);
        if (o != null && o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public static String getVersion(Class<?> iClass, BundleContext bc) {
        ServiceReference paRef = bc.getServiceReference(PackageAdmin.class.getName());
        if (paRef != null) {
            PackageAdmin pa = (PackageAdmin)bc.getService(paRef);
            Bundle b = pa.getBundle(iClass);
            if (b == null) {
                LOG.info("Unable to find interface version for interface " + iClass.getName() + ". Falling back to 0.0.0");
                return "0.0.0";
            }
            LOG.finest("Interface source bundle: " + b.getSymbolicName());
            ExportedPackage[] ep = pa.getExportedPackages(b);
            LOG.finest("Exported Packages of the source bundle: " + ep);
            String pack = iClass.getPackage().getName();
            LOG.finest("Looking for Package: " + pack);
            for (ExportedPackage p : ep) {
                if (!pack.equals(p.getName())) continue;
                LOG.fine("found package -> Version: " + p.getVersion());
                return p.getVersion().toString();
            }
        } else {
            LOG.severe("Was unable to obtain the package admin service -> can't resolve interface versions");
        }
        LOG.info("Unable to find interface version for interface " + iClass.getName() + ". Falling back to 0.0.0");
        return "0.0.0";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUUID(BundleContext bc) {
        String string = "org.osgi.framework.uuid";
        synchronized ("org.osgi.framework.uuid") {
            String uuid = bc.getProperty("org.osgi.framework.uuid");
            if (uuid == null) {
                uuid = UUID.randomUUID().toString();
                System.setProperty("org.osgi.framework.uuid", uuid);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return uuid;
        }
    }
}

