/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.decorator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.dosgi.dsw.decorator.InterfaceRule;
import org.apache.cxf.dosgi.dsw.decorator.Rule;
import org.apache.cxf.dosgi.dsw.decorator.ServiceDecorator;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDecoratorImpl
implements ServiceDecorator {
    private static final Logger LOG = Logger.getLogger(ServiceDecoratorImpl.class.getName());
    private final BundleContext bundleContext;
    private final BundleListenerImpl bundleListener;
    final List<Rule> decorations = new CopyOnWriteArrayList<Rule>();

    public ServiceDecoratorImpl(BundleContext bc) {
        this.bundleContext = bc;
        this.bundleListener = new BundleListenerImpl();
        bc.addBundleListener((BundleListener)this.bundleListener);
    }

    public void shutdown() {
        this.bundleContext.removeBundleListener((BundleListener)this.bundleListener);
    }

    @Override
    public void decorate(ServiceReference sref, Map<String, Object> target) {
        for (Rule matcher : this.decorations) {
            matcher.apply(sref, target);
        }
    }

    void addDecorations(Bundle bundle) {
        Namespace ns = Namespace.getNamespace("http://cxf.apache.org/xmlns/service-decoration/1.0.0");
        for (Element decoration : ServiceDecoratorImpl.getDecorationElements(bundle)) {
            for (Element match : decoration.getChildren("match", ns)) {
                InterfaceRule m = new InterfaceRule(bundle, match.getAttributeValue("interface"));
                for (Element propMatch : match.getChildren("match-property", ns)) {
                    m.addPropMatch(propMatch.getAttributeValue("name"), propMatch.getAttributeValue("value"));
                }
                for (Element addProp : match.getChildren("add-property", ns)) {
                    m.addProperty(addProp.getAttributeValue("name"), addProp.getAttributeValue("value"), addProp.getAttributeValue("type", String.class.getName()));
                }
                this.decorations.add(m);
            }
        }
    }

    static List<Element> getDecorationElements(Bundle bundle) {
        Enumeration entries = bundle.findEntries("OSGI-INF/remote-service", "*.xml", false);
        if (entries == null) {
            return Collections.emptyList();
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        while (entries.hasMoreElements()) {
            URL resourceURL = (URL)entries.nextElement();
            try {
                Document d = new SAXBuilder().build(resourceURL.openStream());
                Namespace ns = Namespace.getNamespace("http://cxf.apache.org/xmlns/service-decoration/1.0.0");
                elements.addAll(d.getRootElement().getChildren("service-decoration", ns));
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Problem parsing: " + resourceURL, ex);
            }
        }
        return elements;
    }

    void removeDecorations(Bundle bundle) {
        for (Rule r : this.decorations) {
            if (!bundle.equals(r.getBundle())) continue;
            this.decorations.remove(r);
        }
    }

    private class BundleListenerImpl
    implements BundleListener {
        private BundleListenerImpl() {
        }

        public void bundleChanged(BundleEvent be) {
            switch (be.getType()) {
                case 2: {
                    ServiceDecoratorImpl.this.addDecorations(be.getBundle());
                    break;
                }
                case 256: {
                    ServiceDecoratorImpl.this.removeDecorations(be.getBundle());
                }
            }
        }
    }
}

