/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.cxf.binding.BindingConfiguration;
import org.apache.cxf.dosgi.dsw.OsgiUtils;
import org.apache.cxf.dosgi.dsw.handlers.AbstractConfigurationHandler;
import org.apache.cxf.dosgi.dsw.handlers.IntentUnsatifiedException;
import org.apache.cxf.dosgi.dsw.qos.IntentMap;
import org.apache.cxf.endpoint.AbstractEndpointFactory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPojoConfigurationTypeHandler
extends AbstractConfigurationHandler {
    private static final Logger LOG = Logger.getLogger(AbstractPojoConfigurationTypeHandler.class.getName());
    private static final String PROVIDED_INTENT_VALUE = "PROVIDED";
    private static final String CONFIGURATION_TYPE = "org.apache.cxf.ws";
    private IntentMap masterMap;

    public AbstractPojoConfigurationTypeHandler(BundleContext dswBC, Map<String, Object> handlerProps) {
        super(dswBC, handlerProps);
    }

    ClientProxyFactoryBean createClientProxyFactoryBean(String frontEndImpl) {
        if ("jaxws".equals(frontEndImpl)) {
            return new JaxWsProxyFactoryBean();
        }
        return new ClientProxyFactoryBean();
    }

    ServerFactoryBean createServerFactoryBean(String frontEndImpl) {
        if ("jaxws".equals(frontEndImpl)) {
            return new JaxWsServerFactoryBean();
        }
        return new ServerFactoryBean();
    }

    Map<String, String> registerPublication(Server server, String[] intents) {
        HashMap<String, String> publicationProperties = new HashMap<String, String>();
        publicationProperties.put("service.exported.configs", CONFIGURATION_TYPE);
        String intentsValue = OsgiUtils.formatIntents(intents);
        if (intentsValue.length() > 0) {
            publicationProperties.put("service.intents", intentsValue);
        }
        return publicationProperties;
    }

    String[] applyIntents(BundleContext dswContext, BundleContext callingContext, List<AbstractFeature> features, AbstractEndpointFactory factory, Map sd) throws IntentUnsatifiedException {
        String[] requestedIntents = AbstractPojoConfigurationTypeHandler.getRequestedIntents(sd);
        HashSet<String> appliedIntents = new HashSet<String>(Arrays.asList(requestedIntents));
        IntentMap intentMap = this.getIntentMap(callingContext);
        if (this.useMasterMap()) {
            intentMap = this.mergeWithMaster(dswContext, intentMap);
        }
        appliedIntents.addAll(this.reverseLookup(intentMap, PROVIDED_INTENT_VALUE));
        boolean bindingConfigAdded = false;
        for (String requestedName : requestedIntents) {
            bindingConfigAdded |= this.processIntent(appliedIntents, features, factory, requestedName, intentMap);
        }
        if (!bindingConfigAdded && this.getDefaultBindingIntent() != null) {
            this.processIntent(appliedIntents, features, factory, this.getDefaultBindingIntent(), intentMap);
        }
        appliedIntents.addAll(this.addSynonymIntents(appliedIntents, intentMap));
        return appliedIntents.toArray(new String[0]);
    }

    private boolean processIntent(Set<String> appliedIntents, List<AbstractFeature> features, AbstractEndpointFactory factory, String intentName, IntentMap intentMap) throws IntentUnsatifiedException {
        boolean rc = this.processIntent(features, factory, intentName, intentMap);
        appliedIntents.add(intentName);
        return rc;
    }

    private boolean processIntent(List<AbstractFeature> features, AbstractEndpointFactory factory, String intentName, IntentMap intentMap) throws IntentUnsatifiedException {
        Object intent = intentMap.get(intentName);
        if (intent instanceof String) {
            if (PROVIDED_INTENT_VALUE.equalsIgnoreCase((String)intent)) {
                return false;
            }
        } else {
            if (intent instanceof AbstractFeature) {
                AbstractFeature feature = (AbstractFeature)intent;
                LOG.info("Applying intent: " + intentName + " via feature: " + feature);
                features.add(feature);
                return false;
            }
            if (intent instanceof BindingConfiguration) {
                BindingConfiguration bindingCfg = (BindingConfiguration)intent;
                LOG.info("Applying intent: " + intentName + " via binding config: " + bindingCfg);
                factory.setBindingConfig(bindingCfg);
                return true;
            }
            LOG.info("No mapping for intent: " + intentName);
            throw new IntentUnsatifiedException(intentName);
        }
        return false;
    }

    private Collection<String> addSynonymIntents(Collection<String> appliedIntents, IntentMap intentMap) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (String key : appliedIntents) {
            values.add(intentMap.get(key));
        }
        return this.reverseLookup(intentMap, values);
    }

    private Collection<String> reverseLookup(IntentMap intentMap, Object obj) {
        return this.reverseLookup(intentMap, Collections.singleton(obj));
    }

    private Collection<String> reverseLookup(IntentMap intentMap, Collection<? extends Object> objs) {
        HashSet<String> intentsFound = new HashSet<String>();
        for (Map.Entry<String, Object> entry : intentMap.getIntents().entrySet()) {
            if (!objs.contains(entry.getValue())) continue;
            intentsFound.add(entry.getKey());
        }
        return intentsFound;
    }

    String getDefaultBindingIntent() {
        return "SOAP";
    }

    IntentMap getIntentMap(BundleContext callingContext) {
        return OsgiUtils.getIntentMap(callingContext);
    }

    @Override
    public String getType() {
        return CONFIGURATION_TYPE;
    }

    private static String[] getRequestedIntents(Map sd) {
        List<String> intents = Arrays.asList(OsgiUtils.parseIntents(OsgiUtils.getProperty(sd, "service.exported.intents")));
        List<String> extraIntents = Arrays.asList(OsgiUtils.parseIntents(OsgiUtils.getProperty(sd, "service.exported.intents")));
        List<String> oldIntents = Arrays.asList(OsgiUtils.parseIntents(OsgiUtils.getProperty(sd, "osgi.remote.requires.intents")));
        HashSet<String> allIntents = new HashSet<String>(intents.size() + extraIntents.size() + oldIntents.size());
        allIntents.addAll(intents);
        allIntents.addAll(extraIntents);
        allIntents.addAll(oldIntents);
        LOG.fine("Intents asserted: " + allIntents);
        return allIntents.toArray(new String[allIntents.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IntentMap mergeWithMaster(BundleContext dswContext, IntentMap intentMap) {
        AbstractPojoConfigurationTypeHandler abstractPojoConfigurationTypeHandler = this;
        synchronized (abstractPojoConfigurationTypeHandler) {
            if (this.masterMap == null) {
                LOG.fine("Loading master intent map");
                this.masterMap = this.getIntentMap(dswContext);
            }
        }
        if (this.masterMap != null) {
            for (String masterKey : this.masterMap.getIntents().keySet()) {
                if (intentMap.get(masterKey) == null) {
                    LOG.fine("Merging in master intent map entry: " + masterKey);
                    intentMap.getIntents().put(masterKey, this.masterMap.get(masterKey));
                    continue;
                }
                LOG.fine("Overridden master intent map entry: " + masterKey);
            }
        }
        return intentMap;
    }
}

