/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.handlers;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.dosgi.dsw.OsgiUtils;
import org.apache.cxf.dosgi.dsw.handlers.ConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.handlers.HttpServiceConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.handlers.JaxRSHttpServiceConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.handlers.JaxRSPojoConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.handlers.PojoConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.handlers.WsdlConfigurationTypeHandler;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigTypeHandlerFactory {
    private static final Logger LOG = Logger.getLogger(ConfigTypeHandlerFactory.class.getName());
    private static final ConfigTypeHandlerFactory FACTORY = new ConfigTypeHandlerFactory();

    private ConfigTypeHandlerFactory() {
    }

    public static ConfigTypeHandlerFactory getInstance() {
        return FACTORY;
    }

    public ConfigurationTypeHandler getHandler(BundleContext dswBC, List<String> configurationTypes, Map serviceProperties, Map<String, Object> props) {
        if (configurationTypes.contains("org.apache.cxf.ws") || configurationTypes.contains("pojo") || configurationTypes.contains("org.apache.cxf.rs")) {
            boolean jaxrs = this.isJaxrsRequested(configurationTypes, serviceProperties);
            if (OsgiUtils.getProperty(serviceProperties, "org.apache.cxf.ws.httpservice.context") != null || OsgiUtils.getProperty(serviceProperties, "org.apache.cxf.rs.httpservice.context") != null || OsgiUtils.getProperty(serviceProperties, "osgi.remote.configuration.pojo.httpservice.context") != null) {
                return jaxrs ? new JaxRSHttpServiceConfigurationTypeHandler(dswBC, props) : new HttpServiceConfigurationTypeHandler(dswBC, props);
            }
            return jaxrs ? new JaxRSPojoConfigurationTypeHandler(dswBC, props) : new PojoConfigurationTypeHandler(dswBC, props);
        }
        if (configurationTypes.contains("wsdl")) {
            return new WsdlConfigurationTypeHandler(dswBC, props);
        }
        LOG.info("None of the configuration types in " + configurationTypes + " is supported.");
        return null;
    }

    private boolean isJaxrsRequested(Collection<String> types, Map serviceProperties) {
        if (types == null) {
            return false;
        }
        if (types.contains("org.apache.cxf.rs")) {
            String intentsProperty = OsgiUtils.getProperty(serviceProperties, "service.exported.intents");
            boolean hasHttpIntent = false;
            boolean hasSoapIntent = false;
            if (intentsProperty != null) {
                String[] intents = OsgiUtils.parseIntents(intentsProperty);
                for (int i = 0; i < intents.length; ++i) {
                    if (intents[i].indexOf("SOAP") > -1) {
                        hasSoapIntent = true;
                        break;
                    }
                    if (!"HTTP".equals(intents[i])) continue;
                    hasHttpIntent = true;
                }
            }
            if (intentsProperty != null && hasHttpIntent && !hasSoapIntent || intentsProperty == null) {
                return true;
            }
        }
        return false;
    }
}

