/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.handlers;

import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.apache.cxf.Bus;
import org.apache.cxf.aegis.databinding.AegisDatabinding;
import org.apache.cxf.databinding.AbstractDataBinding;
import org.apache.cxf.dosgi.dsw.OsgiUtils;
import org.apache.cxf.dosgi.dsw.handlers.AbstractConfigurationHandler;
import org.apache.cxf.dosgi.dsw.handlers.AbstractPojoConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.handlers.IntentUnsatifiedException;
import org.apache.cxf.dosgi.dsw.handlers.SecurityDelegatingHttpContext;
import org.apache.cxf.dosgi.dsw.service.ExportRegistrationImpl;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerLifeCycleListener;
import org.apache.cxf.endpoint.ServerLifeCycleManager;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;
import org.modelbus.dosgi.services.api.AbstractModelBusServiceActivator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServiceConfigurationTypeHandler
extends AbstractPojoConfigurationTypeHandler {
    private static final Logger LOG = Logger.getLogger(HttpServiceConfigurationTypeHandler.class.getName());
    Set<ServiceReference> httpServiceReferences = new CopyOnWriteArraySet<ServiceReference>();

    protected HttpServiceConfigurationTypeHandler(BundleContext dswBC, Map<String, Object> handlerProps) {
        super(dswBC, handlerProps);
        ServiceTracker st = new ServiceTracker(dswBC, HttpService.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                HttpServiceConfigurationTypeHandler.this.httpServiceReferences.add(reference);
                return super.addingService(reference);
            }

            public void removedService(ServiceReference reference, Object service) {
                HttpServiceConfigurationTypeHandler.this.httpServiceReferences.remove(reference);
                super.removedService(reference, service);
            }
        };
        st.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object createProxy(ServiceReference serviceReference, BundleContext dswContext, BundleContext callingContext, Class<?> iClass, EndpointDescription sd) {
        String address = this.getHttpServiceAddress(sd.getProperties(), iClass);
        if (address == null) {
            LOG.warning("Remote address is unavailable");
            return null;
        }
        LOG.info("Creating a " + iClass.getName() + " client, endpoint address is " + address);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Object proxy;
            String dataBindingImpl = (String)serviceReference.getProperty("org.apache.cxf.ws.databinding");
            AbstractDataBinding databinding = "jaxb".equals(dataBindingImpl) ? new JAXBDataBinding() : new AegisDatabinding();
            String frontEndImpl = (String)serviceReference.getProperty("org.apache.cxf.ws.frontend");
            ClientProxyFactoryBean factory = this.createClientProxyFactoryBean(frontEndImpl);
            factory.setServiceClass(iClass);
            factory.setAddress(address);
            factory.getServiceFactory().setDataBinding(databinding);
            this.applyIntents(dswContext, callingContext, factory.getFeatures(), factory.getClientFactoryBean(), sd.getProperties());
            Thread.currentThread().setContextClassLoader(ClientProxyFactoryBean.class.getClassLoader());
            Object object = proxy = this.getProxy(factory.create(), iClass);
            return object;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "proxy creation failed", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createServer(ExportRegistrationImpl exportRegistration, BundleContext dswContext, BundleContext callingContext, Map sd, Class<?> iClass, Object serviceBean) {
        String contextRoot = this.getServletContextRoot(sd, iClass);
        if (contextRoot == null) {
            LOG.warning("Remote address is unavailable");
            return;
        }
        CXFNonSpringServlet cxf = new CXFNonSpringServlet();
        HttpService httpService = this.getHttpService(exportRegistration.getExportedService(), iClass);
        try {
            httpService.registerServlet(contextRoot, (Servlet)cxf, new Hashtable(), this.getHttpContext(dswContext, httpService));
            LOG.info("Successfully registered CXF DOSGi servlet at " + contextRoot);
        }
        catch (Exception e) {
            throw new ServiceException("CXF DOSGi: problem registering CXF HTTP Servlet", (Throwable)e);
        }
        Bus bus = cxf.getBus();
        String dataBindingImpl = (String)exportRegistration.getExportedService().getProperty("org.apache.cxf.ws.databinding");
        AbstractDataBinding databinding = "jaxb".equals(dataBindingImpl) ? new JAXBDataBinding() : new AegisDatabinding();
        String frontEndImpl = (String)exportRegistration.getExportedService().getProperty("org.apache.cxf.ws.frontend");
        ServerFactoryBean factory = this.createServerFactoryBean(frontEndImpl);
        String address = this.constructAddress(dswContext, contextRoot);
        factory.setBus(bus);
        factory.setServiceClass(iClass);
        factory.setAddress("/");
        factory.getServiceFactory().setDataBinding(databinding);
        factory.setServiceBean(serviceBean);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            String[] intents = this.applyIntents(dswContext, callingContext, factory.getFeatures(), factory, sd);
            Map<String, Object> endpointProps = this.createEndpointProps(sd, iClass, new String[]{"org.apache.cxf.ws"}, address, intents);
            EndpointDescription endpdDesc = null;
            Thread.currentThread().setContextClassLoader(ServerFactoryBean.class.getClassLoader());
            Server server = factory.create();
            this.registerStopHook(bus, httpService, server, contextRoot, "org.apache.cxf.ws.httpservice.context");
            endpdDesc = new EndpointDescription(endpointProps);
            exportRegistration.setServer(server);
            exportRegistration.setEndpointdescription(endpdDesc);
        }
        catch (IntentUnsatifiedException iue) {
            exportRegistration.setException(iue);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    protected Map<String, String> registerPublication(Server server, String[] intents, String address) {
        Map<String, String> publicationProperties = super.registerPublication(server, intents);
        publicationProperties.put("org.apache.cxf.ws.address", address);
        return publicationProperties;
    }

    protected String constructAddress(BundleContext ctx, String contextRoot) {
        String port = null;
        boolean https = false;
        if ("true".equalsIgnoreCase(ctx.getProperty("org.osgi.service.http.secure.enabled"))) {
            https = true;
            port = ctx.getProperty("org.osgi.service.http.port.secure");
        } else {
            port = ctx.getProperty("org.osgi.service.http.port");
        }
        if (port == null) {
            port = "8080";
        }
        String hostName = null;
        try {
            hostName = AbstractConfigurationHandler.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            hostName = "localhost";
        }
        return this.getAddress(https ? "https" : "http", hostName, port, contextRoot);
    }

    protected HttpService getHttpService(ServiceReference serviceReference, Class<?> iClass) {
        HttpService modelBusRepositoryService = this.getModelBusRepositoryHTTPService();
        if ("org.modelbus.dosgi.repository.descriptor.RepositoryService".equals(iClass.getName())) {
            if (modelBusRepositoryService != null) {
                return modelBusRepositoryService;
            }
        } else {
            if (modelBusRepositoryService != null) {
                return modelBusRepositoryService;
            }
            for (ServiceReference sr : this.httpServiceReferences) {
                Object svc = this.bundleContext.getService(sr);
                if (!(svc instanceof HttpService) || !HttpServiceConfigurationTypeHandler.isModelBusServiceHTTPService(sr)) continue;
                return (HttpService)svc;
            }
        }
        throw new ServiceException("CXF DOSGi: No HTTP Service could be found to publish CXF endpoint in.");
    }

    private HttpService getModelBusRepositoryHTTPService() {
        for (ServiceReference sr : this.httpServiceReferences) {
            Object svc = this.bundleContext.getService(sr);
            if (!(svc instanceof HttpService) || !HttpServiceConfigurationTypeHandler.isModelBusHTTPService(sr)) continue;
            return (HttpService)svc;
        }
        return null;
    }

    private static boolean isModelBusServiceHTTPService(ServiceReference reference) {
        Bundle[] bundles = reference.getUsingBundles();
        if (bundles == null) {
            return false;
        }
        for (Bundle bundle : bundles) {
            String activator = (String)bundle.getHeaders().get("Bundle-Activator");
            if (activator == null || "".equals(activator)) continue;
            try {
                Class activatorClass = bundle.loadClass(activator);
                if (!AbstractModelBusServiceActivator.class.isAssignableFrom(activatorClass)) continue;
                return true;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean isModelBusHTTPService(ServiceReference reference) {
        return HttpServiceConfigurationTypeHandler.isHTTPServiceExportingBundleNamedLike(reference, "org.modelbus.server.embedded");
    }

    private static boolean isHTTPServiceExportingBundleNamedLike(ServiceReference reference, String name) {
        Bundle[] bundles = reference.getUsingBundles();
        if (bundles == null) {
            return false;
        }
        for (Bundle bundle : bundles) {
            if (!name.equals(bundle.getSymbolicName())) continue;
            return true;
        }
        return false;
    }

    protected String getServletContextRoot(Map sd, Class<?> iClass) {
        String context = OsgiUtils.getProperty(sd, "org.apache.cxf.ws.httpservice.context");
        if (context == null) {
            context = OsgiUtils.getProperty(sd, "osgi.remote.configuration.pojo.httpservice.context");
        }
        if (context == null) {
            context = "/" + iClass.getName().replace('.', '/');
            LOG.info("Using a default address : " + context);
        }
        return context;
    }

    protected void registerStopHook(Bus bus, final HttpService httpService, Server theServer, final String contextRoot, final String propertyName) {
        if (bus != null) {
            theServer.getEndpoint().put(propertyName, contextRoot);
            ServerLifeCycleListener stopHook = new ServerLifeCycleListener(){

                public void stopServer(Server s) {
                    Object contextProperty = s.getEndpoint().get(propertyName);
                    if (contextProperty != null && contextProperty.equals(contextRoot)) {
                        httpService.unregister(contextRoot);
                    }
                }

                public void startServer(Server s) {
                }
            };
            ServerLifeCycleManager mgr = bus.getExtension(ServerLifeCycleManager.class);
            if (mgr != null) {
                mgr.registerListener(stopHook);
            }
        }
    }

    protected HttpContext getHttpContext(BundleContext bundleContext, HttpService httpService) {
        HttpContext httpContext = httpService.createDefaultHttpContext();
        return new SecurityDelegatingHttpContext(bundleContext, httpContext);
    }

    protected String getHttpServiceAddress(Map sd, Class<?> iClass) {
        String address = OsgiUtils.getProperty(sd, "endpoint.id");
        if (address == null && sd.get("endpoint.id") != null) {
            LOG.severe("Could not use address property endpoint.id");
            return null;
        }
        if (address == null) {
            address = OsgiUtils.getProperty(sd, "org.apache.cxf.ws.address");
        }
        if (address == null && sd.get("org.apache.cxf.ws.address") != null) {
            LOG.severe("Could not use address property org.apache.cxf.ws.address");
            return null;
        }
        if (address == null) {
            address = OsgiUtils.getProperty(sd, "osgi.remote.configuration.pojo.address");
        }
        if (address == null && sd.get("osgi.remote.configuration.pojo.address") != null) {
            LOG.severe("Could not use address property osgi.remote.configuration.pojo.address");
            return null;
        }
        if (address == null) {
            address = OsgiUtils.getProperty(sd, "org.apache.cxf.rs.address");
        }
        if (address == null && sd.get("org.apache.cxf.rs.address") != null) {
            LOG.severe("Could not use address property org.apache.cxf.rs.address");
            return null;
        }
        return address;
    }
}

