/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.handlers;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.aegis.databinding.AegisDatabinding;
import org.apache.cxf.databinding.AbstractDataBinding;
import org.apache.cxf.dosgi.dsw.OsgiUtils;
import org.apache.cxf.dosgi.dsw.handlers.AbstractPojoConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.handlers.IntentUnsatifiedException;
import org.apache.cxf.dosgi.dsw.service.ExportRegistrationImpl;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PojoConfigurationTypeHandler
extends AbstractPojoConfigurationTypeHandler {
    private static final Logger LOG = Logger.getLogger(PojoConfigurationTypeHandler.class.getName());

    public PojoConfigurationTypeHandler(BundleContext dswBC, Map<String, Object> handlerProps) {
        super(dswBC, handlerProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object createProxy(ServiceReference serviceReference, BundleContext dswContext, BundleContext callingContext, Class<?> iClass, EndpointDescription sd) throws IntentUnsatifiedException {
        String address = this.getPojoAddress(sd.getProperties(), iClass);
        if (address == null) {
            LOG.warning("Remote address is unavailable");
            return null;
        }
        LOG.info("Creating a " + iClass.getName() + " client, endpoint address is " + address);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Object proxy;
            String dataBindingImpl = (String)serviceReference.getProperty("org.apache.cxf.ws.databinding");
            AbstractDataBinding databinding = "jaxb".equals(dataBindingImpl) ? new JAXBDataBinding() : new AegisDatabinding();
            String frontEndImpl = (String)serviceReference.getProperty("org.apache.cxf.ws.frontend");
            ClientProxyFactoryBean factory = this.createClientProxyFactoryBean(frontEndImpl);
            factory.setServiceClass(iClass);
            factory.setAddress(address);
            factory.getServiceFactory().setDataBinding(databinding);
            this.applyIntents(dswContext, callingContext, factory.getFeatures(), factory.getClientFactoryBean(), sd.getProperties());
            Thread.currentThread().setContextClassLoader(ClientProxyFactoryBean.class.getClassLoader());
            Object object = proxy = this.getProxy(factory.create(), iClass);
            return object;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "proxy creation failed", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createServer(ExportRegistrationImpl exportRegistration, BundleContext dswContext, BundleContext callingContext, Map sd, Class<?> iClass, Object serviceBean) throws IntentUnsatifiedException {
        String address = this.getPojoAddress(sd, iClass);
        if (address == null) {
            LOG.warning("Remote address is unavailable");
            exportRegistration.setException(new Throwable("Remote address is unavailable"));
            return;
        }
        LOG.info("Creating a " + iClass.getName() + " endpoint from CXF PublishHook, address is " + address);
        String dataBindingImpl = (String)exportRegistration.getExportedService().getProperty("org.apache.cxf.ws.databinding");
        AbstractDataBinding databinding = "jaxb".equals(dataBindingImpl) ? new JAXBDataBinding() : new AegisDatabinding();
        String frontEndImpl = (String)exportRegistration.getExportedService().getProperty("org.apache.cxf.ws.frontend");
        ServerFactoryBean factory = this.createServerFactoryBean(frontEndImpl);
        factory.setServiceClass(iClass);
        factory.setAddress(address);
        factory.getServiceFactory().setDataBinding(databinding);
        factory.setServiceBean(serviceBean);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            String[] intents = this.applyIntents(dswContext, callingContext, factory.getFeatures(), factory, sd);
            Map<String, Object> endpointProps = this.createEndpointProps(sd, iClass, new String[]{"org.apache.cxf.ws"}, address, intents);
            Thread.currentThread().setContextClassLoader(ServerFactoryBean.class.getClassLoader());
            Server server = factory.create();
            exportRegistration.setServer(server);
            EndpointDescription ed = new EndpointDescription(endpointProps);
            exportRegistration.setEndpointdescription(ed);
        }
        catch (IntentUnsatifiedException iue) {
            exportRegistration.setException(iue);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    protected String getPojoAddress(Map sd, Class<?> iClass) {
        String address = OsgiUtils.getProperty(sd, "endpoint.id");
        if (address == null && sd.get("endpoint.id") != null) {
            LOG.severe("Could not use address property endpoint.id");
            return null;
        }
        if (address == null) {
            address = OsgiUtils.getProperty(sd, "org.apache.cxf.ws.address");
        }
        if (address == null && sd.get("org.apache.cxf.ws.address") != null) {
            LOG.severe("Could not use address property org.apache.cxf.ws.address");
            return null;
        }
        if (address == null) {
            address = OsgiUtils.getProperty(sd, "osgi.remote.configuration.pojo.address");
        }
        if (address == null && sd.get("osgi.remote.configuration.pojo.address") != null) {
            LOG.severe("Could not use address property osgi.remote.configuration.pojo.address");
            return null;
        }
        if (address == null) {
            address = OsgiUtils.getProperty(sd, "org.apache.cxf.rs.address");
        }
        if (address == null && sd.get("org.apache.cxf.rs.address") != null) {
            LOG.severe("Could not use address property org.apache.cxf.rs.address");
            return null;
        }
        if (address == null) {
            String port = null;
            Object p = sd.get("org.apache.cxf.ws.port");
            if (p instanceof String) {
                port = (String)p;
            }
            if ((address = this.getDefaultAddress(iClass, port)) != null) {
                LOG.info("Using a default address : " + address);
            }
        }
        return address;
    }
}

