/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.handlers;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.dosgi.dsw.OsgiUtils;
import org.apache.cxf.dosgi.dsw.handlers.AbstractConfigurationHandler;
import org.apache.cxf.dosgi.dsw.service.ExportRegistrationImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlConfigurationTypeHandler
extends AbstractConfigurationHandler {
    private static final String CONFIGURATION_TYPE = "wsdl";
    private static final Logger LOG = Logger.getLogger(WsdlConfigurationTypeHandler.class.getName());

    public WsdlConfigurationTypeHandler(BundleContext dswBC, Map<String, Object> handlerProps) {
        super(dswBC, handlerProps);
    }

    @Override
    public String getType() {
        return CONFIGURATION_TYPE;
    }

    @Override
    public Object createProxy(ServiceReference serviceReference, BundleContext dswContext, BundleContext callingContext, Class<?> iClass, EndpointDescription sd) {
        String wsdlAddressProp = this.getWsdlAddress(sd, iClass);
        if (wsdlAddressProp == null) {
            LOG.warning("WSDL address is unavailable");
            return null;
        }
        URL wsdlAddress = null;
        try {
            wsdlAddress = new URL(wsdlAddressProp);
        }
        catch (MalformedURLException ex) {
            LOG.warning("WSDL address is malformed");
            return null;
        }
        LOG.info("Creating a " + sd.getInterfaces().toArray()[0] + " client, wsdl address is " + OsgiUtils.getProperty(sd, "osgi.remote.configuration.wsdl"));
        String serviceNs = OsgiUtils.getProperty(sd, "osgi.remote.configuration.wsdl.service.ns");
        if (serviceNs == null) {
            serviceNs = PackageUtils.getNamespace(PackageUtils.getPackageName(iClass));
        }
        QName serviceQname = new QName(serviceNs, iClass.getSimpleName());
        Service service = this.createWebService(wsdlAddress, serviceQname);
        Object proxy = this.getProxy(service.getPort(iClass), iClass);
        return proxy;
    }

    Service createWebService(URL wsdlAddress, QName serviceQname) {
        return Service.create((URL)wsdlAddress, (QName)serviceQname);
    }

    @Override
    public void createServer(ExportRegistrationImpl exportRegistration, BundleContext dswContext, BundleContext callingContext, Map sd, Class<?> iClass, Object serviceBean) {
        throw new UnsupportedOperationException("No WSDL configuration is currently supported for creating service endpoints");
    }

    private String getWsdlAddress(EndpointDescription sd, Class<?> iClass) {
        String address = OsgiUtils.getProperty(sd, "osgi.remote.configuration.wsdl");
        if (address == null && (address = this.getDefaultAddress(iClass)) != null) {
            address = address + "?wsdl";
        }
        return address;
    }
}

