/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.service;

import java.util.Dictionary;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.cxf.dosgi.dsw.service.ExportReferenceImpl;
import org.apache.cxf.dosgi.dsw.service.ImportReferenceImpl;
import org.apache.cxf.dosgi.dsw.service.Utils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminEvent;

public class EventAdminHelper {
    private static final Logger LOG = Logger.getLogger(EventAdminHelper.class.getName());
    private BundleContext bctx;

    public EventAdminHelper(BundleContext bc) {
        this.bctx = bc;
    }

    private Event createEvent(Properties p, String t) {
        String topic = "org/osgi/service/remoteserviceadmin/" + t;
        Properties props = p;
        ((Dictionary)props).put("bundle", this.bctx.getBundle());
        ((Dictionary)props).put("bundle.id", this.bctx.getBundle().getBundleId());
        ((Dictionary)props).put("bundle.symbolicname", this.bctx.getBundle().getSymbolicName());
        String version = (String)this.bctx.getBundle().getHeaders().get("Bundle-Version");
        Version v = version != null ? new Version(version) : Version.emptyVersion;
        this.setIfNotNull(props, "bundle.version", v);
        return new Event(topic, (Dictionary)props);
    }

    public void notifyEventAdmin(RemoteServiceAdminEvent rsae) {
        String topic = Utils.remoteServiceAdminEventTypeToString(rsae.getType());
        Properties props = new Properties();
        this.setIfNotNull(props, "cause", rsae.getException());
        EndpointDescription epd = null;
        if (rsae.getImportReference() != null) {
            epd = ((ImportReferenceImpl)rsae.getImportReference()).getImportedEndpointAlways();
            this.setIfNotNull(props, "import.registration", epd);
        } else if (rsae.getExportReference() != null) {
            epd = ((ExportReferenceImpl)rsae.getExportReference()).getExportedEndpointAlways();
            this.setIfNotNull(props, "export.registration", epd);
        }
        if (epd != null) {
            this.setIfNotNull(props, "service.remote.id", epd.getServiceId());
            this.setIfNotNull(props, "service.remote.uuid", epd.getFrameworkUUID());
            this.setIfNotNull(props, "service.remote.uri", epd.getId());
            this.setIfNotNull(props, "objectClass", epd.getInterfaces().toArray());
            this.setIfNotNull(props, "service.imported.configs", epd.getConfigurationTypes());
        }
        props.put("timestamp", (Object)System.currentTimeMillis());
        props.put("event", rsae);
        Event ev = this.createEvent(props, topic);
        EventAdmin[] eas = this.getEventAdmins();
        if (eas != null) {
            LOG.fine("Publishing event to " + eas.length + " EventAdmins;  Topic:[" + topic + "]");
            for (EventAdmin eventAdmin : eas) {
                eventAdmin.postEvent(ev);
            }
        }
    }

    private void setIfNotNull(Dictionary props, String key, Object o) {
        if (o != null) {
            props.put(key, o);
        }
    }

    private EventAdmin[] getEventAdmins() {
        ServiceReference[] refs = null;
        try {
            refs = this.bctx.getAllServiceReferences(EventAdmin.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        if (refs == null) {
            return null;
        }
        EventAdmin[] eas = new EventAdmin[refs.length];
        for (int x = 0; x < refs.length; ++x) {
            ServiceReference serviceReference = refs[x];
            eas[x] = (EventAdmin)this.bctx.getService(serviceReference);
        }
        return eas;
    }
}

