/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.service;

import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.cxf.dosgi.dsw.service.ExportReferenceImpl;
import org.apache.cxf.dosgi.dsw.service.RemoteServiceAdminCore;
import org.apache.cxf.endpoint.Server;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.ExportReference;
import org.osgi.service.remoteserviceadmin.ExportRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ExportRegistrationImpl
implements ExportRegistration {
    private Logger LOG = Logger.getLogger(ExportRegistrationImpl.class.getName());
    private Server server;
    private boolean closed = false;
    private ServiceReference serviceReference = null;
    private EndpointDescription endpointDescription;
    private Throwable exception = null;
    private ExportRegistrationImpl parent = null;
    private int instanceCount = 1;
    private RemoteServiceAdminCore rsaCore;
    private ExportReference exportReference;
    private ServiceTracker serviceTracker;

    public ExportRegistrationImpl(ExportRegistrationImpl exportRegistration) {
        this.parent = exportRegistration;
        this.serviceReference = this.parent.getExportedService();
        this.endpointDescription = this.parent.getEndpointDescription();
        this.exception = this.parent.getException();
        this.rsaCore = this.parent.getRsaCore();
        this.parent.instanceAdded();
    }

    private synchronized void instanceAdded() {
        ++this.instanceCount;
    }

    public ExportRegistrationImpl(ServiceReference sref, EndpointDescription endpoint, RemoteServiceAdminCore remoteServiceAdminCore) {
        this.serviceReference = sref;
        this.endpointDescription = endpoint;
        this.parent = this;
        this.rsaCore = remoteServiceAdminCore;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.rsaCore.removeExportRegistration(this);
        this.parent.instanceClosed();
    }

    private synchronized void instanceClosed() {
        --this.instanceCount;
        if (this.instanceCount <= 0) {
            this.LOG.fine("really closing ExportRegistartion now! ");
            if (this.server != null) {
                this.server.stop();
            }
        }
    }

    private void closeAll() {
        if (this.parent != this) {
            this.parent.closeAll();
            return;
        }
        this.close();
    }

    public EndpointDescription getEndpointDescription() {
        if (!this.closed) {
            return this.endpointDescription;
        }
        return null;
    }

    public Throwable getException() {
        if (!this.closed) {
            return this.exception;
        }
        return null;
    }

    protected ServiceReference getServiceReference() {
        return this.serviceReference;
    }

    public ServiceReference getExportedService() throws IllegalStateException {
        if (!this.closed) {
            return this.serviceReference;
        }
        return null;
    }

    public void setEndpointdescription(EndpointDescription epd) {
        this.endpointDescription = epd;
    }

    public String toString() {
        String r = "Endpoint Desctiption for ServiceReference " + this.serviceReference;
        r = r + "\n";
        r = r + "*** EndpointDescription: **** \n";
        if (this.endpointDescription == null) {
            r = r + "---> NULL <---- \n";
        } else {
            Set<Map.Entry<String, Object>> props = this.endpointDescription.getProperties().entrySet();
            for (Map.Entry<String, Object> entry : props) {
                r = r + entry.getKey() + "  => " + entry.getValue() + "\n";
            }
        }
        r = r + "\n";
        r = r + "*** Exception: " + this.exception + " **** \n";
        r = r + "*** isClosed : " + this.closed + " ****\n";
        r = r + "\n";
        return r;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public Server getServer() {
        return this.server;
    }

    public void setException(Throwable ex) {
        this.exception = ex;
    }

    public ExportReference getExportReference() {
        if (this.exportReference == null) {
            this.exportReference = new ExportReferenceImpl(this);
        }
        return this.exportReference;
    }

    protected EndpointDescription getEndpointDescriptionAlways() {
        return this.endpointDescription;
    }

    public void startServiceTracker(BundleContext bctx) {
        Filter f;
        if (this.parent != this) {
            this.parent.startServiceTracker(bctx);
            return;
        }
        if (this.serviceTracker != null) {
            return;
        }
        final Long sid = (Long)this.serviceReference.getProperty("service.id");
        try {
            f = bctx.createFilter("(service.id=" + sid + ")");
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
            this.LOG.warning("Service tracker could not be started. The service will not be automatically unexported.");
            return;
        }
        this.serviceTracker = new ServiceTracker(bctx, f, new ServiceTrackerCustomizer(){

            public void removedService(ServiceReference sr, Object s) {
                ExportRegistrationImpl.this.LOG.info("Service [" + sid + "] has ben unregistered: Removing service export");
                ExportRegistrationImpl.this.close();
            }

            public void modifiedService(ServiceReference sr, Object s) {
                ExportRegistrationImpl.this.LOG.warning("Service modifications after the service is exported are currently not supported. The export is not modified!");
            }

            public Object addingService(ServiceReference sr) {
                return sr;
            }
        });
        this.serviceTracker.open();
    }

    public void setRsaCore(RemoteServiceAdminCore rsaCore) {
        this.rsaCore = rsaCore;
    }

    public RemoteServiceAdminCore getRsaCore() {
        return this.rsaCore;
    }
}

