/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.cxf.dosgi.dsw.ClassUtils;
import org.apache.cxf.dosgi.dsw.OsgiUtils;
import org.apache.cxf.dosgi.dsw.handlers.ClientServiceFactory;
import org.apache.cxf.dosgi.dsw.handlers.ConfigTypeHandlerFactory;
import org.apache.cxf.dosgi.dsw.handlers.ConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.qos.IntentMap;
import org.apache.cxf.dosgi.dsw.service.EventProducer;
import org.apache.cxf.dosgi.dsw.service.ExportRegistrationImpl;
import org.apache.cxf.dosgi.dsw.service.ImportRegistrationImpl;
import org.apache.cxf.dosgi.dsw.service.Utils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.ImportRegistration;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteServiceAdminCore
implements RemoteServiceAdmin {
    private Logger LOG = Logger.getLogger(RemoteServiceAdminCore.class.getName());
    private LinkedHashMap<ServiceReference, Collection<ExportRegistrationImpl>> exportedServices = new LinkedHashMap();
    private LinkedHashMap<EndpointDescription, Collection<ImportRegistrationImpl>> importedServices = new LinkedHashMap();
    private BundleContext bctx;
    private EventProducer eventProducer;
    private volatile boolean useMasterMap = true;
    private volatile String defaultPort;
    private volatile String defaultHost;
    protected static List<String> supportedConfigurationTypes = new ArrayList<String>();
    protected static final String DEFAULT_CONFIGURATION = "org.apache.cxf.ws";

    public RemoteServiceAdminCore(BundleContext bc) {
        this.bctx = bc;
        this.eventProducer = new EventProducer(this.bctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List exportService(ServiceReference serviceReference, Map additionalProperties) throws IllegalArgumentException, UnsupportedOperationException {
        this.LOG.fine("RemoteServiceAdmin: exportService: " + serviceReference.getClass().getName());
        LinkedHashMap<ServiceReference, Collection<ExportRegistrationImpl>> linkedHashMap = this.exportedServices;
        synchronized (linkedHashMap) {
            String[] keys;
            if (this.exportedServices.containsKey(serviceReference)) {
                this.LOG.fine("already exported ...  " + serviceReference.getClass().getName());
                Collection<ExportRegistrationImpl> regs = this.exportedServices.get(serviceReference);
                ArrayList<EndpointDescription> copiedEndpoints = new ArrayList<EndpointDescription>();
                ArrayList<ExportRegistrationImpl> copy = new ArrayList<ExportRegistrationImpl>(regs.size());
                for (ExportRegistrationImpl exportRegistration : regs) {
                    if (copiedEndpoints.contains(exportRegistration.getEndpointDescription())) continue;
                    copiedEndpoints.add(exportRegistration.getEndpointDescription());
                    copy.add(new ExportRegistrationImpl(exportRegistration));
                }
                regs.addAll(copy);
                this.eventProducer.publishNotifcation(copy);
                return copy;
            }
            if (this.isCreatedByThisRSA(serviceReference)) {
                this.LOG.fine("proxy provided by this bundle ...  " + serviceReference.getClass().getName());
                return Collections.EMPTY_LIST;
            }
            Properties serviceProperties = new Properties();
            for (String k : keys = serviceReference.getPropertyKeys()) {
                serviceProperties.put(k, serviceReference.getProperty(k));
            }
            if (additionalProperties != null) {
                Utils.overlayProperties(serviceProperties, additionalProperties);
            }
            String[] requiredIntents = Utils.getAllRequiredIntents(serviceProperties);
            IntentMap im = OsgiUtils.getIntentMap(this.bctx);
            ArrayList<String> unsupportedIntents = new ArrayList<String>();
            for (String ri : requiredIntents) {
                if (im.getIntents().containsKey(ri)) continue;
                unsupportedIntents.add(ri);
            }
            if (unsupportedIntents.size() > 0) {
                this.LOG.severe("service cannot be exported because the following intents are not supported by this RSA: " + unsupportedIntents);
                return Collections.EMPTY_LIST;
            }
            ArrayList<String> interfaces = new ArrayList<String>(1);
            String[] providedInterfaces = (String[])serviceProperties.get("objectClass");
            String[] allowedInterfaces = Utils.normalizeStringPlus(serviceProperties.get("service.exported.interfaces"));
            if (providedInterfaces == null || allowedInterfaces == null) {
                this.LOG.severe("export failed: no provided service interfaces found or service_exported_interfaces is null !!");
                return Collections.EMPTY_LIST;
            }
            if (allowedInterfaces.length == 1 && "*".equals(allowedInterfaces[0])) {
                for (String i : providedInterfaces) {
                    interfaces.add(i);
                }
            } else {
                for (String x : allowedInterfaces) {
                    for (String i : providedInterfaces) {
                        if (!x.equals(i)) continue;
                        interfaces.add(i);
                    }
                }
            }
            this.LOG.info("interfaces selected for export: " + interfaces);
            if (interfaces.size() == 0) {
                this.LOG.info("no interfaces to be exported");
                return Collections.EMPTY_LIST;
            }
            List<String> configurationTypes = this.determineConfigurationTypes(serviceProperties);
            this.LOG.info("configuration types selected for export: " + configurationTypes);
            if (configurationTypes.size() == 0) {
                this.LOG.info("the requested configuration types are not supported");
                return Collections.EMPTY_LIST;
            }
            LinkedHashMap<String, ExportRegistrationImpl> exportRegs = new LinkedHashMap<String, ExportRegistrationImpl>(1);
            for (String iface : interfaces) {
                this.LOG.info("creating initial ExportDescription for interface " + iface + "  with configuration types " + configurationTypes);
                ExportRegistrationImpl expReg = new ExportRegistrationImpl(serviceReference, null, this);
                exportRegs.put(iface, expReg);
            }
            this.exportedServices.put(serviceReference, new ArrayList(exportRegs.values()));
            for (String iface : interfaces) {
                this.LOG.info("creating server for interface " + iface);
                ExportRegistrationImpl exportRegistration = (ExportRegistrationImpl)exportRegs.get(iface);
                ConfigurationTypeHandler handler = this.getHandler(configurationTypes, serviceProperties, this.getHandlerProperties());
                Object serviceObject = this.bctx.getService(serviceReference);
                BundleContext callingContext = serviceReference.getBundle().getBundleContext();
                if (handler == null) {
                    return Collections.EMPTY_LIST;
                }
                this.LOG.info("found handler for " + iface + "  -> " + handler);
                String interfaceName = iface;
                Class<?> interfaceClass = ClassUtils.getInterfaceClass(serviceObject, interfaceName);
                if (interfaceClass == null) continue;
                handler.createServer(exportRegistration, this.bctx, callingContext, serviceProperties, interfaceClass, serviceObject);
                if (exportRegistration.getException() == null) {
                    this.LOG.info("created server for interface " + iface);
                    exportRegistration.startServiceTracker(this.bctx);
                    continue;
                }
                this.LOG.warning("server creation for interface " + iface + "  failed!");
            }
            ArrayList<ExportRegistrationImpl> lExpReg = new ArrayList<ExportRegistrationImpl>(exportRegs.values());
            this.eventProducer.publishNotifcation(lExpReg);
            return lExpReg;
        }
    }

    protected List<String> determineConfigurationTypes(Properties serviceProperties) {
        ArrayList<String> configurationTypes = new ArrayList<String>();
        String[] requestedConfigurationTypes = Utils.normalizeStringPlus(serviceProperties.get("service.exported.configs"));
        if (requestedConfigurationTypes == null || requestedConfigurationTypes.length == 0) {
            configurationTypes.add(DEFAULT_CONFIGURATION);
        } else {
            for (String rct : requestedConfigurationTypes) {
                if (!supportedConfigurationTypes.contains(rct)) continue;
                configurationTypes.add(rct);
            }
        }
        return configurationTypes;
    }

    private boolean isCreatedByThisRSA(ServiceReference sref) {
        return sref.getBundle().equals(this.bctx.getBundle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getExportedServices() {
        LinkedHashMap<ServiceReference, Collection<ExportRegistrationImpl>> linkedHashMap = this.exportedServices;
        synchronized (linkedHashMap) {
            ArrayList<ExportRegistrationImpl> ers = new ArrayList<ExportRegistrationImpl>();
            for (Collection<ExportRegistrationImpl> exportRegistrations : this.exportedServices.values()) {
                ers.addAll(exportRegistrations);
            }
            return Collections.unmodifiableCollection(ers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getImportedEndpoints() {
        LinkedHashMap<EndpointDescription, Collection<ImportRegistrationImpl>> linkedHashMap = this.importedServices;
        synchronized (linkedHashMap) {
            ArrayList<ImportRegistrationImpl> irs = new ArrayList<ImportRegistrationImpl>();
            for (Collection<ImportRegistrationImpl> irl : this.importedServices.values()) {
                irs.addAll(irl);
            }
            return Collections.unmodifiableCollection(irs);
        }
    }

    private ConfigurationTypeHandler getHandler(List<String> configurationTypes, Map serviceProperties, Map<String, Object> props) {
        return ConfigTypeHandlerFactory.getInstance().getHandler(this.bctx, configurationTypes, serviceProperties, props);
    }

    protected Map<String, Object> getHandlerProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("default.port", this.defaultPort == null ? "9000" : this.defaultPort);
        props.put("default.host", this.defaultHost == null ? "localhost" : this.defaultHost);
        props.put("use.master.map", this.useMasterMap);
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportRegistration importService(EndpointDescription endpoint) {
        this.LOG.info("importService() Endpoint: " + endpoint.getProperties());
        LinkedHashMap<EndpointDescription, Collection<ImportRegistrationImpl>> linkedHashMap = this.importedServices;
        synchronized (linkedHashMap) {
            if (this.importedServices.containsKey(endpoint) && this.importedServices.get(endpoint).size() > 0) {
                this.LOG.fine("creating copy of existing import registrations");
                Collection<ImportRegistrationImpl> imRegs = this.importedServices.get(endpoint);
                ImportRegistrationImpl irParent = imRegs.iterator().next();
                ImportRegistrationImpl ir = new ImportRegistrationImpl(irParent);
                imRegs.add(ir);
                this.eventProducer.publishNotifcation(ir);
                return ir;
            }
            List<String> remoteConfigurationTypes = endpoint.getConfigurationTypes();
            if (remoteConfigurationTypes == null) {
                this.LOG.severe("the supplied endpoint has no configuration type");
                return null;
            }
            ArrayList<String> usableConfigurationTypes = new ArrayList<String>();
            for (String ct : supportedConfigurationTypes) {
                if (!remoteConfigurationTypes.contains(ct)) continue;
                usableConfigurationTypes.add(ct);
            }
            if (usableConfigurationTypes.size() == 0) {
                this.LOG.severe("the supplied endpoint has no compatible configuration type. Supported types are: " + supportedConfigurationTypes + "    Types needed by the endpoint: " + remoteConfigurationTypes);
                return null;
            }
            Map emptyProps = Collections.EMPTY_MAP;
            ConfigurationTypeHandler handler = this.getHandler(usableConfigurationTypes, endpoint.getProperties(), emptyProps);
            if (handler == null) {
                this.LOG.severe("no handler found");
                return null;
            }
            this.LOG.fine("Handler: " + handler);
            List<String> matchingInterfaces = endpoint.getInterfaces();
            this.LOG.info("Interfaces: " + matchingInterfaces);
            if (matchingInterfaces.size() == 1) {
                this.LOG.info("Proxifying interface : " + matchingInterfaces.get(0));
                ImportRegistrationImpl imReg = new ImportRegistrationImpl(endpoint, this);
                this.proxifyMatchingInterface(matchingInterfaces.get(0), imReg, handler, this.bctx);
                Collection<ImportRegistrationImpl> imRegs = this.importedServices.get(endpoint);
                if (imRegs == null) {
                    imRegs = new ArrayList<ImportRegistrationImpl>();
                    this.importedServices.put(endpoint, imRegs);
                }
                imRegs.add(imReg);
                this.eventProducer.publishNotifcation(imReg);
                return imReg;
            }
            return null;
        }
    }

    protected void proxifyMatchingInterface(String interfaceName, ImportRegistrationImpl imReg, ConfigurationTypeHandler handler, BundleContext requestingContext) {
        try {
            Class iClass = this.bctx.getBundle().loadClass(interfaceName);
            if (iClass != null) {
                BundleContext actualContext = this.bctx;
                Class actualClass = requestingContext.getBundle().loadClass(interfaceName);
                if (actualClass != iClass) {
                    this.LOG.info("Class " + interfaceName + " loaded by DSW's bundle context is not " + "equal to the one loaded by the requesting bundle context, " + "DSW will use the requesting bundle context to register " + "a proxy service");
                    iClass = actualClass;
                    actualContext = requestingContext;
                }
                Hashtable<String, Object> serviceProps = new Hashtable<String, Object>(imReg.getImportedEndpointDescription().getProperties());
                ((Dictionary)serviceProps).put("service.imported", true);
                ((Dictionary)serviceProps).remove("service.exported.interfaces");
                ClientServiceFactory csf = new ClientServiceFactory(actualContext, iClass, imReg.getImportedEndpointDescription(), handler, imReg);
                imReg.setClientServiceFactory(csf);
                ServiceRegistration proxyRegistration = actualContext.registerService(interfaceName, (Object)csf, serviceProps);
                imReg.setImportedServiceRegistration(proxyRegistration);
            } else {
                this.LOG.info("not proxifying service, cannot load interface class: " + interfaceName);
                imReg.setException(new ClassNotFoundException("not proxifying service, cannot load interface class: " + interfaceName));
            }
        }
        catch (ClassNotFoundException ex) {
            this.LOG.warning("No class can be found for " + interfaceName);
            imReg.setException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeExportRegistration(ExportRegistrationImpl eri) {
        LinkedHashMap<ServiceReference, Collection<ExportRegistrationImpl>> linkedHashMap = this.exportedServices;
        synchronized (linkedHashMap) {
            Collection<ExportRegistrationImpl> exRegs = this.exportedServices.get(eri.getServiceReference());
            if (exRegs != null && exRegs.contains(eri)) {
                exRegs.remove(eri);
            } else {
                this.LOG.severe("An exportRegistartion was intended to be removed form internal management structure but couldn't be found in it !! ");
            }
            if (exRegs == null || exRegs.size() == 0) {
                this.exportedServices.remove(eri.getServiceReference());
            }
            this.eventProducer.notifyRemoval(eri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeImportRegistration(ImportRegistrationImpl iri) {
        LinkedHashMap<EndpointDescription, Collection<ImportRegistrationImpl>> linkedHashMap = this.importedServices;
        synchronized (linkedHashMap) {
            this.LOG.finest("Removing importRegistration " + iri);
            Collection<ImportRegistrationImpl> imRegs = this.importedServices.get(iri.getImportedEndpointAlways());
            if (imRegs != null && imRegs.contains(iri)) {
                imRegs.remove(iri);
            } else {
                this.LOG.severe("An importRegistartion was intended to be removed form internal management structure but couldn't be found in it !! ");
            }
            if (imRegs == null || imRegs.size() == 0) {
                this.importedServices.remove(iri.getImportedEndpointAlways());
            }
            this.eventProducer.notifyRemoval(iri);
        }
    }

    static {
        supportedConfigurationTypes.add("wsdl");
        supportedConfigurationTypes.add("org.apache.cxf.rs");
        supportedConfigurationTypes.add(DEFAULT_CONFIGURATION);
        supportedConfigurationTypes.add("pojo");
    }
}

