/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.service;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.dosgi.dsw.OsgiUtils;
import org.apache.cxf.dosgi.dsw.service.RemoteServiceAdminCore;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointPermission;
import org.osgi.service.remoteserviceadmin.ExportRegistration;
import org.osgi.service.remoteserviceadmin.ImportRegistration;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdmin;

public class RemoteServiceAdminInstance
implements RemoteServiceAdmin {
    Logger LOG = Logger.getLogger(RemoteServiceAdminInstance.class.getName());
    private BundleContext bctx;
    private RemoteServiceAdminCore rsaCore;
    private boolean closed = false;
    private List<ImportRegistration> importedServices = new ArrayList<ImportRegistration>();
    private List<ExportRegistration> exportedServices = new ArrayList<ExportRegistration>();

    public RemoteServiceAdminInstance(BundleContext bc, RemoteServiceAdminCore core) {
        this.bctx = bc;
        this.rsaCore = core;
    }

    public List exportService(ServiceReference ref, Map properties) throws IllegalArgumentException, UnsupportedOperationException {
        SecurityManager sm = System.getSecurityManager();
        EndpointPermission epp = new EndpointPermission("*", "export");
        if (sm != null) {
            sm.checkPermission(epp);
        }
        final ServiceReference refFinal = ref;
        final Map propertiesFinal = properties;
        return AccessController.doPrivileged(new PrivilegedAction<List>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List run() {
                if (RemoteServiceAdminInstance.this.closed) {
                    return Collections.EMPTY_LIST;
                }
                List list = RemoteServiceAdminInstance.this.exportedServices;
                synchronized (list) {
                    List er = RemoteServiceAdminInstance.this.rsaCore.exportService(refFinal, propertiesFinal);
                    if (er != null) {
                        RemoteServiceAdminInstance.this.exportedServices.addAll(er);
                    }
                    return er;
                }
            }
        });
    }

    public Collection getExportedServices() {
        SecurityManager sm = System.getSecurityManager();
        EndpointPermission epp = new EndpointPermission("*", "read");
        if (sm != null) {
            sm.checkPermission(epp);
        }
        if (this.closed) {
            return null;
        }
        return this.rsaCore.getExportedServices();
    }

    public Collection getImportedEndpoints() {
        SecurityManager sm = System.getSecurityManager();
        EndpointPermission epp = new EndpointPermission("*", "read");
        if (sm != null) {
            sm.checkPermission(epp);
        }
        if (this.closed) {
            return null;
        }
        return this.rsaCore.getImportedEndpoints();
    }

    public ImportRegistration importService(EndpointDescription endpoint) {
        final EndpointDescription epd = endpoint;
        SecurityManager sm = System.getSecurityManager();
        EndpointPermission epp = new EndpointPermission(epd, OsgiUtils.getUUID(this.bctx), "import");
        if (sm != null) {
            sm.checkPermission(epp);
        }
        return AccessController.doPrivileged(new PrivilegedAction<ImportRegistration>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ImportRegistration run() {
                if (RemoteServiceAdminInstance.this.closed) {
                    return null;
                }
                List list = RemoteServiceAdminInstance.this.importedServices;
                synchronized (list) {
                    ImportRegistration ir = RemoteServiceAdminInstance.this.rsaCore.importService(epd);
                    if (ir != null) {
                        RemoteServiceAdminInstance.this.importedServices.add(ir);
                    }
                    return ir;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.closed = true;
        List<Object> list = this.importedServices;
        synchronized (list) {
            this.LOG.info("Removing all services imported by this RSA instance");
            for (ImportRegistration ir : this.importedServices) {
                this.LOG.finest("Closing ImportRegistration " + ir);
                ir.close();
            }
        }
        list = this.exportedServices;
        synchronized (list) {
            this.LOG.info("Removing all services exported by this RSA instance");
            for (ExportRegistration er : this.exportedServices) {
                this.LOG.finest("Closing ExportRegistration " + er);
                er.close();
            }
        }
    }
}

