/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;

public class Utils {
    private static final Logger LOG = Logger.getLogger(Utils.class.getName());

    public static String[] normalizeStringPlus(Object object) {
        if (object instanceof String) {
            String s = (String)object;
            String[] ret = new String[]{s};
            return ret;
        }
        if (object instanceof String[]) {
            return (String[])object;
        }
        if (object instanceof Collection) {
            Collection col = (Collection)object;
            ArrayList<String> ar = new ArrayList<String>(col.size());
            for (Object o : col) {
                if (o instanceof String) {
                    String s = (String)o;
                    ar.add(s);
                    continue;
                }
                LOG.warning("stringPlus contained non string element in list ! Element was skipped");
            }
            return ar.toArray(new String[ar.size()]);
        }
        return null;
    }

    public static String remoteServiceAdminEventTypeToString(int type) {
        switch (type) {
            case 6: {
                return "EXPORT_ERROR";
            }
            case 2: {
                return "EXPORT_REGISTRATION";
            }
            case 3: {
                return "EXPORT_UNREGISTRATION";
            }
            case 7: {
                return "EXPORT_WARNING";
            }
            case 5: {
                return "IMPORT_ERROR";
            }
            case 1: {
                return "IMPORT_REGISTRATION";
            }
            case 4: {
                return "IMPORT_UNREGISTRATION";
            }
            case 8: {
                return "IMPORT_WARNING";
            }
        }
        return "UNKNOWN_EVENT";
    }

    public static String[] getAllRequiredIntents(Map serviceProperties) {
        String[] requiredExtraIntents;
        String[] requiredIntents = Utils.normalizeStringPlus(serviceProperties.get("service.exported.intents"));
        if (requiredIntents == null) {
            requiredIntents = new String[]{};
        }
        if ((requiredExtraIntents = Utils.normalizeStringPlus(serviceProperties.get("service.exported.intents.extra"))) != null && requiredExtraIntents.length > 0) {
            requiredIntents = Utils.mergeArrays(requiredIntents, requiredExtraIntents);
        }
        return requiredIntents;
    }

    public static String[] getInetntsImplementedByTheService(Map serviceProperties) {
        String[] serviceIntents = Utils.normalizeStringPlus(serviceProperties.get("service.intents"));
        return serviceIntents;
    }

    public static String[] mergeArrays(String[] a1, String[] a2) {
        if (a1 == null) {
            return a2;
        }
        if (a2 == null) {
            return a1;
        }
        ArrayList<String> list = new ArrayList<String>(a1.length + a2.length);
        for (String s : a1) {
            list.add(s);
        }
        for (String s : a2) {
            if (list.contains(s)) continue;
            list.add(s);
        }
        return list.toArray(new String[list.size()]);
    }

    public static void overlayProperties(Properties serviceProperties, Map additionalProperties) {
        Enumeration<Object> keys = serviceProperties.keys();
        HashMap<String, String> keysLowerCase = new HashMap<String, String>();
        while (keys.hasMoreElements()) {
            Object o = keys.nextElement();
            if (!(o instanceof String)) continue;
            String ks = (String)o;
            keysLowerCase.put(ks.toLowerCase(), ks);
        }
        Set adProps = additionalProperties.entrySet();
        for (Map.Entry e : adProps) {
            Object keyObj = e.getKey();
            if (!(keyObj instanceof String) || keyObj == null) continue;
            String key = ((String)keyObj).toLowerCase();
            if ("service.id".toLowerCase().equals(key) || "objectClass".toLowerCase().equals(key)) {
                LOG.info("exportService called with additional properties map that contained illegal key: " + key + "   The key is ignored");
                continue;
            }
            if (keysLowerCase.containsKey(key)) {
                String origKey = (String)keysLowerCase.get(key);
                serviceProperties.put(origKey, e.getValue());
                LOG.fine("Overwriting property [" + origKey + "]  with value [" + e.getValue() + "]");
                continue;
            }
            serviceProperties.put(e.getKey(), e.getValue());
            keysLowerCase.put(e.getKey().toString().toLowerCase(), e.getKey().toString());
        }
    }
}

