/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.singlebundle;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cxf.dosgi.singlebundle.DSWActivator;
import org.apache.cxf.dosgi.singlebundle.SPIActivator;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatedActivator
implements BundleActivator {
    static final String HTTP_PORT_PROPERTY = "org.osgi.service.http.port";
    static final String HTTPS_PORT_PROPERTY = "org.osgi.service.http.port.secure";
    static final String HTTPS_ENABLED_PROPERTY = "org.osgi.service.http.secure.enabled";
    static final String ACTIVATOR_RESOURCE = "activators.list";
    static String DEFAULT_HTTP_PORT = "8080";
    private List<BundleActivator> activators = new ArrayList<BundleActivator>();

    public void start(BundleContext ctx) throws Exception {
        this.setHttpServicePort(ctx);
        this.startEmbeddedActivators(ctx);
    }

    public void stop(BundleContext ctx) throws Exception {
        this.stopEmbeddedActivators(ctx);
    }

    void setHttpServicePort(BundleContext ctx) {
        String port;
        boolean https = false;
        if ("true".equalsIgnoreCase(ctx.getProperty(HTTPS_ENABLED_PROPERTY))) {
            https = true;
            port = ctx.getProperty(HTTPS_PORT_PROPERTY);
        } else {
            port = ctx.getProperty(HTTP_PORT_PROPERTY);
        }
        if (port == null || port.length() == 0) {
            port = this.tryPortFree(DEFAULT_HTTP_PORT);
            if (port == null) {
                port = this.tryPortFree("0");
            }
            String prop = https ? HTTPS_PORT_PROPERTY : HTTP_PORT_PROPERTY;
            System.setProperty(prop, port);
        } else if (this.tryPortFree(port) == null) {
            System.out.println("The system is configured to use HttpService port " + port + ". However this port is already in use.");
        } else {
            System.out.println("HttpService using port: " + port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String tryPortFree(String port) {
        int p = Integer.parseInt(port);
        ServerSocket s = null;
        try {
            s = new ServerSocket(p);
            String string = "" + s.getLocalPort();
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startEmbeddedActivators(BundleContext ctx) throws Exception {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            for (String s : AggregatedActivator.getActivators()) {
                try {
                    Class<?> clazz = this.getClass().getClassLoader().loadClass(s);
                    Object o = clazz.newInstance();
                    if (!(o instanceof BundleActivator)) continue;
                    BundleActivator ba = (BundleActivator)o;
                    this.activators.add(ba);
                    ba.start(ctx);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
            SPIActivator sba = new SPIActivator();
            sba.start(ctx);
            this.activators.add(sba);
            DSWActivator dsw = new DSWActivator();
            dsw.start(ctx);
            this.activators.add(dsw);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    void stopEmbeddedActivators(BundleContext ctx) throws Exception {
        for (BundleActivator ba : this.activators) {
            ba.stop(ctx);
        }
    }

    static Collection<String> getActivators() throws IOException {
        ArrayList<String> bundleActivators = new ArrayList<String>();
        URL url = AggregatedActivator.class.getResource(ACTIVATOR_RESOURCE);
        if (url == null) {
            return Collections.emptyList();
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
        String line = null;
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).length() <= 0) continue;
            bundleActivators.add(line);
        }
        return bundleActivators;
    }
}

