/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.topologymanager;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.cxf.dosgi.topologymanager.TopologyManagerImport;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointListener;

public class EndpointListenerImpl
implements EndpointListener {
    private static final Logger LOG = Logger.getLogger(EndpointListenerImpl.class.getName());
    private final BundleContext bctx;
    private ServiceRegistration serviceRegistration;
    private List<String> filters = new ArrayList<String>();
    private TopologyManagerImport topManager;

    protected EndpointListenerImpl(BundleContext bc, TopologyManagerImport tm) {
        this.bctx = bc;
        this.topManager = tm;
    }

    protected void start() {
        this.serviceRegistration = this.bctx.registerService(EndpointListener.class.getName(), (Object)this, this.getRegistrationProperties());
    }

    protected void stop() {
        this.serviceRegistration.unregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extendScope(String filter) {
        if (filter == null) {
            return;
        }
        LOG.info("EndpointListener: extending scope by " + filter);
        List<String> list = this.filters;
        synchronized (list) {
            this.filters.add(filter);
        }
        this.updateRegistration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reduceScope(String filter) {
        if (filter == null) {
            return;
        }
        LOG.info("EndpointListener: reducing scope by " + filter);
        List<String> list = this.filters;
        synchronized (list) {
            this.filters.remove(filter);
        }
        this.updateRegistration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dictionary getRegistrationProperties() {
        Properties p = new Properties();
        List<String> list = this.filters;
        synchronized (list) {
            LOG.info("EndpointListener: current filter: " + this.filters);
            p.put("endpoint.listener.scope", this.filters);
        }
        return p;
    }

    private void updateRegistration() {
        LOG.info("EndpointListenerImpl: filters: " + this.filters);
        this.serviceRegistration.setProperties(this.getRegistrationProperties());
    }

    public void endpointAdded(EndpointDescription epd, String filter) {
        LOG.info("EndpointListenerImpl: EndpointAdded() filter:" + filter + "  EndpointDesc:" + epd);
        if (filter == null) {
            LOG.severe("Endpoint is not handled because no matching filter was provided! Filter: " + filter);
            return;
        }
        this.topManager.addImportableService(filter, epd);
    }

    public void endpointRemoved(EndpointDescription epd, String filter) {
        LOG.info("EndpointListenerImpl: EndpointRemoved() -> " + epd);
        this.topManager.removeImportableService(filter, epd);
    }
}

