/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.topologymanager;

import java.util.logging.Logger;
import org.apache.cxf.dosgi.topologymanager.TopologyManager;
import org.apache.cxf.dosgi.topologymanager.TopologyManagerImport;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminEvent;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminListener;

public class RemoteServiceAdminListenerImpl
implements RemoteServiceAdminListener {
    private Logger LOG = Logger.getLogger(RemoteServiceAdminListenerImpl.class.getName());
    private BundleContext bctx;
    private ServiceRegistration serviceRegistration;
    private TopologyManager topManager;
    private TopologyManagerImport topManagerImport;

    public RemoteServiceAdminListenerImpl(BundleContext bctx, TopologyManager tm, TopologyManagerImport tmi) {
        this.bctx = bctx;
        this.topManager = tm;
        this.topManagerImport = tmi;
    }

    public void start() {
        this.serviceRegistration = this.bctx.registerService(RemoteServiceAdminListener.class.getName(), (Object)this, null);
    }

    public void stop() {
        this.serviceRegistration.unregister();
    }

    public void remoteAdminEvent(RemoteServiceAdminEvent event) {
        this.LOG.fine("Received RemoteAdminEvent: " + event + "   TYPE: " + event.getType());
        switch (event.getType()) {
            case 3: {
                this.topManager.removeExportReference(event.getExportReference());
                break;
            }
            case 4: {
                this.topManagerImport.removeImportReference(event.getImportReference());
                break;
            }
            default: {
                this.LOG.info("Unhandled event type received: " + event.getType());
            }
        }
    }
}

