/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.topologymanager;

import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.cxf.dosgi.topologymanager.RemoteServiceAdminList;
import org.apache.cxf.dosgi.topologymanager.ServiceListenerImpl;
import org.apache.cxf.dosgi.topologymanager.Utils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointListener;
import org.osgi.service.remoteserviceadmin.ExportReference;
import org.osgi.service.remoteserviceadmin.ExportRegistration;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdmin;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopologyManager {
    private static final Logger LOG = Logger.getLogger(TopologyManager.class.getName());
    private ExecutorService execService = new ThreadPoolExecutor(5, 10, 50L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private RemoteServiceAdminList remoteServiceAdminList;
    private ServiceListenerImpl serviceListerner;
    private HashMap<ServiceReference, HashMap<RemoteServiceAdmin, Collection<ExportRegistration>>> exportedServices = new LinkedHashMap<ServiceReference, HashMap<RemoteServiceAdmin, Collection<ExportRegistration>>>();
    private BundleContext bctx;
    private ServiceTracker stEndpointListeners;

    public TopologyManager(BundleContext ctx, RemoteServiceAdminList rsaList) {
        this.bctx = ctx;
        this.remoteServiceAdminList = rsaList;
        this.stEndpointListeners = new ServiceTracker(ctx, EndpointListener.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                LOG.info("TopologyManager: new EndpointListener that wants to be informed about wants going on ... ");
                this.notify(reference);
                return super.addingService(reference);
            }

            public void modifiedService(ServiceReference reference, Object service) {
                LOG.info("TopologyManager: EndpointListener changed ... ");
                this.notify(reference);
                super.modifiedService(reference, service);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void notify(ServiceReference reference) {
                HashMap hashMap = TopologyManager.this.exportedServices;
                synchronized (hashMap) {
                    for (HashMap exports : TopologyManager.this.exportedServices.values()) {
                        for (Collection regs : exports.values()) {
                            if (regs == null) continue;
                            TopologyManager.this.notifyListenerOfAddingIfAppropriate(reference, regs);
                        }
                    }
                }
            }
        };
        this.serviceListerner = new ServiceListenerImpl(this.bctx, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeRemoteServiceAdmin(RemoteServiceAdmin rsa) {
        HashMap<ServiceReference, HashMap<RemoteServiceAdmin, Collection<ExportRegistration>>> hashMap = this.exportedServices;
        synchronized (hashMap) {
            for (Map.Entry<ServiceReference, HashMap<RemoteServiceAdmin, Collection<ExportRegistration>>> exports : this.exportedServices.entrySet()) {
                if (!exports.getValue().containsKey(rsa)) continue;
                Collection<ExportRegistration> endpoints = exports.getValue().get(rsa);
                try {
                    ServiceReference[] refs;
                    for (ServiceReference sref : refs = Utils.getEndpointListeners(this.bctx)) {
                        this.notifyListenersOfRemovalIfAppropriate(sref, endpoints);
                    }
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                }
                exports.getValue().remove(rsa);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerExportImportForRemoteSericeAdmin(RemoteServiceAdmin rsa) {
        LOG.info("TopologyManager: triggerExportImportForRemoteSericeAdmin()");
        HashMap<ServiceReference, HashMap<RemoteServiceAdmin, Collection<ExportRegistration>>> hashMap = this.exportedServices;
        synchronized (hashMap) {
            for (Map.Entry<ServiceReference, HashMap<RemoteServiceAdmin, Collection<ExportRegistration>>> exports : this.exportedServices.entrySet()) {
                if (exports.getValue().containsKey(rsa)) {
                    LOG.info("TopologyManager: service from bundle " + exports.getKey().getBundle().getSymbolicName() + "is already handled by this RSA");
                    continue;
                }
                LOG.info("TopologyManager: service from bundle " + exports.getKey().getBundle().getSymbolicName() + " is to be exported by this RSA");
                this.triggerExport(exports.getKey());
            }
        }
    }

    public void start() {
        this.stEndpointListeners.open();
        this.serviceListerner.start();
        try {
            this.checkExistingServices();
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        this.execService.shutdown();
        this.stEndpointListeners.close();
        this.serviceListerner.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeService(ServiceReference sref) {
        HashMap<ServiceReference, HashMap<RemoteServiceAdmin, Collection<ExportRegistration>>> hashMap = this.exportedServices;
        synchronized (hashMap) {
            if (this.exportedServices.containsKey(sref)) {
                Map rsas = this.exportedServices.get(sref);
                for (Map.Entry entry : rsas.entrySet()) {
                    if (entry.getValue() == null) continue;
                    for (ExportRegistration exReg : (Collection)entry.getValue()) {
                        if (exReg == null) continue;
                        exReg.close();
                    }
                }
                this.exportedServices.remove(sref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportService(ServiceReference sref) {
        HashMap<ServiceReference, HashMap<RemoteServiceAdmin, Collection<ExportRegistration>>> hashMap = this.exportedServices;
        synchronized (hashMap) {
            LOG.info("TopologyManager: adding service to exportedServices list to export it --- from bundle:  " + sref.getBundle().getSymbolicName());
            this.exportedServices.put(sref, new LinkedHashMap());
        }
        this.triggerExport(sref);
    }

    private void triggerExport(final ServiceReference sref) {
        this.execService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                LOG.info("TopologyManager: exporting  serice ...");
                HashMap exports = null;
                HashMap hashMap = TopologyManager.this.exportedServices;
                synchronized (hashMap) {
                    exports = (HashMap)TopologyManager.this.exportedServices.get(sref);
                }
                if (exports != null) {
                    hashMap = exports;
                    synchronized (hashMap) {
                        RemoteServiceAdminList remoteServiceAdminList = TopologyManager.this.remoteServiceAdminList;
                        synchronized (remoteServiceAdminList) {
                            for (RemoteServiceAdmin remoteServiceAdmin : TopologyManager.this.remoteServiceAdminList) {
                                LOG.info("TopologyManager: handling remoteServiceAdmin " + remoteServiceAdmin);
                                if (exports.containsKey(remoteServiceAdmin)) {
                                    LOG.info("TopologyManager: already handled by this remoteServiceAdmin -> skipping");
                                    continue;
                                }
                                LOG.info("TopologyManager: exporting ...");
                                Collection<ExportRegistration> endpoints = remoteServiceAdmin.exportService(sref, null);
                                if (endpoints == null) {
                                    LOG.info("TopologyManager: export failed");
                                    exports.put(remoteServiceAdmin, null);
                                    continue;
                                }
                                LOG.info("TopologyManager: export sucessful Endpoints:" + endpoints);
                                exports.put(remoteServiceAdmin, endpoints);
                                TopologyManager.this.nofifyListeners(endpoints);
                            }
                        }
                    }
                }
            }
        });
    }

    protected void nofifyListeners(Collection<ExportRegistration> exportRegistrations) {
        try {
            ServiceReference[] refs = Utils.getEndpointListeners(this.bctx);
            if (refs != null) {
                for (ServiceReference sref : refs) {
                    this.notifyListenerOfAddingIfAppropriate(sref, exportRegistrations);
                }
            }
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
    }

    protected void notifyListenerOfAddingIfAppropriate(ServiceReference sref, Collection<ExportRegistration> exportRegistrations) {
        EndpointListener epl = (EndpointListener)this.bctx.getService(sref);
        LOG.info("TopologyManager: notifyListenerOfAddingIfAppropriate() ");
        try {
            List<Filter> filters = Utils.normalizeScope(sref, this.bctx);
            for (ExportRegistration exReg : exportRegistrations) {
                Map<String, Object> props = exReg.getExportReference().getExportedEndpoint().getProperties();
                Hashtable<String, Object> d = new Hashtable<String, Object>(props);
                for (Filter filter : filters) {
                    LOG.info("Matching: " + filter + "  against " + d);
                }
                for (Filter filter : filters) {
                    if (!filter.match(d)) continue;
                    LOG.info("Listener mached one of the Endpoints !!!!: " + epl);
                    epl.endpointAdded(exReg.getExportReference().getExportedEndpoint(), filter.toString());
                }
            }
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
    }

    protected void notifyListenersOfRemovalIfAppropriate(ServiceReference sref, Collection<ExportRegistration> exportRegistrations) {
        EndpointListener epl = (EndpointListener)this.bctx.getService(sref);
        LOG.info("TopologyManager: notifyListenerOfREMOVALIfAppropriate() ");
        try {
            List<Filter> filters = Utils.normalizeScope(sref, this.bctx);
            for (ExportRegistration exReg : exportRegistrations) {
                Map<String, Object> props = exReg.getExportReference().getExportedEndpoint().getProperties();
                Hashtable<String, Object> d = new Hashtable<String, Object>(props);
                for (Filter filter : filters) {
                    LOG.info("Matching: " + filter + "  against " + d);
                }
                for (Filter filter : filters) {
                    if (!filter.match(d)) continue;
                    LOG.info("Listener matched one of the Endpoints !!!! --> calling removed() ...");
                    epl.endpointRemoved(exReg.getExportReference().getExportedEndpoint(), filter.toString());
                }
            }
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
    }

    private void checkExistingServices() throws InvalidSyntaxException {
        ServiceReference[] references = this.bctx.getServiceReferences(null, "(service.exported.interfaces=*)");
        if (references != null) {
            for (ServiceReference sref : references) {
                this.exportService(sref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExportRegistration(ExportRegistration exportRegistration) {
        ServiceReference sref = exportRegistration.getExportReference().getExportedService();
        if (sref != null) {
            HashMap<ServiceReference, HashMap<RemoteServiceAdmin, Collection<ExportRegistration>>> hashMap = this.exportedServices;
            synchronized (hashMap) {
                HashMap<RemoteServiceAdmin, Collection<ExportRegistration>> ex = this.exportedServices.get(sref);
                if (ex != null) {
                    EndpointDescription ep = exportRegistration.getExportReference().getExportedEndpoint();
                    for (Map.Entry<RemoteServiceAdmin, Collection<ExportRegistration>> export : ex.entrySet()) {
                        export.getValue().contains(exportRegistration);
                    }
                }
            }
        }
    }

    public void removeExportReference(ExportReference anyObject) {
    }
}

