/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.topologymanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.cxf.dosgi.topologymanager.EndpointListenerImpl;
import org.apache.cxf.dosgi.topologymanager.ListenerHookImpl;
import org.apache.cxf.dosgi.topologymanager.RemoteServiceAdminList;
import org.apache.cxf.dosgi.topologymanager.Utils;
import org.osgi.framework.BundleContext;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.ImportReference;
import org.osgi.service.remoteserviceadmin.ImportRegistration;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdmin;

public class TopologyManagerImport {
    private static final Logger LOG = Logger.getLogger(TopologyManagerImport.class.getName());
    private ExecutorService execService = new ThreadPoolExecutor(5, 10, 50L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private EndpointListenerImpl endpointListener;
    private BundleContext bctx;
    private RemoteServiceAdminList remoteServiceAdminList;
    private ListenerHookImpl listenerHook;
    private boolean importAllAvailable = true;
    private Map<String, ImportInterest> importInterests = new HashMap<String, ImportInterest>();
    private Map<String, List<EndpointDescription>> importPossibilities = new HashMap<String, List<EndpointDescription>>();
    private Map<String, List<ImportRegistration>> importedServices = new HashMap<String, List<ImportRegistration>>();

    public TopologyManagerImport(BundleContext bc, RemoteServiceAdminList rsaList) {
        this.bctx = bc;
        this.remoteServiceAdminList = rsaList;
        this.endpointListener = new EndpointListenerImpl(this.bctx, this);
        this.listenerHook = new ListenerHookImpl(this.bctx, this);
    }

    public void start() {
        this.endpointListener.start();
        this.listenerHook.start();
    }

    public void stop() {
        this.execService.shutdown();
        this.endpointListener.stop();
        this.listenerHook.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addServiceInterest(String filter) {
        String exFilter = Utils.extendFilter(filter, this.bctx);
        Map<String, ImportInterest> map = this.importInterests;
        synchronized (map) {
            ImportInterest i = this.importInterests.get(exFilter);
            if (i != null) {
                i.addReference();
            } else {
                this.importInterests.put(exFilter, new ImportInterest(exFilter));
                this.endpointListener.extendScope(exFilter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceInterest(String filter) {
        String exFilter = Utils.extendFilter(filter, this.bctx);
        Map<String, ImportInterest> map = this.importInterests;
        synchronized (map) {
            ImportInterest i = this.importInterests.get(exFilter);
            if (i != null && i.removeReference() <= 0) {
                LOG.fine("last reference to import interest is gone -> removing interest  filter:" + exFilter);
                this.endpointListener.reduceScope(exFilter);
                this.importInterests.remove(exFilter);
                List<ImportRegistration> irs = this.importedServices.remove(exFilter);
                if (irs != null) {
                    for (ImportRegistration ir : irs) {
                        if (ir == null) continue;
                        ir.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImportableService(String filter, EndpointDescription epd) {
        Map<String, List<EndpointDescription>> map = this.importPossibilities;
        synchronized (map) {
            List<EndpointDescription> ips = this.importPossibilities.get(filter);
            if (ips != null) {
                ips.remove(epd);
            }
        }
        this.triggerImport(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImportableService(String filter, EndpointDescription epd) {
        LOG.fine("importable service added for filter " + filter + " -> " + epd);
        Map<String, List<EndpointDescription>> map = this.importPossibilities;
        synchronized (map) {
            List<EndpointDescription> ips = this.importPossibilities.get(filter);
            if (ips == null) {
                ips = new ArrayList<EndpointDescription>();
                this.importPossibilities.put(filter, ips);
            }
            ips.add(epd);
        }
        this.triggerImport(filter);
    }

    private void triggerImport(final String filter) {
        LOG.fine("import of a service for filter " + filter + " was queued");
        this.execService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Map map = TopologyManagerImport.this.importedServices;
                synchronized (map) {
                    Map map2 = TopologyManagerImport.this.importPossibilities;
                    synchronized (map2) {
                        if (TopologyManagerImport.this.importAllAvailable) {
                            TopologyManagerImport.this.importAllServicesStrategy(filter);
                        } else {
                            TopologyManagerImport.this.importSingleServiceStrategy(filter);
                        }
                    }
                }
            }
        });
    }

    private void importAllServicesStrategy(String filter) {
        ImportRegistration ir;
        List<ImportRegistration> irs = this.importedServices.get(filter);
        if (irs == null) {
            irs = new ArrayList<ImportRegistration>();
            this.importedServices.put(filter, irs);
        }
        if (irs.size() > 0) {
            List<EndpointDescription> ips = this.importPossibilities.get(filter);
            Iterator<ImportRegistration> it = irs.iterator();
            while (it.hasNext()) {
                ir = it.next();
                EndpointDescription ep = ir.getImportReference().getImportedEndpoint();
                if ((ips == null || ips.contains(ep)) && ips != null) continue;
                ir.close();
                it.remove();
            }
        }
        for (EndpointDescription epd : this.importPossibilities.get(filter)) {
            if (irs.contains(epd) || (ir = this.importService(epd)) == null) continue;
            irs.add(ir);
        }
    }

    private void importSingleServiceStrategy(String filter) {
        block5: {
            block4: {
                if (!this.importedServices.containsKey(filter) || this.importedServices.get(filter) == null || this.importedServices.get(filter).size() <= 0) break block4;
                List<ImportRegistration> irs = this.importedServices.get(filter);
                List<EndpointDescription> ips = this.importPossibilities.get(filter);
                Iterator<ImportRegistration> it = irs.iterator();
                while (it.hasNext()) {
                    ImportRegistration ir = it.next();
                    EndpointDescription ep = ir.getImportReference().getImportedEndpoint();
                    if ((ips == null || ips.contains(ep)) && ips != null) continue;
                    ir.close();
                    it.remove();
                }
                if (irs.size() != 0 || ips == null || ips.size() <= 0) break block5;
                this.triggerImport(filter);
                break block5;
            }
            if (this.importPossibilities.get(filter).size() > 0) {
                for (EndpointDescription ep : this.importPossibilities.get(filter)) {
                    ImportRegistration ir = this.importService(ep);
                    if (ir == null) continue;
                    List<ImportRegistration> irs = this.importedServices.get(filter);
                    if (irs == null) {
                        irs = new ArrayList<ImportRegistration>(1);
                        this.importedServices.put(filter, irs);
                    }
                    irs.add(ir);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImportRegistration importService(EndpointDescription ep) {
        RemoteServiceAdminList remoteServiceAdminList = this.remoteServiceAdminList;
        synchronized (remoteServiceAdminList) {
            for (RemoteServiceAdmin rsa : this.remoteServiceAdminList) {
                ImportRegistration ir = rsa.importService(ep);
                if (ir == null || ir.getException() != null) continue;
                LOG.fine("service impoort was successful: " + ir);
                return ir;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImportRegistration(ImportRegistration importRegistration) {
        Map<String, List<ImportRegistration>> map = this.importedServices;
        synchronized (map) {
            if (this.importedServices.remove(importRegistration) != null) {
                LOG.fine("removed imported service reference: " + importRegistration);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerExportImportForRemoteSericeAdmin(RemoteServiceAdmin rsa) {
        LOG.fine("New RSA detected trying to import services with it");
        Map<String, List<EndpointDescription>> map = this.importPossibilities;
        synchronized (map) {
            Set<Map.Entry<String, List<EndpointDescription>>> entries = this.importPossibilities.entrySet();
            for (Map.Entry<String, List<EndpointDescription>> entry : entries) {
                this.triggerImport(entry.getKey());
            }
        }
    }

    public void removeImportReference(ImportReference anyObject) {
    }

    private static class ImportInterest {
        String filter;
        int refs;

        public ImportInterest(String filter) {
            this.filter = filter;
            this.refs = 1;
        }

        public int addReference() {
            return ++this.refs;
        }

        public int removeReference() {
            return --this.refs;
        }
    }
}

