/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.helpers;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLHelper {
    public BindingOperation getBindingOperation(Definition def, String operationName) {
        if (operationName == null) {
            return null;
        }
        for (Binding binding : def.getBindings().values()) {
            for (BindingOperation bop : binding.getBindingOperations()) {
                if (!bop.getName().equals(operationName)) continue;
                return bop;
            }
        }
        return null;
    }

    public static String writeQName(Definition def, QName qname2) {
        return def.getPrefix(qname2.getNamespaceURI()) + ":" + qname2.getLocalPart();
    }

    public BindingOperation getBindingOperation(Binding binding, String operationName) {
        if (operationName == null) {
            return null;
        }
        List bindingOperations = binding.getBindingOperations();
        for (BindingOperation bindingOperation : bindingOperations) {
            if (!operationName.equals(bindingOperation.getName())) continue;
            return bindingOperation;
        }
        return null;
    }

    public Map getParts(Operation operation, boolean out) {
        Message message = null;
        if (out) {
            Output output = operation.getOutput();
            message = output.getMessage();
        } else {
            Input input = operation.getInput();
            message = input.getMessage();
        }
        return message.getParts() == null ? new HashMap() : message.getParts();
    }

    public List<PortType> getPortTypes(Definition def) {
        ArrayList<PortType> portTypes = new ArrayList<PortType>();
        for (PortType portType : def.getPortTypes().values()) {
            portTypes.add(portType);
        }
        return portTypes;
    }

    public List<Part> getInMessageParts(Operation operation) {
        Input input = operation.getInput();
        ArrayList<Part> partsList = new ArrayList<Part>();
        if (input != null && input.getMessage() != null) {
            Iterator ite = input.getMessage().getParts().values().iterator();
            while (ite.hasNext()) {
                partsList.add((Part)ite.next());
            }
        }
        return partsList;
    }

    public List<Part> getOutMessageParts(Operation operation) {
        Output output = operation.getOutput();
        ArrayList<Part> partsList = new ArrayList<Part>();
        if (output != null && output.getMessage() != null) {
            Iterator ite = output.getMessage().getParts().values().iterator();
            while (ite.hasNext()) {
                partsList.add((Part)ite.next());
            }
        }
        return partsList;
    }

    public Binding getBinding(BindingOperation bop, Definition def) {
        for (Binding binding : def.getBindings().values()) {
            for (BindingOperation bindingOperation : binding.getBindingOperations()) {
                if (!bindingOperation.getName().equals(bop.getName())) continue;
                return binding;
            }
        }
        return null;
    }

    public Definition getDefinition(File wsdlFile) throws Exception {
        WSDLFactory wsdlFactory = WSDLFactory.newInstance();
        WSDLReader reader = wsdlFactory.newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        return reader.readWSDL(wsdlFile.toURI().toURL().toString());
    }
}

