/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor.transform;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.staxutils.transform.TransformUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private List<String> inDropElements;
    private Map<String, String> inElementsMap;
    private Map<String, String> inAppendMap;
    private boolean blockOriginalReader = true;
    private String contextPropertyName;

    public TransformInInterceptor() {
        super("post-stream");
        this.addBefore(StaxInInterceptor.class.getName());
    }

    @Override
    public void handleMessage(Message message) {
        InputStream is;
        if (this.contextPropertyName != null && !MessageUtils.getContextualBoolean(message, this.contextPropertyName, false)) {
            return;
        }
        XMLStreamReader reader = message.getContent(XMLStreamReader.class);
        XMLStreamReader transformReader = this.createTransformReaderIfNeeded(reader, is = message.getContent(InputStream.class));
        if (transformReader != null) {
            message.setContent(XMLStreamReader.class, transformReader);
            message.removeContent(InputStream.class);
        }
    }

    protected XMLStreamReader createTransformReaderIfNeeded(XMLStreamReader reader, InputStream is) {
        return TransformUtils.createTransformReaderIfNeeded(reader, is, this.inDropElements, this.inElementsMap, this.inAppendMap, this.blockOriginalReader);
    }

    public void setInAppendElements(Map<String, String> inElements) {
        this.inAppendMap = inElements;
    }

    public void setInDropElements(List<String> dropElementsSet) {
        this.inDropElements = dropElementsSet;
    }

    public void setInTransformElements(Map<String, String> inElements) {
        this.inElementsMap = inElements;
    }

    public void setBlockOriginalReader(boolean blockOriginalReader) {
        this.blockOriginalReader = blockOriginalReader;
    }

    public void setContextPropertyName(String propertyName) {
        this.contextPropertyName = propertyName;
    }
}

