/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.javascript;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.javascript.JavascriptOptionsFeature;
import org.apache.cxf.javascript.NameManager;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;

public class BasicNameManager
implements NameManager {
    private Map<String, String> nsPrefixMap;

    BasicNameManager() {
    }

    public static BasicNameManager newNameManager(ServiceInfo service) {
        BasicNameManager nameManager = new BasicNameManager();
        nameManager.initialize(service, null);
        return nameManager;
    }

    public static BasicNameManager newNameManager(ServiceInfo service, Endpoint endpoint) {
        BasicNameManager nameManager = new BasicNameManager();
        nameManager.initialize(service, endpoint);
        return nameManager;
    }

    private void initialize(ServiceInfo service, Endpoint endpoint) {
        JavascriptOptionsFeature options;
        this.nsPrefixMap = new HashMap<String, String>();
        if (endpoint != null && (options = this.getOptions(endpoint)).getNamespacePrefixMap() != null) {
            this.nsPrefixMap.putAll(options.getNamespacePrefixMap());
        }
        HashSet<String> poorPrefixURIs = new HashSet<String>();
        for (SchemaInfo schemaInfo : service.getSchemas()) {
            NamespacePrefixList schemaPrefixList = schemaInfo.getSchema().getNamespaceContext();
            for (String declaredPrefix : schemaPrefixList.getDeclaredPrefixes()) {
                String uri = schemaPrefixList.getNamespaceURI(declaredPrefix);
                if (this.nsPrefixMap.containsKey(uri)) continue;
                if (declaredPrefix.startsWith("ns") || "tns".equals(declaredPrefix)) {
                    poorPrefixURIs.add(uri);
                    continue;
                }
                this.nsPrefixMap.put(uri, declaredPrefix.toUpperCase());
            }
        }
        for (String uri : poorPrefixURIs) {
            this.defineFallbackPrefix(uri);
        }
    }

    private JavascriptOptionsFeature getOptions(Endpoint endpoint) {
        if (endpoint != null) {
            for (AbstractFeature feature : endpoint.getActiveFeatures()) {
                if (!(feature instanceof JavascriptOptionsFeature)) continue;
                return (JavascriptOptionsFeature)feature;
            }
        }
        return new JavascriptOptionsFeature();
    }

    protected String transformURI(String uri) {
        return uri.replaceAll("http:/*", "").replace("uri:", "").replaceAll("[\\.:/-]", "_");
    }

    private String defineFallbackPrefix(String uri) {
        String jsPrefix = this.transformURI(uri);
        this.nsPrefixMap.put(uri, jsPrefix);
        return jsPrefix;
    }

    public String getJavascriptName(XmlSchemaComplexType schemaType) {
        QName typeQName = schemaType.getQName();
        return this.getJavascriptName(typeQName);
    }

    public String getJavascriptName(QName qname2) {
        String nsprefix = this.nsPrefixMap.get(qname2.getNamespaceURI());
        if (nsprefix == null) {
            nsprefix = this.defineFallbackPrefix(qname2.getNamespaceURI());
        }
        return nsprefix + "_" + qname2.getLocalPart();
    }
}

