/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.javascript;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.common.xmlschema.XmlSchemaConstants;
import org.apache.cxf.common.xmlschema.XmlSchemaUtils;
import org.apache.cxf.databinding.source.mime.MimeAttribute;
import org.apache.cxf.javascript.ParticleInfo;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaSimpleContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentExtension;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.w3c.dom.Attr;

public class JavascriptUtils {
    private static final String NL = "\n";
    private static int anyTypePrefixCounter;
    private StringBuilder code;
    private Stack<String> prefixStack;
    private String xmlStringAccumulatorVariable;
    private Map<String, String> defaultValueForSimpleType;
    private Set<String> nonStringSimpleTypes;
    private Set<String> intTypes;
    private Set<String> floatTypes;

    public JavascriptUtils(StringBuilder code) {
        this.code = code;
        this.defaultValueForSimpleType = new HashMap<String, String>();
        this.defaultValueForSimpleType.put("int", "0");
        this.defaultValueForSimpleType.put("unsignedInt", "0");
        this.defaultValueForSimpleType.put("long", "0");
        this.defaultValueForSimpleType.put("unsignedLong", "0");
        this.defaultValueForSimpleType.put("float", "0.0");
        this.defaultValueForSimpleType.put("double", "0.0");
        this.nonStringSimpleTypes = new HashSet<String>();
        this.nonStringSimpleTypes.add("int");
        this.nonStringSimpleTypes.add("long");
        this.nonStringSimpleTypes.add("unsignedInt");
        this.nonStringSimpleTypes.add("unsignedLong");
        this.nonStringSimpleTypes.add("float");
        this.nonStringSimpleTypes.add("double");
        this.intTypes = new HashSet<String>();
        this.intTypes.add("int");
        this.intTypes.add("long");
        this.intTypes.add("unsignedInt");
        this.intTypes.add("unsignedLong");
        this.floatTypes = new HashSet<String>();
        this.floatTypes.add("float");
        this.floatTypes.add("double");
        this.prefixStack = new Stack();
        this.prefixStack.push("    ");
    }

    public String getDefaultValueForSimpleType(XmlSchemaType type) {
        String val = this.defaultValueForSimpleType.get(type.getName());
        if (val == null) {
            return "''";
        }
        return val;
    }

    public boolean isStringSimpleType(QName typeName) {
        return !"http://www.w3.org/2001/XMLSchema".equals(typeName.getNamespaceURI()) || !this.nonStringSimpleTypes.contains(typeName.getLocalPart());
    }

    public void setXmlStringAccumulator(String variableName) {
        this.xmlStringAccumulatorVariable = variableName;
    }

    public void startXmlStringAccumulator(String variableName) {
        this.xmlStringAccumulatorVariable = variableName;
        this.code.append(this.prefix());
        this.code.append("var ");
        this.code.append(variableName);
        this.code.append(" = '';\n");
    }

    public static String protectSingleQuotes(String value) {
        return value.replaceAll("'", "\\'");
    }

    public String escapeStringQuotes(String data) {
        return data.replace("'", "\\'");
    }

    public void appendString(String value) {
        this.code.append(this.prefix());
        this.code.append(this.xmlStringAccumulatorVariable + " = " + this.xmlStringAccumulatorVariable + " + '");
        this.code.append(this.escapeStringQuotes(value));
        this.code.append("';\n");
    }

    public void appendExpression(String value) {
        this.code.append(this.prefix());
        this.code.append(this.xmlStringAccumulatorVariable + " = " + this.xmlStringAccumulatorVariable + " + ");
        this.code.append(value);
        this.code.append(";\n");
    }

    private String prefix() {
        return this.prefixStack.peek();
    }

    public void appendLine(String line) {
        this.code.append(this.prefix());
        this.code.append(line);
        this.code.append(NL);
    }

    public void startIf(String test) {
        this.code.append(this.prefix());
        this.code.append("if (" + test + ") {" + NL);
        this.prefixStack.push(this.prefix() + " ");
    }

    public void startBlock() {
        this.code.append(this.prefix());
        this.code.append("{\n");
        this.prefixStack.push(this.prefix() + " ");
    }

    public void appendElse() {
        this.prefixStack.pop();
        this.code.append(this.prefix());
        this.code.append("} else {\n");
        this.prefixStack.push(this.prefix() + " ");
    }

    public void endBlock() {
        this.prefixStack.pop();
        this.code.append(this.prefix());
        this.code.append("}\n");
    }

    public void startFor(String start, String test, String increment) {
        this.code.append(this.prefix());
        this.code.append("for (" + start + ";" + test + ";" + increment + ") {" + NL);
        this.prefixStack.push(this.prefix() + " ");
    }

    public void startForIn(String var, String collection) {
        this.code.append(this.prefix());
        this.code.append("for (var " + var + " in " + collection + ") {" + NL);
        this.prefixStack.push(this.prefix() + " ");
    }

    public void startWhile(String test) {
        this.code.append(this.prefix());
        this.code.append("while (" + test + ") {" + NL);
        this.prefixStack.push(this.prefix() + " ");
    }

    public void startDo() {
        this.code.append(this.prefix());
        this.code.append("do  {\n");
        this.prefixStack.push(this.prefix() + " ");
    }

    public String javascriptParseExpression(XmlSchemaType type, String value) {
        if (!(type instanceof XmlSchemaSimpleType)) {
            return value;
        }
        String name = type.getName();
        if (this.intTypes.contains(name)) {
            return "parseInt(" + value + ")";
        }
        if (this.floatTypes.contains(name)) {
            return "parseFloat(" + value + ")";
        }
        if ("boolean".equals(name)) {
            return "(" + value + " == 'true')";
        }
        return value;
    }

    public static String javaScriptNameToken(String token) {
        return token;
    }

    private boolean treatAsMtom(XmlSchemaObject schemaObject) {
        Map attribMap;
        Attr ctAttr;
        if (schemaObject == null) {
            return false;
        }
        Map<Object, Object> metaInfoMap = schemaObject.getMetaInfoMap();
        if (metaInfoMap != null && (ctAttr = (Attr)(attribMap = (Map)metaInfoMap.get("EXTERNAL_ATTRIBUTES")).get(MimeAttribute.MIME_QNAME)) != null) {
            return true;
        }
        if (schemaObject instanceof XmlSchemaElement) {
            XmlSchemaElement element = (XmlSchemaElement)schemaObject;
            if (element.getSchemaType() == null) {
                return false;
            }
            QName typeName = element.getSchemaType().getQName();
            if (new QName("http://www.w3.org/2005/05/xmlmime", "base64Binary").equals(typeName)) {
                return true;
            }
        }
        return false;
    }

    public static boolean notVeryComplexType(XmlSchemaType type) {
        return type instanceof XmlSchemaSimpleType || type instanceof XmlSchemaComplexType && ((XmlSchemaComplexType)type).getContentModel() instanceof XmlSchemaSimpleContent;
    }

    public static boolean mtomCandidateType(XmlSchemaType type) {
        XmlSchemaSimpleContentExtension extension;
        XmlSchemaSimpleContent content;
        XmlSchemaComplexType complexType2;
        if (type == null) {
            return false;
        }
        if (XmlSchemaConstants.BASE64BINARY_QNAME.equals(type.getQName())) {
            return true;
        }
        return type instanceof XmlSchemaComplexType && (complexType2 = (XmlSchemaComplexType)type).getContentModel() instanceof XmlSchemaSimpleContent && (content = (XmlSchemaSimpleContent)complexType2.getContentModel()).getContent() instanceof XmlSchemaSimpleContentExtension && XmlSchemaConstants.BASE64BINARY_QNAME.equals((extension = (XmlSchemaSimpleContentExtension)content.getContent()).getBaseTypeName());
    }

    public void generateCodeToSerializeElement(ParticleInfo elementInfo, String referencePrefix, SchemaCollection schemaCollection) {
        XmlSchemaType type = elementInfo.getType();
        boolean nillable = elementInfo.isNillable();
        boolean optional = elementInfo.isOptional();
        boolean array = elementInfo.isArray();
        boolean mtom = this.treatAsMtom(elementInfo.getParticle());
        String jsVar = referencePrefix + elementInfo.getJavascriptName();
        this.appendLine("// block for local variables");
        this.startBlock();
        if (optional) {
            this.startIf(jsVar + " != null");
        }
        if (nillable && !array) {
            this.startIf(jsVar + " == null");
            this.appendString("<" + elementInfo.getXmlName() + " " + "xsi:nil='true'" + "/>");
            this.appendElse();
        }
        if (array) {
            this.startIf(jsVar + " != null");
            this.startFor("var ax = 0", "ax < " + jsVar + ".length", "ax ++");
            jsVar = jsVar + "[ax]";
            this.startIf(jsVar + " == null");
            if (nillable) {
                this.appendString("<" + elementInfo.getXmlName() + " " + "xsi:nil='true'" + "/>");
            } else {
                this.appendString("<" + elementInfo.getXmlName() + "/>");
            }
            this.appendElse();
        }
        if (elementInfo.isAnyType()) {
            this.serializeAnyTypeElement(elementInfo, jsVar);
        } else if (!mtom && type instanceof XmlSchemaComplexType) {
            this.appendExpression(jsVar + ".serialize(cxfjsutils, '" + elementInfo.getXmlName() + "', null)");
        } else {
            this.appendString("<" + elementInfo.getXmlName() + ">");
            if (mtom) {
                this.appendExpression("cxfjsutils.packageMtom(" + jsVar + ")");
            } else {
                this.appendExpression("cxfjsutils.escapeXmlEntities(" + jsVar + ")");
            }
            this.appendString("</" + elementInfo.getXmlName() + ">");
        }
        if (array) {
            this.endBlock();
            this.endBlock();
            this.endBlock();
        }
        if (nillable && !array) {
            this.endBlock();
        }
        if (optional) {
            this.endBlock();
        }
        this.endBlock();
    }

    private void serializeAnyTypeElement(ParticleInfo elementInfo, String jsVar) {
        this.appendLine("var anyHolder = " + jsVar + ";");
        this.appendLine("var anySerializer;");
        this.appendLine("var typeAttr = '';");
        this.startIf("anyHolder != null");
        this.startIf("!anyHolder.raw");
        this.appendLine("anySerializer = cxfjsutils.interfaceObject.globalElementSerializers[anyHolder.qname];");
        this.endBlock();
        this.startIf("anyHolder.xsiType");
        this.appendLine("var typePrefix = 'cxfjst" + anyTypePrefixCounter + "';");
        ++anyTypePrefixCounter;
        this.appendLine("var typeAttr = 'xmlns:' + typePrefix + '=\\'' + anyHolder.namespaceURI + '\\'';");
        this.appendLine("typeAttr = typeAttr + ' xsi:type=\\'' + typePrefix + ':' + anyHolder.localName + '\\'';");
        this.endBlock();
        this.startIf("anySerializer");
        this.appendExpression(jsVar + ".serialize(cxfjsutils, '" + elementInfo.getXmlName() + "', typeAttr)");
        this.appendElse();
        this.appendExpression("'<" + elementInfo.getXmlName() + " ' + typeAttr + " + "'>'");
        this.startIf("!anyHolder.raw");
        this.appendExpression("cxfjsutils.escapeXmlEntities(" + jsVar + ")");
        this.appendElse();
        this.appendExpression("anyHolder.xml");
        this.endBlock();
        this.appendString("</" + elementInfo.getXmlName() + ">");
        this.endBlock();
        this.appendElse();
        this.appendString("<" + elementInfo.getXmlName() + " " + "xsi:nil='true'" + "/>");
        this.endBlock();
    }

    public void generateCodeToSerializeAny(ParticleInfo itemInfo, String prefix, SchemaCollection schemaCollection) {
        boolean optional = XmlSchemaUtils.isParticleOptional(itemInfo.getParticle());
        boolean array = XmlSchemaUtils.isParticleArray(itemInfo.getParticle());
        this.appendLine("var anyHolder = this._" + itemInfo.getJavascriptName() + ";");
        this.appendLine("var anySerializer = null;");
        this.appendLine("var anyXmlTag = null;");
        this.appendLine("var anyXmlNsDef = null;");
        this.appendLine("var anyData = null;");
        this.appendLine("var anyStartTag;");
        this.startIf("anyHolder != null && !anyHolder.raw");
        this.appendLine("anySerializer = cxfjsutils.interfaceObject.globalElementSerializers[anyHolder.qname];");
        this.appendLine("anyXmlTag = '" + prefix + ":' + anyHolder.localName;");
        this.appendLine("anyXmlNsDef = 'xmlns:" + prefix + "=\\'' + anyHolder.namespaceURI" + " + '\\'';");
        this.appendLine("anyStartTag = '<' + anyXmlTag + ' ' + anyXmlNsDef + '>';");
        this.appendLine("anyEndTag = '</' + anyXmlTag + '>';");
        this.appendLine("anyEmptyTag = '<' + anyXmlTag + ' ' + anyXmlNsDef + '/>';");
        this.appendLine("anyData = anyHolder.object;");
        this.endBlock();
        this.startIf("anyHolder != null && anyHolder.raw");
        this.appendExpression("anyHolder.xml");
        this.appendElse();
        if (optional) {
            this.startIf("anyHolder != null && anyData != null");
        } else {
            this.startIf("anyHolder == null || anyData == null");
            this.appendLine("throw 'null value for required any item';");
            this.endBlock();
        }
        String varRef = "anyData";
        if (array) {
            this.startFor("var ax = 0", "ax < anyData.length", "ax ++");
            varRef = "anyData[ax]";
            this.startIf(varRef + " == null");
            this.appendExpression("anyEmptyTag");
            this.appendElse();
        }
        this.startIf("anySerializer");
        this.appendExpression("anySerializer.call(" + varRef + ", cxfjsutils, anyXmlTag, anyXmlNsDef)");
        this.appendElse();
        this.appendExpression("anyStartTag");
        this.appendExpression("cxfjsutils.escapeXmlEntities(" + varRef + ")");
        this.appendExpression("anyEndTag");
        this.endBlock();
        if (array) {
            this.endBlock();
            this.endBlock();
        }
        if (optional) {
            this.endBlock();
        }
        this.endBlock();
    }
}

