/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.javascript.types;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.common.xmlschema.XmlSchemaUtils;
import org.apache.cxf.javascript.AttributeInfo;
import org.apache.cxf.javascript.ItemInfo;
import org.apache.cxf.javascript.JavascriptUtils;
import org.apache.cxf.javascript.NameManager;
import org.apache.cxf.javascript.NamespacePrefixAccumulator;
import org.apache.cxf.javascript.ParticleInfo;
import org.apache.cxf.javascript.UnsupportedConstruct;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaAny;
import org.apache.ws.commons.schema.XmlSchemaAttributeOrGroupRef;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaType;

public class SchemaJavascriptBuilder {
    private static final Logger LOG = LogUtils.getL7dLogger(SchemaJavascriptBuilder.class);
    private static int anyPrefixCounter;
    private SchemaCollection xmlSchemaCollection;
    private NameManager nameManager;
    private NamespacePrefixAccumulator prefixAccumulator;
    private StringBuilder code;
    private StringBuilder accessors;
    private JavascriptUtils utils;
    private XmlSchema xmlSchema;

    public SchemaJavascriptBuilder(SchemaCollection schemaCollection, NamespacePrefixAccumulator prefixAccumulator, NameManager nameManager) {
        this.xmlSchemaCollection = schemaCollection;
        this.nameManager = nameManager;
        this.prefixAccumulator = prefixAccumulator;
    }

    public String generateCodeForSchemaCollection(XmlSchemaCollection collection) {
        StringBuilder accumulatedCode = new StringBuilder();
        for (XmlSchema schema : collection.getXmlSchemas()) {
            if ("http://www.w3.org/2001/XMLSchema".equals(schema.getTargetNamespace())) continue;
            accumulatedCode.append(this.generateCodeForSchema(schema));
        }
        return accumulatedCode.toString();
    }

    public String generateCodeForSchema(XmlSchema schema) {
        this.xmlSchema = schema;
        this.code = new StringBuilder();
        this.code.append("//\n");
        this.code.append("// Definitions for schema: " + schema.getTargetNamespace());
        if (schema.getSourceURI() != null) {
            this.code.append("\n//  " + schema.getSourceURI());
        }
        this.code.append("\n//\n");
        Map<QName, XmlSchemaType> schemaTypes = schema.getSchemaTypes();
        for (Map.Entry<QName, XmlSchemaType> entry : schemaTypes.entrySet()) {
            XmlSchemaSimpleType simpleType2;
            XmlSchemaType type = entry.getValue();
            if (type instanceof XmlSchemaComplexType) {
                try {
                    XmlSchemaComplexType complexType2 = (XmlSchemaComplexType)type;
                    if (JavascriptUtils.notVeryComplexType(complexType2) || complexType2.getName() == null) continue;
                    this.complexTypeConstructorAndAccessors(complexType2.getQName(), complexType2);
                    this.complexTypeSerializerFunction(complexType2.getQName(), complexType2);
                    this.domDeserializerFunction(complexType2.getQName(), complexType2);
                }
                catch (UnsupportedConstruct usc) {
                    LOG.warning(usc.toString());
                }
                continue;
            }
            if (!(type instanceof XmlSchemaSimpleType) || !XmlSchemaUtils.isEumeration(simpleType2 = (XmlSchemaSimpleType)type)) continue;
            List<String> values = XmlSchemaUtils.enumeratorValues(simpleType2);
            this.code.append("//\n");
            this.code.append("// Simple type (enumeration) " + simpleType2.getQName() + "\n");
            this.code.append("//\n");
            for (String value : values) {
                this.code.append("// - " + value + "\n");
            }
        }
        for (Map.Entry<QName, XmlSchemaAnnotated> entry : schema.getElements().entrySet()) {
            XmlSchemaElement element = (XmlSchemaElement)entry.getValue();
            try {
                XmlSchemaComplexType complexType3;
                if (element.getSchemaTypeName() == null && element.getSchemaType() == null) {
                    Message message = new Message("ELEMENT_MISSING_TYPE", LOG, element.getQName(), element.getSchemaTypeName(), schema.getTargetNamespace());
                    LOG.warning(message.toString());
                    continue;
                }
                XmlSchemaType type = element.getSchemaType() != null ? element.getSchemaType() : schema.getTypeByName(element.getSchemaTypeName());
                if (!(type instanceof XmlSchemaComplexType) || JavascriptUtils.notVeryComplexType(complexType3 = (XmlSchemaComplexType)type) || complexType3.getName() != null) continue;
                this.complexTypeConstructorAndAccessors(element.getQName(), complexType3);
                this.complexTypeSerializerFunction(element.getQName(), complexType3);
                this.domDeserializerFunction(element.getQName(), complexType3);
            }
            catch (UnsupportedConstruct usc) {}
        }
        String returnValue = this.code.toString();
        LOG.finer(returnValue);
        return returnValue;
    }

    public void complexTypeConstructorAndAccessors(QName name, XmlSchemaComplexType type) {
        ItemInfo itemInfo;
        this.accessors = new StringBuilder();
        this.utils = new JavascriptUtils(this.code);
        List<XmlSchemaObject> items = XmlSchemaUtils.getContentElements(type, this.xmlSchemaCollection);
        List<XmlSchemaAnnotated> attrs = XmlSchemaUtils.getContentAttributes(type, this.xmlSchemaCollection);
        String elementPrefix = "this._";
        String typeObjectName = this.nameManager.getJavascriptName(name);
        this.code.append("//\n");
        this.code.append("// Constructor for XML Schema item " + name.toString() + "\n");
        this.code.append("//\n");
        this.code.append("function " + typeObjectName + " () {\n");
        this.utils.appendLine("this.typeMarker = '" + typeObjectName + "';");
        for (XmlSchemaObject xmlSchemaObject : items) {
            itemInfo = ParticleInfo.forLocalItem(xmlSchemaObject, this.xmlSchema, this.xmlSchemaCollection, this.prefixAccumulator, type.getQName());
            this.constructOneItem(type, "this._", typeObjectName, itemInfo);
        }
        for (XmlSchemaAnnotated xmlSchemaAnnotated : attrs) {
            itemInfo = AttributeInfo.forLocalItem(xmlSchemaAnnotated, this.xmlSchema, this.xmlSchemaCollection, this.prefixAccumulator, type.getQName());
            this.constructOneItem(type, "this._", typeObjectName, itemInfo);
        }
        this.code.append("}\n\n");
        this.code.append(this.accessors.toString());
    }

    private void constructOneItem(XmlSchemaComplexType type, String elementPrefix, String typeObjectName, ItemInfo itemInfo) {
        String accessorSuffix = StringUtils.capitalize(itemInfo.getJavascriptName());
        String accessorName = typeObjectName + "_get" + accessorSuffix;
        String getFunctionProperty = typeObjectName + ".prototype.get" + accessorSuffix;
        String setFunctionProperty = typeObjectName + ".prototype.set" + accessorSuffix;
        this.accessors.append("//\n");
        this.accessors.append("// accessor is " + getFunctionProperty + "\n");
        this.accessors.append("// element get for " + itemInfo.getJavascriptName() + "\n");
        if (itemInfo.isAny()) {
            this.accessors.append("// - xs:any\n");
        } else if (itemInfo.getType() != null) {
            this.accessors.append("// - element type is " + itemInfo.getType().getQName() + "\n");
        }
        if (itemInfo.isOptional()) {
            this.accessors.append("// - optional element\n");
        } else {
            this.accessors.append("// - required element\n");
        }
        if (itemInfo.isArray()) {
            this.accessors.append("// - array\n");
        }
        if (itemInfo.isNillable()) {
            this.accessors.append("// - nillable\n");
        }
        this.accessors.append("//\n");
        this.accessors.append("// element set for " + itemInfo.getJavascriptName() + "\n");
        this.accessors.append("// setter function is is " + setFunctionProperty + "\n");
        this.accessors.append("//\n");
        this.accessors.append("function " + accessorName + "() { return this._" + itemInfo.getJavascriptName() + ";}\n\n");
        this.accessors.append(getFunctionProperty + " = " + accessorName + ";\n\n");
        accessorName = typeObjectName + "_set" + accessorSuffix;
        this.accessors.append("function " + accessorName + "(value) { this._" + itemInfo.getJavascriptName() + " = value;}\n\n");
        this.accessors.append(setFunctionProperty + " = " + accessorName + ";\n");
        if (itemInfo.isOptional() || itemInfo.isNillable() && !itemInfo.isArray()) {
            this.utils.appendLine("this._" + itemInfo.getJavascriptName() + " = null;");
        } else if (itemInfo.isArray()) {
            this.utils.appendLine("this._" + itemInfo.getJavascriptName() + " = [];");
        } else if (itemInfo.isAny() || itemInfo.getType() instanceof XmlSchemaComplexType) {
            this.utils.appendLine("this._" + itemInfo.getJavascriptName() + " = null;");
        } else {
            if (itemInfo.getDefaultValue() == null) {
                itemInfo.setDefaultValue(this.utils.getDefaultValueForSimpleType(itemInfo.getType()));
            }
            this.utils.appendLine("this._" + itemInfo.getJavascriptName() + " = " + itemInfo.getDefaultValue() + ";");
        }
    }

    public void complexTypeSerializerFunction(QName name, XmlSchemaComplexType type) {
        StringBuilder bodyCode = new StringBuilder();
        JavascriptUtils bodyUtils = new JavascriptUtils(bodyCode);
        bodyUtils.setXmlStringAccumulator("xml");
        this.complexTypeSerializerBody(type, "this._", bodyUtils);
        this.utils = new JavascriptUtils(this.code);
        String functionName = this.nameManager.getJavascriptName(name) + "_" + "serialize";
        this.code.append("//\n");
        this.code.append("// Serialize " + name + "\n");
        this.code.append("//\n");
        this.code.append("function " + functionName + "(cxfjsutils, elementName, extraNamespaces) {\n");
        this.utils.startXmlStringAccumulator("xml");
        this.utils.startIf("elementName != null");
        this.utils.appendString("<");
        this.utils.appendExpression("elementName");
        String moreNamespaces = this.prefixAccumulator.getAttributes();
        if (moreNamespaces.length() > 0) {
            this.utils.appendString(" ");
            this.utils.appendString(moreNamespaces);
        }
        this.utils.startIf("extraNamespaces");
        this.utils.appendExpression("' ' + extraNamespaces");
        this.utils.endBlock();
        this.complexTypeSerializeAttributes(type, "this._");
        this.utils.appendString(">");
        this.utils.endBlock();
        this.code.append((CharSequence)bodyCode);
        this.utils.startIf("elementName != null");
        this.utils.appendString("</");
        this.utils.appendExpression("elementName");
        this.utils.appendString(">");
        this.utils.endBlock();
        this.utils.appendLine("return xml;");
        this.code.append("}\n\n");
        this.code.append(this.nameManager.getJavascriptName(name) + ".prototype.serialize = " + functionName + ";\n\n");
    }

    private void complexTypeSerializeAttributes(XmlSchemaComplexType type, String string) {
        List<XmlSchemaAttributeOrGroupRef> attributes = type.getAttributes();
    }

    protected void complexTypeSerializerBody(XmlSchemaComplexType type, String elementPrefix, JavascriptUtils bodyUtils) {
        List<XmlSchemaObject> items = XmlSchemaUtils.getContentElements(type, this.xmlSchemaCollection);
        for (XmlSchemaObject sequenceItem : items) {
            ParticleInfo itemInfo = ParticleInfo.forLocalItem(sequenceItem, this.xmlSchema, this.xmlSchemaCollection, this.prefixAccumulator, type.getQName());
            if (itemInfo.isAny()) {
                this.serializeAny(itemInfo, bodyUtils);
                continue;
            }
            bodyUtils.generateCodeToSerializeElement(itemInfo, "this._", this.xmlSchemaCollection);
        }
    }

    private void serializeAny(ParticleInfo itemInfo, JavascriptUtils bodyUtils) {
        String prefix = "cxfjsany" + anyPrefixCounter;
        ++anyPrefixCounter;
        bodyUtils.generateCodeToSerializeAny(itemInfo, prefix, this.xmlSchemaCollection);
    }

    public void domDeserializerFunction(QName name, XmlSchemaComplexType type) {
        this.utils = new JavascriptUtils(this.code);
        List<XmlSchemaObject> contentElements = XmlSchemaUtils.getContentElements(type, this.xmlSchemaCollection);
        String typeObjectName = this.nameManager.getJavascriptName(name);
        this.code.append("function " + typeObjectName + "_deserialize (cxfjsutils, element) {\n");
        this.utils.appendLine("var newobject = new " + typeObjectName + "();");
        this.utils.appendLine("cxfjsutils.trace('element: ' + cxfjsutils.traceElementName(element));");
        this.utils.appendLine("var curElement = cxfjsutils.getFirstElementChild(element);");
        this.utils.appendLine("var item;");
        int nContentElements = contentElements.size();
        for (int i = 0; i < contentElements.size(); ++i) {
            XmlSchemaObject contentElement = contentElements.get(i);
            this.utils.appendLine("cxfjsutils.trace('curElement: ' + cxfjsutils.traceElementName(curElement));");
            ParticleInfo itemInfo = ParticleInfo.forLocalItem(contentElement, this.xmlSchema, this.xmlSchemaCollection, this.prefixAccumulator, type.getQName());
            if (itemInfo.isAny()) {
                XmlSchemaObject nextThing;
                ParticleInfo nextItem = null;
                if (i != nContentElements - 1 && (nextItem = ParticleInfo.forLocalItem(nextThing = contentElements.get(i + 1), this.xmlSchema, this.xmlSchemaCollection, this.prefixAccumulator, type.getQName())).isAny()) {
                    this.unsupportedConstruct("MULTIPLE_ANY", type.getQName());
                }
                this.deserializeAny(type, itemInfo, nextItem);
                continue;
            }
            this.deserializeElement(type, contentElement);
        }
        this.utils.appendLine("return newobject;");
        this.code.append("}\n\n");
    }

    private String buildNamespaceList(String anyNamespaceSpec) {
        StringBuilder nslist = new StringBuilder();
        String[] namespaces = anyNamespaceSpec.split("\\s");
        nslist.append("[ ");
        for (int x = 0; x < namespaces.length; ++x) {
            String ns = namespaces[x];
            nslist.append("'");
            if ("##targetNamespace".equals(ns)) {
                nslist.append(this.xmlSchema.getTargetNamespace());
            } else if (!"##local".equals(ns)) {
                nslist.append(ns);
            }
            nslist.append("'");
            if (x >= namespaces.length - 1) continue;
            nslist.append(",");
        }
        nslist.append("]");
        return nslist.toString();
    }

    private void deserializeAny(XmlSchemaComplexType type, ParticleInfo itemInfo, ParticleInfo nextItem) {
        String matchType;
        XmlSchemaAny any = (XmlSchemaAny)itemInfo.getParticle();
        boolean array = XmlSchemaUtils.isParticleArray(any);
        boolean optional = XmlSchemaUtils.isParticleOptional(any);
        if (array) {
            this.utils.appendLine("var anyObject = [];");
        } else {
            this.utils.appendLine("var anyObject = null;");
        }
        String anyNamespaceSpec = any.getNamespace();
        XmlSchemaElement nextElement = null;
        if (nextItem != null) {
            nextElement = (XmlSchemaElement)nextItem.getParticle();
        }
        String namespaceList = "[]";
        if (anyNamespaceSpec == null || "##any".equals(anyNamespaceSpec) || "".equals(anyNamespaceSpec)) {
            matchType = "org_apache_cxf_any_ns_matcher.ANY";
        } else if ("##other".equals(anyNamespaceSpec)) {
            matchType = "org_apache_cxf_any_ns_matcher.OTHER";
        } else if ("##local".equals(anyNamespaceSpec)) {
            matchType = "org_apache_cxf_any_ns_matcher.LOCAL";
        } else {
            matchType = "org_apache_cxf_any_ns_matcher.LISTED";
            namespaceList = this.buildNamespaceList(anyNamespaceSpec);
        }
        String nextLocalPartConstant = "null";
        if (nextElement != null) {
            nextLocalPartConstant = "'" + nextElement.getQName().getLocalPart() + "'";
        }
        this.utils.appendLine("var matcher = new org_apache_cxf_any_ns_matcher(" + matchType + ", '" + this.xmlSchema.getTargetNamespace() + "'" + ", " + namespaceList + ", " + nextLocalPartConstant + ");");
        if (array) {
            this.utils.appendLine("var anyNeeded = " + any.getMinOccurs() + ";");
            this.utils.appendLine("var anyAllowed = " + any.getMaxOccurs() + ";");
        } else if (optional) {
            this.utils.appendLine("var anyNeeded = 0;");
            this.utils.appendLine("var anyAllowed = 1;");
        } else {
            this.utils.appendLine("var anyNeeded = 1;");
            this.utils.appendLine("var anyAllowed = 1;");
        }
        this.utils.startWhile("anyNeeded > 0 || anyAllowed > 0");
        this.utils.appendLine("var anyURI;");
        this.utils.appendLine("var anyLocalPart;");
        this.utils.appendLine("var anyMatched = false;");
        this.utils.startIf("curElement");
        this.utils.appendLine("anyURI = cxfjsutils.getElementNamespaceURI(curElement);");
        this.utils.appendLine("anyLocalPart = cxfjsutils.getNodeLocalName(curElement);");
        this.utils.appendLine("var anyQName = '{' + anyURI + '}' + anyLocalPart;");
        this.utils.appendLine("cxfjsutils.trace('any match: ' + anyQName);");
        this.utils.appendLine("anyMatched = matcher.match(anyURI, anyLocalPart)");
        this.utils.appendLine("cxfjsutils.trace(' --> ' + anyMatched);");
        this.utils.endBlock();
        this.utils.startIf("anyMatched");
        this.utils.appendLine("anyDeserializer = cxfjsutils.interfaceObject.globalElementDeserializers[anyQName];");
        this.utils.appendLine("cxfjsutils.trace(' deserializer: ' + anyDeserializer);");
        this.utils.startIf("anyDeserializer");
        this.utils.appendLine("var anyValue = anyDeserializer(cxfjsutils, curElement);");
        this.utils.appendElse();
        this.utils.appendLine("var anyValue = curElement.nodeValue;");
        this.utils.endBlock();
        if (array) {
            this.utils.appendLine("anyObject.push(anyValue);");
        } else {
            this.utils.appendLine("anyObject = anyValue;");
        }
        this.utils.appendLine("anyNeeded--;");
        this.utils.appendLine("anyAllowed--;");
        this.utils.appendLine("curElement = cxfjsutils.getNextElementSibling(curElement);");
        this.utils.appendElse();
        this.utils.startIf("anyNeeded > 0");
        this.utils.appendLine("throw 'not enough ws:any elements';");
        this.utils.endBlock();
        this.utils.endBlock();
        this.utils.endBlock();
        this.utils.appendLine("var anyHolder = new org_apache_cxf_any_holder(anyURI, anyLocalPart, anyValue);");
        this.utils.appendLine("newobject.setAny(anyHolder);");
    }

    private void deserializeElement(XmlSchemaComplexType type, XmlSchemaObject thing) {
        boolean qualified;
        ParticleInfo itemInfo = ParticleInfo.forLocalItem(thing, this.xmlSchema, this.xmlSchemaCollection, this.prefixAccumulator, type.getQName());
        XmlSchemaType itemType = itemInfo.getType();
        boolean simple = itemType instanceof XmlSchemaSimpleType || JavascriptUtils.notVeryComplexType(itemType);
        boolean mtomCandidate = JavascriptUtils.mtomCandidateType(itemType);
        String accessorName = "set" + StringUtils.capitalize(itemInfo.getJavascriptName());
        this.utils.appendLine("cxfjsutils.trace('processing " + itemInfo.getJavascriptName() + "');");
        XmlSchemaElement element = (XmlSchemaElement)itemInfo.getParticle();
        QName elementQName = XmlSchemaUtils.getElementQualifiedName(element, this.xmlSchema);
        String elementNamespaceURI = elementQName.getNamespaceURI();
        boolean elementNoNamespace = "".equals(elementNamespaceURI);
        XmlSchema elementSchema = null;
        if (!elementNoNamespace) {
            elementSchema = this.xmlSchemaCollection.getSchemaByTargetNamespace(elementNamespaceURI);
        }
        boolean bl = qualified = !elementNoNamespace && XmlSchemaUtils.isElementQualified(element, itemInfo.isGlobal(), this.xmlSchema, elementSchema);
        if (!qualified) {
            elementNamespaceURI = "";
        }
        String localName = elementQName.getLocalPart();
        String valueTarget = "item";
        if (itemInfo.isOptional() || itemInfo.isArray()) {
            this.utils.startIf("curElement != null && cxfjsutils.isNodeNamedNS(curElement, '" + elementNamespaceURI + "', '" + localName + "')");
            if (itemInfo.isArray()) {
                this.utils.appendLine("item = [];");
                this.utils.startDo();
                valueTarget = "arrayItem";
                this.utils.appendLine("var arrayItem;");
            }
        }
        this.utils.appendLine("var value = null;");
        this.utils.startIf("!cxfjsutils.isElementNil(curElement)");
        if (itemInfo.isAnyType()) {
            this.utils.appendLine(valueTarget + " = org_apache_cxf_deserialize_anyType(cxfjsutils, curElement);");
        } else if (simple) {
            if (mtomCandidate) {
                this.utils.appendLine(valueTarget + " = cxfjsutils.deserializeBase64orMom(curElement);");
            } else {
                this.utils.appendLine("value = cxfjsutils.getNodeText(curElement);");
                this.utils.appendLine(valueTarget + " = " + this.utils.javascriptParseExpression(itemType, "value") + ";");
            }
        } else {
            XmlSchemaComplexType complexType2 = (XmlSchemaComplexType)itemType;
            QName baseQName = complexType2.getQName();
            if (baseQName == null) {
                baseQName = element.getQName();
            }
            String elTypeJsName = this.nameManager.getJavascriptName(baseQName);
            this.utils.appendLine(valueTarget + " = " + elTypeJsName + "_deserialize(cxfjsutils, curElement);");
        }
        this.utils.endBlock();
        if (itemInfo.isArray()) {
            this.utils.appendLine("item.push(arrayItem);");
            this.utils.appendLine("curElement = cxfjsutils.getNextElementSibling(curElement);");
            this.utils.endBlock();
            this.utils.appendLine("  while(curElement != null && cxfjsutils.isNodeNamedNS(curElement, '" + elementNamespaceURI + "', '" + localName + "'));");
        }
        this.utils.appendLine("newobject." + accessorName + "(item);");
        this.utils.appendLine("var item = null;");
        if (!itemInfo.isArray()) {
            this.utils.startIf("curElement != null");
            this.utils.appendLine("curElement = cxfjsutils.getNextElementSibling(curElement);");
            this.utils.endBlock();
        }
        if (itemInfo.isOptional() || itemInfo.isArray()) {
            this.utils.endBlock();
        }
    }

    private void unsupportedConstruct(String messageKey, Object ... args) {
        Message message = new Message(messageKey, LOG, args);
        throw new UnsupportedConstruct(message);
    }
}

