/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.RuntimeDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaTypeHeaderProvider
implements RuntimeDelegate.HeaderDelegate<MediaType> {
    private static final Pattern COMPLEX_PARAMETERS = Pattern.compile("(([\\w-]+=\"[^\"]*\")|([\\w-]+=[\\w-/]+))");

    @Override
    public MediaType fromString(String mType2) {
        Map<String, String> parameters;
        String subtype;
        String type;
        block7: {
            if (mType2 == null) {
                throw new IllegalArgumentException("Media type value can not be null");
            }
            if (mType2.equals("*") || mType2.startsWith("*;")) {
                return new MediaType("*", "*");
            }
            int i = mType2.indexOf(47);
            if (i == -1) {
                throw new IllegalArgumentException("Media type separator is missing");
            }
            int paramsStart = mType2.indexOf(59, i + 1);
            int end = paramsStart == -1 ? mType2.length() : paramsStart;
            type = mType2.substring(0, i);
            subtype = mType2.substring(i + 1, end);
            parameters = Collections.emptyMap();
            if (paramsStart == -1) break block7;
            parameters = new LinkedHashMap();
            String paramString = mType2.substring(paramsStart + 1);
            if (paramString.contains("\"")) {
                Matcher m = COMPLEX_PARAMETERS.matcher(paramString);
                while (m.find()) {
                    String val = m.group().trim();
                    MediaTypeHeaderProvider.addParameter(parameters, val);
                }
            } else {
                StringTokenizer st = new StringTokenizer(paramString, ";");
                while (st.hasMoreTokens()) {
                    MediaTypeHeaderProvider.addParameter(parameters, st.nextToken());
                }
            }
        }
        return new MediaType(type.trim().toLowerCase(), subtype.trim().toLowerCase(), parameters);
    }

    private static void addParameter(Map<String, String> parameters, String token) {
        int equalSign = token.indexOf(61);
        if (equalSign == -1) {
            throw new IllegalArgumentException("Wrong media type parameter, separator is missing");
        }
        parameters.put(token.substring(0, equalSign).trim().toLowerCase(), token.substring(equalSign + 1).trim());
    }

    @Override
    public String toString(MediaType type) {
        StringBuilder sb = new StringBuilder();
        sb.append(type.getType()).append('/').append(type.getSubtype());
        Map<String, String> params = type.getParameters();
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                sb.append(';').append(entry.getKey()).append('=').append(entry.getValue());
            }
        }
        return sb.toString();
    }
}

