/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jibx.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.jibx.schema.ISchemaResolver;
import org.xml.sax.InputSource;

public class JibxSchemaResolver
implements ISchemaResolver {
    private String id;
    private String name;
    private XmlSchema schema;
    private SchemaCollection collection;

    public JibxSchemaResolver(String id, XmlSchema schema, SchemaCollection collection) {
        this.id = id;
        this.setName(id);
        this.schema = schema;
        this.collection = collection;
    }

    public InputStream getContent() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.schema.write(bos);
        return new ByteArrayInputStream(bos.toByteArray());
    }

    public String getId() {
        return this.id;
    }

    private void setName(String uri) {
        this.name = uri.substring(uri.lastIndexOf(47) + 1);
    }

    public String getName() {
        return this.name;
    }

    public ISchemaResolver resolve(String loc, String tns) throws IOException {
        URIResolver resolver2 = this.collection.getXmlSchemaCollection().getSchemaResolver();
        InputSource source = resolver2.resolveEntity(tns, loc, this.id);
        SchemaCollection schemaCol = new SchemaCollection();
        schemaCol.setSchemaResolver(resolver2);
        XmlSchema read = schemaCol.getXmlSchemaCollection().read(source);
        String uri = loc;
        try {
            URL url = new URL(new URL(this.id), loc);
            uri = url.toURI().toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        return new JibxSchemaResolver(uri, read, schemaCol);
    }
}

