/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.idl;

import antlr.collections.AST;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.wsdl.Alias;
import org.apache.cxf.binding.corba.wsdl.CorbaTypeImpl;
import org.apache.cxf.binding.corba.wsdl.Fixed;
import org.apache.cxf.binding.corba.wsdl.NamedType;
import org.apache.cxf.binding.corba.wsdl.Sequence;
import org.apache.cxf.tools.corba.processors.idl.ArrayVisitor;
import org.apache.cxf.tools.corba.processors.idl.Scope;
import org.apache.cxf.tools.corba.processors.idl.VisitorBase;
import org.apache.cxf.tools.corba.processors.idl.WSDLASTVisitor;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaType;

public class DeclaratorVisitor
extends VisitorBase {
    public DeclaratorVisitor(Scope scope, Definition defn, XmlSchema schemaRef, WSDLASTVisitor wsdlASTVisitor, XmlSchemaType schemaTypeRef, CorbaTypeImpl corbaTypeRef, Scope fQName) {
        super(scope, defn, schemaRef, wsdlASTVisitor);
        this.setSchemaType(schemaTypeRef);
        this.setCorbaType(corbaTypeRef);
        this.setFullyQualifiedName(fQName);
    }

    public void visit(AST node) {
        if (ArrayVisitor.accept(node)) {
            ArrayVisitor arrayVisitor = new ArrayVisitor(this.getScope(), this.definition, this.schema, this.wsdlVisitor, node, this.getFullyQualifiedName());
            arrayVisitor.setSchemaType(this.getSchemaType());
            arrayVisitor.setCorbaType(this.getCorbaType());
            arrayVisitor.visit(node);
        } else {
            this.typeMap.getStructOrExceptionOrUnion().add(this.getCorbaType());
        }
        for (AST nextDecl = node.getNextSibling(); nextDecl != null; nextDecl = nextDecl.getNextSibling()) {
            Scope newScope = new Scope(this.getScope().getParent(), nextDecl);
            if (ArrayVisitor.accept(nextDecl)) {
                ArrayVisitor arrayVisitor = new ArrayVisitor(newScope, this.definition, this.schema, this.wsdlVisitor, nextDecl, this.getFullyQualifiedName());
                arrayVisitor.setSchemaType(this.getSchemaType());
                arrayVisitor.setCorbaType(this.getCorbaType());
                arrayVisitor.visit(nextDecl);
                continue;
            }
            this.visitNewTypes(newScope);
        }
    }

    private void visitNewTypes(Scope newScope) {
        NamedType nextCorbaType = null;
        XmlSchemaType nextSchemaType = null;
        CorbaTypeImpl oldCorbaType = this.getCorbaType();
        QName newQname = new QName(this.getCorbaType().getQName().getNamespaceURI(), newScope.toString());
        if (oldCorbaType instanceof Alias) {
            Alias oldAlias = (Alias)oldCorbaType;
            Alias alias = new Alias();
            alias.setQName(newQname);
            alias.setBasetype(oldAlias.getBasetype());
            alias.setType(oldAlias.getType());
            alias.setRepositoryID(newScope.toIDLRepositoryID());
            nextCorbaType = alias;
        } else if (oldCorbaType instanceof Sequence) {
            nextSchemaType = this.duplicateXmlSchemaComplexType(newScope);
            Sequence oldSequence = (Sequence)oldCorbaType;
            Sequence newSequence = new Sequence();
            newSequence.setQName(newQname);
            newSequence.setType(nextSchemaType.getQName());
            newSequence.setElemtype(oldSequence.getElemtype());
            newSequence.setElemname(oldSequence.getElemname());
            newSequence.setBound(oldSequence.getBound());
            newSequence.setRepositoryID(newScope.toIDLRepositoryID());
            nextCorbaType = newSequence;
        } else if (oldCorbaType instanceof Fixed) {
            nextSchemaType = this.duplicateXmlSchemaSimpleType(newScope);
            Fixed oldFixed = (Fixed)this.getCorbaType();
            Fixed newFixed = new Fixed();
            newFixed.setQName(newQname);
            newFixed.setDigits(oldFixed.getDigits());
            newFixed.setScale(oldFixed.getScale());
            newFixed.setType(oldFixed.getType());
            newFixed.setRepositoryID(newScope.toIDLRepositoryID());
            nextCorbaType = newFixed;
        } else {
            System.err.println("[DeclaratorVisitor: Unexpected CORBA type error!]");
            System.exit(1);
        }
        if (nextCorbaType != null) {
            this.typeMap.getStructOrExceptionOrUnion().add(nextCorbaType);
        }
    }

    private XmlSchemaComplexType duplicateXmlSchemaComplexType(Scope newScope) {
        XmlSchemaComplexType oldSchemaType = (XmlSchemaComplexType)this.getSchemaType();
        XmlSchemaComplexType newSchemaType = new XmlSchemaComplexType(this.schema, true);
        newSchemaType.setName(newScope.toString());
        newSchemaType.setParticle(oldSchemaType.getParticle());
        return newSchemaType;
    }

    private XmlSchemaSimpleType duplicateXmlSchemaSimpleType(Scope newScope) {
        XmlSchemaSimpleType oldSimpleType = (XmlSchemaSimpleType)this.getSchemaType();
        XmlSchemaSimpleType simpleType2 = new XmlSchemaSimpleType(this.schema, oldSimpleType.isTopLevel());
        simpleType2.setContent(oldSimpleType.getContent());
        simpleType2.setName(newScope.toString());
        return simpleType2;
    }
}

