/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.idl;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.List;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.wsdl.Alias;
import org.apache.cxf.binding.corba.wsdl.Anonarray;
import org.apache.cxf.binding.corba.wsdl.Anonsequence;
import org.apache.cxf.binding.corba.wsdl.Array;
import org.apache.cxf.binding.corba.wsdl.CorbaConstants;
import org.apache.cxf.binding.corba.wsdl.CorbaTypeImpl;
import org.apache.cxf.binding.corba.wsdl.Sequence;
import org.apache.cxf.binding.corba.wsdl.TypeMappingType;
import org.apache.cxf.tools.corba.common.XmlSchemaPrimitiveMap;
import org.apache.cxf.tools.corba.processors.idl.ModuleToNSMapper;
import org.apache.cxf.tools.corba.processors.idl.ObjectReferenceVisitor;
import org.apache.cxf.tools.corba.processors.idl.PrimitiveTypesVisitor;
import org.apache.cxf.tools.corba.processors.idl.Scope;
import org.apache.cxf.tools.corba.processors.idl.ScopeNameCollection;
import org.apache.cxf.tools.corba.processors.idl.VisitorBase;
import org.apache.cxf.tools.corba.processors.idl.VisitorTypeHolder;
import org.apache.cxf.tools.corba.processors.idl.WSDLASTVisitor;
import org.apache.cxf.tools.corba.processors.idl.WSDLSchemaManager;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.constants.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopedNameVisitor
extends VisitorBase {
    private static boolean exceptionMode;
    private static XmlSchemaPrimitiveMap xmlSchemaPrimitiveMap;

    public ScopedNameVisitor(Scope scope, Definition defn, XmlSchema schemaRef, WSDLASTVisitor wsdlVisitor) {
        super(scope, defn, schemaRef, wsdlVisitor);
    }

    public void setExceptionMode(boolean value) {
        exceptionMode = value;
    }

    public static boolean accept(Scope scope, Definition defn, XmlSchema schemaRef, AST node, WSDLASTVisitor wsdlVisitor) {
        boolean result = false;
        if (PrimitiveTypesVisitor.accept(node)) {
            result = true;
        } else if (ScopedNameVisitor.isforwardDeclared(scope, node, wsdlVisitor)) {
            result = true;
        } else if (ObjectReferenceVisitor.accept(scope, schemaRef, defn, node, wsdlVisitor)) {
            result = true;
        } else if (ScopedNameVisitor.findSchemaType(scope, defn, schemaRef, node, wsdlVisitor, null)) {
            result = true;
        }
        return result;
    }

    @Override
    public void visit(AST node) {
        XmlSchemaType stype = null;
        CorbaTypeImpl ctype = null;
        if (PrimitiveTypesVisitor.accept(node)) {
            PrimitiveTypesVisitor primitiveVisitor = new PrimitiveTypesVisitor(null, this.definition, this.schema, this.schemas);
            primitiveVisitor.visit(node);
            stype = primitiveVisitor.getSchemaType();
            ctype = primitiveVisitor.getCorbaType();
        } else if (ScopedNameVisitor.isforwardDeclared(this.getScope(), node, this.wsdlVisitor)) {
            Scope scope = ScopedNameVisitor.forwardDeclared(this.getScope(), this.definition, this.schema, node, this.wsdlVisitor);
            this.setFullyQualifiedName(scope);
        } else if (ObjectReferenceVisitor.accept(this.getScope(), this.schema, this.definition, node, this.wsdlVisitor)) {
            ObjectReferenceVisitor objRefVisitor = new ObjectReferenceVisitor(this.getScope(), this.definition, this.schema, this.wsdlVisitor);
            objRefVisitor.visit(node);
            stype = objRefVisitor.getSchemaType();
            ctype = objRefVisitor.getCorbaType();
        } else {
            VisitorTypeHolder holder = new VisitorTypeHolder();
            boolean found = ScopedNameVisitor.findSchemaType(this.getScope(), this.definition, this.schema, node, this.wsdlVisitor, holder);
            if (found) {
                ctype = holder.getCorbaType();
                stype = holder.getSchemaType();
            } else {
                Scope scopedName = new Scope(this.getScope(), node);
                QName qname2 = new QName(this.schema.getTargetNamespace(), scopedName.toString());
                throw new RuntimeException("[ScopedNameVisitor:  Corba type " + qname2 + " not found in typeMap]");
            }
        }
        this.setSchemaType(stype);
        this.setCorbaType(ctype);
    }

    private static CorbaTypeImpl getCorbaSchemaType(XmlSchema xmlSchema, TypeMappingType typeMap, XmlSchemaType stype, Scope scopedName) {
        CorbaTypeImpl ctype = null;
        if (stype.getQName().equals(Constants.XSD_STRING)) {
            ctype = new CorbaTypeImpl();
            ctype.setName(CorbaConstants.NT_CORBA_STRING.getLocalPart());
            ctype.setQName(CorbaConstants.NT_CORBA_STRING);
            ctype.setType(Constants.XSD_STRING);
        } else {
            QName qname2 = stype.getQName();
            ctype = ScopedNameVisitor.findCorbaTypeForSchemaType(typeMap, qname2, scopedName);
        }
        return ctype;
    }

    protected static boolean isforwardDeclared(Scope scope, AST node, WSDLASTVisitor wsdlVisitor) {
        Scope scopedName;
        boolean isForward = false;
        ScopeNameCollection scopedNames = wsdlVisitor.getScopedNames();
        if (node.getFirstChild() == null || node.getFirstChild() != null && node.getFirstChild().getType() != 16) {
            for (Scope currentScope = scope; !isForward && currentScope != currentScope.getParent(); currentScope = currentScope.getParent()) {
                scopedName = null;
                scopedName = ScopedNameVisitor.isFullyScopedName(node) ? ScopedNameVisitor.getFullyScopedName(currentScope, node) : new Scope(currentScope, node);
                if (scopedNames.getScope(scopedName) == null) continue;
                isForward = true;
            }
        }
        if (!isForward) {
            scopedName = null;
            scopedName = ScopedNameVisitor.isFullyScopedName(node) ? ScopedNameVisitor.getFullyScopedName(new Scope(), node) : new Scope(new Scope(), node);
            if (scopedNames.getScope(scopedName) != null) {
                isForward = true;
            }
        }
        return isForward;
    }

    protected static Scope forwardDeclared(Scope scope, Definition defn, XmlSchema schemaRef, AST node, WSDLASTVisitor wsdlVisitor) {
        ObjectReferenceVisitor visitor;
        String tns;
        XmlSchema xmlSchema;
        Scope scopedName;
        Scope result = null;
        ScopeNameCollection scopedNames = wsdlVisitor.getScopedNames();
        if (node.getFirstChild() == null || node.getFirstChild() != null && node.getFirstChild().getType() != 16) {
            for (Scope currentScope = scope; result == null && currentScope != currentScope.getParent(); currentScope = currentScope.getParent()) {
                scopedName = null;
                scopedName = ScopedNameVisitor.isFullyScopedName(node) ? ScopedNameVisitor.getFullyScopedName(currentScope, node) : new Scope(currentScope, node);
                if (scopedNames.getScope(scopedName) == null) continue;
                xmlSchema = schemaRef;
                tns = wsdlVisitor.getModuleToNSMapper().map(scopedName.getParent());
                if (tns != null) {
                    xmlSchema = wsdlVisitor.getManager().getXmlSchema(tns);
                }
                if (ObjectReferenceVisitor.accept(scope, xmlSchema, defn, node, wsdlVisitor)) {
                    visitor = new ObjectReferenceVisitor(scope, defn, xmlSchema, wsdlVisitor);
                    visitor.visit(node);
                }
                result = scopedName;
            }
        }
        if (result == null) {
            scopedName = null;
            scopedName = ScopedNameVisitor.isFullyScopedName(node) ? ScopedNameVisitor.getFullyScopedName(new Scope(), node) : new Scope(new Scope(), node);
            if (scopedNames.getScope(scopedName) != null) {
                xmlSchema = schemaRef;
                tns = wsdlVisitor.getModuleToNSMapper().map(scopedName.getParent());
                if (tns != null) {
                    xmlSchema = wsdlVisitor.getManager().getXmlSchema(tns);
                }
                if (ObjectReferenceVisitor.accept(scope, xmlSchema, defn, node, wsdlVisitor)) {
                    visitor = new ObjectReferenceVisitor(scope, defn, xmlSchema, wsdlVisitor);
                    visitor.visit(node);
                }
                result = scopedName;
            }
        }
        return result;
    }

    protected static boolean findSchemaType(Scope scope, Definition defn, XmlSchema schemaRef, AST node, WSDLASTVisitor wsdlVisitor, VisitorTypeHolder holder) {
        boolean result = false;
        if (node.getFirstChild() == null || node.getFirstChild() != null && node.getFirstChild().getType() != 16) {
            for (Scope currentScope = scope; !result && currentScope != currentScope.getParent(); currentScope = currentScope.getParent()) {
                Scope scopedName = null;
                scopedName = ScopedNameVisitor.isFullyScopedName(node) ? ScopedNameVisitor.getFullyScopedName(currentScope, node) : new Scope(currentScope, node);
                result = ScopedNameVisitor.findScopeSchemaType(scopedName, schemaRef, wsdlVisitor, holder);
                if (result) continue;
                result = ScopedNameVisitor.findSchemaTypeInInheritedScope(scope, defn, schemaRef, node, wsdlVisitor, holder);
            }
        }
        if (!result) {
            result = ScopedNameVisitor.findSchemaTypeInGlobalScope(scope, defn, schemaRef, node, wsdlVisitor, holder);
        }
        return result;
    }

    private static boolean findSchemaTypeInGlobalScope(Scope scope, Definition defn, XmlSchema currentSchema, AST node, WSDLASTVisitor wsdlVisitor, VisitorTypeHolder holder) {
        boolean result;
        XmlSchemaCollection schemas = wsdlVisitor.getSchemas();
        TypeMappingType typeMap = wsdlVisitor.getTypeMap();
        ModuleToNSMapper mapper = wsdlVisitor.getModuleToNSMapper();
        WSDLSchemaManager manager = wsdlVisitor.getManager();
        Scope scopedName = scope;
        String name = ((Object)node).toString();
        if (ScopedNameVisitor.isFullyScopedName(node)) {
            scopedName = ScopedNameVisitor.getFullyScopedName(new Scope(), node);
            name = scopedName.toString();
        }
        if (!(result = ScopedNameVisitor.findNonSchemaType(name, wsdlVisitor, holder))) {
            XmlSchema xmlSchema = currentSchema;
            QName qname2 = null;
            String tns = mapper.map(scopedName.getParent());
            if (tns != null) {
                xmlSchema = manager.getXmlSchema(tns);
                if (xmlSchema != null) {
                    qname2 = new QName(xmlSchema.getTargetNamespace(), scopedName.tail());
                }
            } else {
                qname2 = new QName(xmlSchema.getTargetNamespace(), name);
            }
            XmlSchemaType stype = null;
            if (qname2 != null) {
                if (exceptionMode) {
                    qname2 = new QName(xmlSchema.getTargetNamespace(), qname2.getLocalPart() + "Type");
                }
                if ((stype = xmlSchema.getTypeByName(qname2)) == null) {
                    stype = schemas.getTypeByQName(qname2);
                }
            }
            if (stype != null) {
                result = true;
                if (holder != null) {
                    holder.setSchemaType(stype);
                    holder.setCorbaType(ScopedNameVisitor.getCorbaSchemaType(xmlSchema, typeMap, stype, scopedName));
                    if (!currentSchema.getTargetNamespace().equals(xmlSchema.getTargetNamespace())) {
                        String importFile = wsdlVisitor.getOutputDir() + System.getProperty("file.separator") + scopedName.getParent().toString("_");
                        manager.addXmlSchemaImport(currentSchema, xmlSchema, importFile);
                    }
                }
            }
        }
        return result;
    }

    private static boolean findSchemaTypeInInheritedScope(Scope scope, Definition defn, XmlSchema schemaRef, AST node, WSDLASTVisitor wsdlVisitor, VisitorTypeHolder holder) {
        boolean result = false;
        List<Scope> baseScopes = wsdlVisitor.getInheritedScopeMap().get(scope);
        if (baseScopes != null) {
            ArrayList<Scope> scopeList = new ArrayList<Scope>();
            for (Scope scopeName : baseScopes) {
                scopeList.add(scopeName);
            }
            result = ScopedNameVisitor.findSchemaTypeInBaseScope(scopeList, scope, defn, schemaRef, node, wsdlVisitor, holder);
        }
        return result;
    }

    public static boolean findSchemaTypeInBaseScope(List<Scope> scopeList, Scope scope, Definition defn, XmlSchema schemaRef, AST node, WSDLASTVisitor wsdlVisitor, VisitorTypeHolder holder) {
        ArrayList<Scope> inheritedList = new ArrayList<Scope>();
        boolean result = false;
        for (Scope scopeName : scopeList) {
            inheritedList.add(scopeName);
        }
        if (scopeList != null) {
            for (Scope inheritScope : scopeList) {
                Scope scopedName = new Scope(inheritScope, node);
                result = ScopedNameVisitor.findScopeSchemaType(scopedName, schemaRef, wsdlVisitor, holder);
                if (!result) {
                    inheritedList.remove(inheritScope);
                    List<Scope> scopes = wsdlVisitor.getInheritedScopeMap().get(inheritScope);
                    if (scopes == null) continue;
                    for (Scope scopeName : scopes) {
                        inheritedList.add(scopeName);
                    }
                    continue;
                }
                return result;
            }
            if (!inheritedList.isEmpty()) {
                ArrayList<Scope> baseList = new ArrayList<Scope>();
                for (Scope scopeName : inheritedList) {
                    baseList.add(scopeName);
                }
                result = ScopedNameVisitor.findSchemaTypeInBaseScope(baseList, scope, defn, schemaRef, node, wsdlVisitor, holder);
            }
        }
        return result;
    }

    private static boolean findScopeSchemaType(Scope scopedName, XmlSchema schemaRef, WSDLASTVisitor wsdlVisitor, VisitorTypeHolder holder) {
        XmlSchemaCollection schemas = wsdlVisitor.getSchemas();
        TypeMappingType typeMap = wsdlVisitor.getTypeMap();
        ModuleToNSMapper mapper = wsdlVisitor.getModuleToNSMapper();
        WSDLSchemaManager manager = wsdlVisitor.getManager();
        boolean result = ScopedNameVisitor.findNonSchemaType(scopedName.toString(), wsdlVisitor, holder);
        if (!result) {
            QName qname2 = null;
            XmlSchema xmlSchema = schemaRef;
            String tns = wsdlVisitor.getModuleToNSMapper().map(scopedName.getParent());
            if (tns != null) {
                xmlSchema = wsdlVisitor.getManager().getXmlSchema(tns);
            }
            XmlSchemaType stype = null;
            if (xmlSchema != null) {
                String scopedNameString = null;
                scopedNameString = mapper.isDefaultMapping() ? scopedName.toString() : scopedName.tail();
                qname2 = exceptionMode ? new QName(xmlSchema.getTargetNamespace(), scopedNameString + "Type") : new QName(xmlSchema.getTargetNamespace(), scopedNameString);
                stype = xmlSchema.getTypeByName(qname2);
                if (stype == null) {
                    stype = schemas.getTypeByQName(qname2);
                }
            }
            if (stype != null) {
                result = true;
            }
            if (result && holder != null) {
                holder.setSchemaType(stype);
                holder.setCorbaType(ScopedNameVisitor.getCorbaSchemaType(xmlSchema, typeMap, stype, scopedName));
                if (!schemaRef.getTargetNamespace().equals(xmlSchema.getTargetNamespace())) {
                    String importFile = wsdlVisitor.getOutputDir() + System.getProperty("file.separator") + scopedName.getParent().toString("_");
                    manager.addXmlSchemaImport(schemaRef, xmlSchema, importFile);
                }
            }
        }
        return result;
    }

    public static CorbaTypeImpl findCorbaTypeForSchemaType(TypeMappingType typeMap, QName schemaTypeName, Scope scopedName) {
        CorbaTypeImpl result = null;
        for (CorbaTypeImpl type : typeMap.getStructOrExceptionOrUnion()) {
            if (type instanceof Sequence || type instanceof Array || type.getType() == null || type instanceof Anonsequence || type instanceof Anonarray) {
                if (type.getQName().getLocalPart().equals(schemaTypeName.getLocalPart())) {
                    result = type;
                    break;
                }
                if (!type.getQName().getLocalPart().equals(scopedName.toString())) continue;
                result = type;
                break;
            }
            if (!schemaTypeName.equals(type.getType())) continue;
            result = type;
            break;
        }
        return result;
    }

    public static CorbaTypeImpl findCorbaType(TypeMappingType typeMap, QName typeName) {
        CorbaTypeImpl result = null;
        for (CorbaTypeImpl type : typeMap.getStructOrExceptionOrUnion()) {
            if (!type.getQName().equals(typeName)) continue;
            result = type;
            break;
        }
        return result;
    }

    protected static boolean isFullyScopedName(AST node) {
        return node.getType() == 17 && node.getFirstChild() != null && (node.getFirstChild().getType() == 16 || node.getFirstChild().getType() == 17);
    }

    protected static Scope getFullyScopedName(Scope currentScope, AST node) {
        Scope scopedName = new Scope();
        if (!currentScope.toString().equals(node.getText())) {
            scopedName = new Scope(currentScope);
        }
        scopedName = new Scope(scopedName, node);
        AST scopeNode = node.getFirstChild();
        if (node.getFirstChild().getType() == 17) {
            scopedName = new Scope(scopedName, scopeNode);
        }
        while (scopeNode.getNextSibling() != null) {
            scopeNode = scopeNode.getNextSibling();
            scopedName = new Scope(scopedName, scopeNode);
        }
        return scopedName;
    }

    protected static boolean findNonSchemaType(String name, WSDLASTVisitor wsdlVisitor, VisitorTypeHolder holder) {
        boolean result = false;
        TypeMappingType typeMap = wsdlVisitor.getTypeMap();
        XmlSchemaCollection schemas = wsdlVisitor.getSchemas();
        QName qname2 = new QName(typeMap.getTargetNamespace(), name);
        CorbaTypeImpl corbaType = ScopedNameVisitor.findCorbaType(typeMap, qname2);
        if (corbaType != null) {
            if (corbaType instanceof Alias) {
                result = true;
                if (holder != null) {
                    ScopedNameVisitor.populateAliasSchemaType(corbaType, wsdlVisitor, holder);
                }
            } else if ((corbaType instanceof Sequence || corbaType instanceof Anonsequence) && (corbaType.getType().equals(Constants.XSD_BASE64) || corbaType.getType().equals(Constants.XSD_BASE64))) {
                result = true;
                if (holder != null) {
                    holder.setCorbaType(corbaType);
                    holder.setSchemaType(schemas.getTypeByQName(corbaType.getType()));
                }
            }
        }
        return result;
    }

    protected static void populateAliasSchemaType(CorbaTypeImpl corbaType, WSDLASTVisitor wsdlVisitor, VisitorTypeHolder holder) {
        XmlSchemaCollection schemas = wsdlVisitor.getSchemas();
        TypeMappingType typeMap = wsdlVisitor.getTypeMap();
        holder.setCorbaType(corbaType);
        Alias alias = (Alias)corbaType;
        CorbaTypeImpl type = ScopedNameVisitor.findCorbaType(typeMap, alias.getBasetype());
        while (type != null && type instanceof Alias) {
            alias = (Alias)type;
            type = ScopedNameVisitor.findCorbaType(typeMap, alias.getBasetype());
        }
        QName tname = type == null ? xmlSchemaPrimitiveMap.get(alias.getBasetype()) : type.getType();
        XmlSchemaType stype = schemas.getTypeByQName(tname);
        if (stype == null) {
            XmlSchema xmlSchema = wsdlVisitor.getManager().getXmlSchema(tname.getNamespaceURI());
            stype = xmlSchema != null ? xmlSchema.getTypeByName(tname) : wsdlVisitor.getSchema().getTypeByName(tname);
        }
        holder.setSchemaType(stype);
    }

    static {
        xmlSchemaPrimitiveMap = new XmlSchemaPrimitiveMap();
    }
}

