/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.idl;

import antlr.collections.AST;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.wsdl.CorbaTypeImpl;
import org.apache.cxf.binding.corba.wsdl.MemberType;
import org.apache.cxf.binding.corba.wsdl.Struct;
import org.apache.cxf.tools.corba.common.ReferenceConstants;
import org.apache.cxf.tools.corba.processors.idl.ArrayVisitor;
import org.apache.cxf.tools.corba.processors.idl.DeferredActionCollection;
import org.apache.cxf.tools.corba.processors.idl.SchemaDeferredAction;
import org.apache.cxf.tools.corba.processors.idl.Scope;
import org.apache.cxf.tools.corba.processors.idl.ScopeNameCollection;
import org.apache.cxf.tools.corba.processors.idl.ScopedNameVisitor;
import org.apache.cxf.tools.corba.processors.idl.StructDeferredAction;
import org.apache.cxf.tools.corba.processors.idl.TypesUtils;
import org.apache.cxf.tools.corba.processors.idl.TypesVisitor;
import org.apache.cxf.tools.corba.processors.idl.VisitorBase;
import org.apache.cxf.tools.corba.processors.idl.WSDLASTVisitor;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;

public class StructVisitor
extends VisitorBase {
    public StructVisitor(Scope scope, Definition defn, XmlSchema schemaRef, WSDLASTVisitor wsdlVisitor) {
        super(scope, defn, schemaRef, wsdlVisitor);
    }

    public static boolean accept(AST node) {
        return node.getType() == 54;
    }

    public void visit(AST node) {
        AST identifierNode = node.getFirstChild();
        if (identifierNode.getFirstChild() == null && identifierNode.getNextSibling() == null) {
            this.visitForwardDeclaredStruct(identifierNode);
        } else {
            this.visitDeclaredStruct(identifierNode);
        }
    }

    public void visitDeclaredStruct(AST identifierNode) {
        Scope structScope = new Scope(this.getScope(), identifierNode);
        XmlSchemaComplexType complexType2 = new XmlSchemaComplexType(this.schema, true);
        complexType2.setName(this.mapper.mapToQName(structScope));
        XmlSchemaSequence sequence = new XmlSchemaSequence();
        complexType2.setParticle(sequence);
        Struct struct = new Struct();
        struct.setQName(new QName(this.typeMap.getTargetNamespace(), structScope.toString()));
        struct.setType(complexType2.getQName());
        struct.setRepositoryID(structScope.toIDLRepositoryID());
        boolean recursiveAdd = this.addRecursiveScopedName(identifierNode);
        this.visitStructMembers(identifierNode, struct, sequence, structScope);
        if (recursiveAdd) {
            this.removeRecursiveScopedName(identifierNode);
        }
        this.typeMap.getStructOrExceptionOrUnion().add(struct);
        this.setSchemaType(complexType2);
        this.setCorbaType(struct);
        this.processForwardStructActions(structScope);
        scopedNames.remove(structScope);
    }

    private void visitStructMembers(AST identifierNode, Struct struct, XmlSchemaSequence sequence, Scope structScope) {
        AST memberTypeNode = identifierNode.getNextSibling();
        while (memberTypeNode != null) {
            AST memberNode;
            XmlSchemaType schemaType = null;
            CorbaTypeImpl corbaType = null;
            Scope fqName = null;
            try {
                TypesVisitor visitor = new TypesVisitor(structScope, this.definition, this.schema, this.wsdlVisitor, null);
                visitor.visit(memberTypeNode);
                schemaType = visitor.getSchemaType();
                corbaType = visitor.getCorbaType();
                fqName = visitor.getFullyQualifiedName();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            for (memberNode = TypesUtils.getCorbaTypeNameNode(memberTypeNode); memberNode != null && memberNode.getType() == 17 && !ScopedNameVisitor.accept(structScope, this.definition, this.schema, memberNode, this.wsdlVisitor); memberNode = memberNode.getNextSibling()) {
                XmlSchemaType memberSchemaType = schemaType;
                CorbaTypeImpl memberCorbaType = corbaType;
                if (ArrayVisitor.accept(memberNode)) {
                    Scope anonScope = new Scope(structScope, TypesUtils.getCorbaTypeNameNode(memberTypeNode));
                    ArrayVisitor arrayVisitor = new ArrayVisitor(anonScope, this.definition, this.schema, this.wsdlVisitor, null, fqName);
                    arrayVisitor.setSchemaType(schemaType);
                    arrayVisitor.setCorbaType(corbaType);
                    arrayVisitor.visit(memberNode);
                    memberSchemaType = arrayVisitor.getSchemaType();
                    memberCorbaType = arrayVisitor.getCorbaType();
                    fqName = arrayVisitor.getFullyQualifiedName();
                }
                XmlSchemaElement member = this.createXmlSchemaElement(memberNode, memberSchemaType, fqName);
                sequence.getItems().add(member);
                MemberType memberType = this.createMemberType(memberNode, memberCorbaType, fqName);
                struct.getMember().add(memberType);
            }
            memberTypeNode = memberNode;
        }
    }

    private XmlSchemaElement createXmlSchemaElement(AST memberNode, XmlSchemaType schemaType, Scope fqName) {
        XmlSchemaElement member = new XmlSchemaElement(this.schema, false);
        String memberName = ((Object)memberNode).toString();
        member.setName(memberName);
        member.setSchemaType(schemaType);
        if (schemaType != null) {
            member.setSchemaTypeName(schemaType.getQName());
            if (schemaType.getQName().equals(ReferenceConstants.WSADDRESSING_TYPE)) {
                member.setNillable(true);
            }
        } else {
            this.wsdlVisitor.getDeferredActions().add(fqName, new StructDeferredAction(member));
        }
        return member;
    }

    private MemberType createMemberType(AST memberNode, CorbaTypeImpl corbaType, Scope fqName) {
        String memberName = ((Object)memberNode).toString();
        MemberType memberType = new MemberType();
        memberType.setName(memberName);
        if (corbaType != null) {
            memberType.setIdltype(corbaType.getQName());
        } else {
            this.wsdlVisitor.getDeferredActions().add(fqName, new StructDeferredAction(memberType));
        }
        return memberType;
    }

    private void visitForwardDeclaredStruct(AST identifierNode) {
        String structName = ((Object)identifierNode).toString();
        Scope structScope = new Scope(this.getScope(), structName);
        ScopeNameCollection scopedNames = this.wsdlVisitor.getScopedNames();
        if (scopedNames.getScope(structScope) == null) {
            scopedNames.add(structScope);
        }
    }

    private void processForwardStructActions(Scope structScope) {
        DeferredActionCollection deferredActions;
        List list;
        if (this.wsdlVisitor.getDeferredActions() != null && (list = (deferredActions = this.wsdlVisitor.getDeferredActions()).getActions(structScope)) != null && !list.isEmpty()) {
            XmlSchemaType stype = this.getSchemaType();
            CorbaTypeImpl ctype = this.getCorbaType();
            for (SchemaDeferredAction action : list) {
                action.execute(stype, ctype);
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
        }
    }

    private boolean addRecursiveScopedName(AST identifierNode) {
        String structName = ((Object)identifierNode).toString();
        Scope structScope = new Scope(this.getScope(), structName);
        ScopeNameCollection scopedNames = this.wsdlVisitor.getScopedNames();
        if (scopedNames.getScope(structScope) == null) {
            scopedNames.add(structScope);
            return true;
        }
        return false;
    }

    private void removeRecursiveScopedName(AST identifierNode) {
        String structName = ((Object)identifierNode).toString();
        Scope structScope = new Scope(this.getScope(), structName);
        ScopeNameCollection scopedNames = this.wsdlVisitor.getScopedNames();
        scopedNames.remove(structScope);
    }
}

