/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.wsdl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.wsdl.AddressType;
import org.apache.cxf.binding.corba.wsdl.ArgType;
import org.apache.cxf.binding.corba.wsdl.BindingType;
import org.apache.cxf.binding.corba.wsdl.CorbaConstants;
import org.apache.cxf.binding.corba.wsdl.CorbaType;
import org.apache.cxf.binding.corba.wsdl.CorbaTypeImpl;
import org.apache.cxf.binding.corba.wsdl.MemberType;
import org.apache.cxf.binding.corba.wsdl.NamedType;
import org.apache.cxf.binding.corba.wsdl.OperationType;
import org.apache.cxf.binding.corba.wsdl.ParamType;
import org.apache.cxf.binding.corba.wsdl.RaisesType;
import org.apache.cxf.binding.corba.wsdl.TypeMappingType;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.corba.processors.wsdl.WSDLParameter;
import org.apache.cxf.tools.corba.processors.wsdl.WSDLToCorbaHelper;
import org.apache.cxf.tools.corba.processors.wsdl.WSDLToTypeProcessor;
import org.apache.cxf.tools.corba.processors.wsdl.WSDLTypes;
import org.apache.cxf.wsdl.JAXBExtensionHelper;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAnnotation;
import org.apache.ws.commons.schema.XmlSchemaAnnotationItem;
import org.apache.ws.commons.schema.XmlSchemaAppInfo;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaExternal;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLToCorbaBinding {
    protected static final Logger LOG = LogUtils.getL7dLogger(WSDLToCorbaBinding.class);
    static XmlSchema xmlSchemaType;
    static String wsdlFileName;
    static String outputFile;
    static String namespace;
    static boolean verboseOn;
    protected Definition def;
    protected String idlNamespace;
    WSDLToCorbaHelper helper = new WSDLToCorbaHelper();
    TypeMappingType typeMappingType;
    ExtensionRegistry extReg;
    List<String> interfaceNames = new ArrayList<String>();
    Map<Object, Object> bindingNameMap = new HashMap<Object, Object>();
    String bindingName;
    String address;
    String addressFile;
    WSDLParameter wsdlParameter;
    List<String> bindingNames;
    SchemaCollection xmlSchemaList;
    WSDLToTypeProcessor typeProcessor = new WSDLToTypeProcessor();
    private boolean allbindings;

    public WSDLToCorbaHelper getHelper() {
        return this.helper;
    }

    public Definition generateCORBABinding() throws Exception {
        this.typeProcessor.parseWSDL(this.getWsdlFileName());
        this.def = this.typeProcessor.getWSDLDefinition();
        this.generateCORBABinding(this.def);
        return this.def;
    }

    public Binding[] generateCORBABinding(Definition definition) throws Exception {
        this.def = definition;
        this.helper.setWsdlDefinition(this.def);
        this.typeProcessor.setWSDLDefinition(this.def);
        this.wsdlParameter = new WSDLParameter();
        if (this.idlNamespace == null) {
            this.setIdlNamespace(this.def);
        }
        this.generateNSPrefix(this.def, this.getIdlNamespace(), "ns");
        this.typeProcessor.process();
        this.xmlSchemaList = this.typeProcessor.getXmlSchemaTypes();
        this.helper.setXMLSchemaList(this.xmlSchemaList);
        List<PortType> intfs = null;
        if (this.interfaceNames.size() > 0) {
            intfs = new ArrayList<PortType>(this.interfaceNames.size());
            for (String interfaceName : this.interfaceNames) {
                PortType portType = null;
                Map portTypes = this.def.getAllPortTypes();
                if (portTypes != null) {
                    for (QName existPortQName : portTypes.keySet()) {
                        if (!existPortQName.getLocalPart().equals(interfaceName)) {
                            portType = null;
                            continue;
                        }
                        portType = (PortType)portTypes.get(existPortQName);
                        break;
                    }
                }
                if (portType == null) {
                    String msgStr = "PortType " + interfaceName + " doesn't exist in WSDL.";
                    throw new Exception(msgStr);
                }
                intfs.add(portType);
            }
        } else {
            intfs = this.getPortTypeList();
        }
        Binding[] bindings = new Binding[intfs.size()];
        for (int i = 0; i < intfs.size(); ++i) {
            bindings[i] = this.generateCORBABinding(this.def, intfs.get(i));
            this.generateCORBAServiceForBinding(this.def, intfs.get(i), bindings[i]);
        }
        return bindings;
    }

    private List<PortType> getPortTypeList() throws Exception {
        Map portTypes = this.def.getAllPortTypes();
        ArrayList<PortType> intfs = null;
        if (portTypes == null) {
            Message msg = new Message("No PortTypes defined in wsdl", LOG, new Object[0]);
            throw new Exception(msg.toString());
        }
        PortType portType = null;
        intfs = new ArrayList<PortType>();
        if (portTypes.size() == 1) {
            portType = (PortType)portTypes.values().iterator().next();
            this.interfaceNames.add(portType.getQName().getLocalPart());
            intfs.add(portType);
        } else if (portTypes.size() > 1) {
            if (this.def.getAllBindings().size() > 0) {
                this.throwMultipleMultipleTypeException(this.def.getAllBindings());
            }
            for (PortType port : portTypes.values()) {
                this.interfaceNames.add(port.getQName().getLocalPart());
                intfs.add(port);
            }
        }
        return intfs;
    }

    private void throwMultipleMultipleTypeException(Map binds) throws Exception {
        StringBuilder sb = new StringBuilder();
        Message msgDef = new Message("Multiple Bindings already defined in the wsdl", LOG, new Object[0]);
        sb.append(msgDef.toString());
        Iterator it2 = binds.keySet().iterator();
        int cnt = 0;
        while (it2.hasNext()) {
            sb.append("  " + ++cnt + " --> " + ((QName)it2.next()).getLocalPart());
        }
        throw new Exception(sb.toString());
    }

    private Binding generateCORBABinding(Definition definition, PortType portType) throws Exception {
        String pfx;
        QName bqname = null;
        if (this.extReg == null) {
            this.extReg = this.def.getExtensionRegistry();
            this.addExtensions(this.extReg);
        }
        this.bindingNames = new ArrayList<String>();
        String interfaceName = portType.getQName().getLocalPart();
        String bname = this.getMappedBindingName(interfaceName);
        String prefix = definition.getPrefix(definition.getTargetNamespace());
        if (prefix == null) {
            prefix = "";
        }
        if (bname == null && !this.allbindings) {
            bname = this.bindingName;
        }
        if (bname == null) {
            bname = this.mangleInterfaceName(interfaceName) + "CORBABinding";
            this.setBindingName(bname);
            bqname = new QName(definition.getTargetNamespace(), bname, prefix);
            int count = 0;
            while (WSDLToCorbaHelper.queryBinding(definition, bqname)) {
                bname = bname + count;
                bqname = new QName(definition.getTargetNamespace(), bname, prefix);
            }
        } else {
            bqname = new QName(definition.getTargetNamespace(), bname, prefix);
            if (WSDLToCorbaHelper.queryBinding(definition, bqname)) {
                String msgStr = "Binding " + bqname.getLocalPart() + " already exists in WSDL.";
                Message msg = new Message(msgStr, LOG, new Object[0]);
                throw new Exception(msg.toString());
            }
        }
        if ((pfx = definition.getPrefix("http://cxf.apache.org/bindings/corba")) == null) {
            pfx = new String("corba");
            this.def.addNamespace(pfx, "http://cxf.apache.org/bindings/corba");
        }
        Binding binding = null;
        binding = this.def.createBinding();
        binding.setPortType(portType);
        binding.setQName(bqname);
        this.bindingNames.add(bname);
        this.mapBindingToInterface(portType.getQName().getLocalPart(), bname);
        BindingType bindingType = null;
        this.addCorbaTypeMap(this.def);
        try {
            bindingType = (BindingType)this.extReg.createExtension(Binding.class, CorbaConstants.NE_CORBA_BINDING);
            bindingType.setRepositoryID("IDL:" + binding.getPortType().getQName().getLocalPart().replace('.', '/') + ":1.0");
            binding.addExtensibilityElement(bindingType);
        }
        catch (WSDLException ex) {
            ex.printStackTrace();
        }
        try {
            this.addBindingOperations(this.def, portType, binding);
            binding.setUndefined(false);
            definition.addBinding(binding);
        }
        catch (Exception ex) {
            binding.setUndefined(true);
        }
        this.cleanUpTypeMap(this.typeMappingType);
        return binding;
    }

    private void generateCORBAServiceForBinding(Definition definition, PortType portType, Binding binding) throws Exception {
        String corbaPrefix;
        if (this.extReg == null) {
            this.extReg = this.def.getExtensionRegistry();
            this.addExtensions(this.extReg);
        }
        String interfaceName = portType.getQName().getLocalPart();
        interfaceName = this.mangleInterfaceName(interfaceName);
        String serviceName = interfaceName + "CORBAService";
        String portName = interfaceName + "CORBAPort";
        String prefix = definition.getPrefix(definition.getTargetNamespace());
        if (prefix == null) {
            prefix = "";
        }
        if ((corbaPrefix = definition.getPrefix("http://cxf.apache.org/bindings/corba")) == null) {
            corbaPrefix = new String("corba");
            this.def.addNamespace(corbaPrefix, "http://cxf.apache.org/bindings/corba");
        }
        Service service = this.def.createService();
        Port servicePort = this.def.createPort();
        servicePort.setName(portName);
        servicePort.setBinding(binding);
        try {
            AddressType addressType = (AddressType)this.def.getExtensionRegistry().createExtension(Port.class, CorbaConstants.NE_CORBA_ADDRESS);
            String addr = null;
            if (this.getAddressFile() != null) {
                try {
                    File addrFile = new File(this.getAddressFile());
                    FileReader fileReader = new FileReader(addrFile);
                    BufferedReader bufferedReader = new BufferedReader(fileReader);
                    addr = bufferedReader.readLine();
                }
                catch (Exception ex) {
                    throw new ToolException(ex.getMessage(), (Throwable)ex);
                }
            } else {
                addr = this.getAddress();
            }
            if (addr == null) {
                addr = "file:./" + interfaceName + ".ref";
            }
            addressType.setLocation(addr);
            servicePort.addExtensibilityElement(addressType);
        }
        catch (WSDLException ex) {
            throw new Exception("Failed to create CORBA address for service", ex);
        }
        QName serviceQName = new QName(definition.getTargetNamespace(), serviceName, prefix);
        service.setQName(serviceQName);
        service.addPort(servicePort);
        definition.addService(service);
    }

    private void addBindingOperations(Definition definition, PortType portType, Binding binding) throws Exception {
        List<Operation> ops = CastUtils.cast(portType.getOperations());
        for (Operation op : ops) {
            try {
                BindingOperation bindingOperation = definition.createBindingOperation();
                this.addCorbaOperationExtElement(bindingOperation, op);
                bindingOperation.setName(op.getName());
                if (op.getInput() != null) {
                    BindingInput bindingInput = definition.createBindingInput();
                    bindingInput.setName(op.getInput().getName());
                    bindingOperation.setBindingInput(bindingInput);
                }
                if (op.getOutput() != null) {
                    BindingOutput bindingOutput = definition.createBindingOutput();
                    bindingOutput.setName(op.getOutput().getName());
                    bindingOperation.setBindingOutput(bindingOutput);
                }
                if (op.getFaults() != null && op.getFaults().size() > 0) {
                    Map faults = op.getFaults();
                    for (Fault fault : faults.values()) {
                        BindingFault bindingFault = definition.createBindingFault();
                        bindingFault.setName(fault.getName());
                        bindingOperation.addBindingFault(bindingFault);
                    }
                }
                bindingOperation.setOperation(op);
                binding.addBindingOperation(bindingOperation);
            }
            catch (Exception ex) {
                LOG.warning("Operation " + op.getName() + " not mapped to CORBA binding.");
            }
        }
    }

    public void addExtensions(ExtensionRegistry extRegistry) throws JAXBException {
        try {
            JAXBExtensionHelper.addExtensions(this.extReg, Binding.class, BindingType.class);
            JAXBExtensionHelper.addExtensions(this.extReg, BindingOperation.class, OperationType.class);
            JAXBExtensionHelper.addExtensions(this.extReg, Definition.class, TypeMappingType.class);
            JAXBExtensionHelper.addExtensions(this.extReg, Port.class, AddressType.class);
            this.extReg.mapExtensionTypes(Binding.class, CorbaConstants.NE_CORBA_BINDING, BindingType.class);
            this.extReg.mapExtensionTypes(BindingOperation.class, CorbaConstants.NE_CORBA_OPERATION, OperationType.class);
            this.extReg.mapExtensionTypes(Definition.class, CorbaConstants.NE_CORBA_TYPEMAPPING, TypeMappingType.class);
            this.extReg.mapExtensionTypes(Port.class, CorbaConstants.NE_CORBA_ADDRESS, AddressType.class);
        }
        catch (JAXBException ex) {
            LOG.log(Level.SEVERE, "Failing to serialize/deserialize extensions", ex);
            throw new JAXBException(ex.getMessage());
        }
    }

    private void addCorbaOperationExtElement(BindingOperation bo, Operation op) throws Exception {
        OperationType operationType = null;
        try {
            operationType = (OperationType)this.extReg.createExtension(BindingOperation.class, CorbaConstants.NE_CORBA_OPERATION);
        }
        catch (WSDLException wse) {
            LOG.log(Level.SEVERE, "Failed to create a Binding Operation extension", wse);
            throw new Exception(LOG.toString(), wse);
        }
        operationType.setName(op.getName());
        ArrayList<ParamType> params = new ArrayList<ParamType>();
        ArrayList<ArgType> returns = new ArrayList<ArgType>();
        this.wsdlParameter.processParameters(this, op, this.def, this.xmlSchemaList, params, returns, true);
        for (ParamType paramtype : params) {
            operationType.getParam().add(paramtype);
        }
        for (ArgType retType : returns) {
            operationType.setReturn(retType);
        }
        Map faults = op.getFaults();
        for (Fault fault : faults.values()) {
            RaisesType raisestype = new RaisesType();
            CorbaTypeImpl extype = this.convertFaultToCorbaType(xmlSchemaType, fault);
            if (extype == null) continue;
            raisestype.setException(this.helper.createQNameCorbaNamespace(extype.getName()));
            operationType.getRaises().add(raisestype);
        }
        bo.addExtensibilityElement(operationType);
    }

    private void addCorbaTypeMap(Definition definition) throws Exception {
        Iterator t = definition.getExtensibilityElements().iterator();
        Iterator j = definition.getExtensibilityElements().iterator();
        while (t.hasNext()) {
            if (!(j.next() instanceof TypeMappingType)) continue;
            this.typeMappingType = (TypeMappingType)t.next();
            break;
        }
        if (this.typeMappingType == null) {
            this.typeMappingType = (TypeMappingType)this.extReg.createExtension(Definition.class, CorbaConstants.NE_CORBA_TYPEMAPPING);
            this.typeMappingType.setTargetNamespace(this.getIdlNamespace());
            definition.addExtensibilityElement(this.typeMappingType);
        }
        this.helper.setTypeMap(this.typeMappingType);
        this.addCorbaTypes(definition);
    }

    private void addCorbaTypes(Definition definition) throws Exception {
        for (XmlSchema xmlSchemaTypes : this.xmlSchemaList.getXmlSchemas()) {
            for (XmlSchemaExternal ext : xmlSchemaTypes.getExternals()) {
                this.addCorbaTypes(ext.getSchema());
            }
            if ("http://www.w3.org/2001/XMLSchema".equals(xmlSchemaTypes.getTargetNamespace())) continue;
            this.addCorbaTypes(xmlSchemaTypes);
        }
    }

    private void addCorbaTypes(XmlSchema xmlSchemaTypes) throws Exception {
        Map<QName, XmlSchemaType> objs = xmlSchemaTypes.getSchemaTypes();
        CorbaTypeImpl corbaTypeImpl = null;
        for (XmlSchemaType type : objs.values()) {
            boolean anonymous = WSDLTypes.isAnonymous(type.getName());
            corbaTypeImpl = this.helper.convertSchemaToCorbaType(type, type.getQName(), null, null, anonymous);
            if (corbaTypeImpl == null || this.helper.isDuplicate(corbaTypeImpl)) continue;
            this.typeMappingType.getStructOrExceptionOrUnion().add(corbaTypeImpl);
        }
        this.addCorbaElements(corbaTypeImpl, xmlSchemaTypes);
    }

    private void addCorbaElements(CorbaTypeImpl corbaTypeImpl, XmlSchema xmlSchemaTypes) throws Exception {
        Map<QName, XmlSchemaElement> elements = xmlSchemaTypes.getElements();
        for (XmlSchemaElement el : elements.values()) {
            QName elName = el.getQName();
            XmlSchemaType schemaType = el.getSchemaType();
            if (elName == null) {
                elName = el.getRef().getTargetQName();
                schemaType = this.helper.getSchemaType(elName);
            }
            boolean anonymous = false;
            anonymous = schemaType == null ? true : WSDLTypes.isAnonymous(schemaType.getName());
            if (schemaType == null) continue;
            XmlSchemaAnnotation annotation2 = null;
            if (el.getAnnotation() != null) {
                annotation2 = el.getAnnotation();
            }
            if (annotation2 != null) {
                XmlSchemaAppInfo appInfo = null;
                for (XmlSchemaAnnotationItem ann : annotation2.getItems()) {
                    if (!(ann instanceof XmlSchemaAppInfo)) continue;
                    appInfo = (XmlSchemaAppInfo)ann;
                    break;
                }
                if (appInfo != null) {
                    NodeList nlist = appInfo.getMarkup();
                    Node node = nlist.item(0);
                    String info = node.getNodeValue();
                    info = info.trim();
                    String annotationBindingName = "";
                    if ("corba:binding=".equals(info.substring(0, 14))) {
                        annotationBindingName = info.substring(14);
                    }
                    if (this.bindingName.equals(annotationBindingName)) {
                        annotation2 = null;
                    }
                }
            }
            corbaTypeImpl = this.helper.convertSchemaToCorbaType(schemaType, elName, schemaType, annotation2, anonymous);
            if (el.isNillable()) {
                QName uname = this.helper.createQNameCorbaNamespace(corbaTypeImpl.getQName().getLocalPart() + "_nil");
                boolean isQualified = corbaTypeImpl.isSetQualified() && corbaTypeImpl.isQualified();
                corbaTypeImpl = this.helper.createNillableUnion(uname, this.helper.checkPrefix(elName), this.helper.checkPrefix(corbaTypeImpl.getQName()), isQualified);
            }
            if (corbaTypeImpl == null || this.helper.isDuplicate(corbaTypeImpl)) continue;
            this.typeMappingType.getStructOrExceptionOrUnion().add(corbaTypeImpl);
        }
    }

    private CorbaTypeImpl convertFaultToCorbaType(XmlSchema xmlSchema, Fault fault) throws Exception {
        Message msg;
        String msgStr;
        CorbaType corbaex = null;
        XmlSchemaType schemaType = null;
        Iterator parts = fault.getMessage().getParts().values().iterator();
        if (!parts.hasNext()) {
            String msgStr2 = "Fault " + fault.getMessage().getQName().getLocalPart() + " UNSUPPORTED_FAULT.";
            Message msg2 = new Message(msgStr2, LOG, new Object[0]);
            throw new Exception(msg2.toString());
        }
        Part part = (Part)parts.next();
        schemaType = this.helper.lookUpType(part);
        if (schemaType != null) {
            QName name = schemaType.getQName();
            if (name == null) {
                name = part.getElementName();
            }
            if (!this.helper.isSchemaTypeException(schemaType)) {
                corbaex = new org.apache.cxf.binding.corba.wsdl.Exception();
                String faultName = fault.getMessage().getQName().getLocalPart();
                int pos = faultName.indexOf("_exception.");
                if (pos != -1) {
                    faultName = faultName.substring(pos + 11);
                    faultName = faultName + "Exception";
                }
                QName faultMsgName = this.helper.createQNameCorbaNamespace(faultName);
                corbaex.setName(faultName);
                ((CorbaTypeImpl)corbaex).setQName(faultMsgName);
                CorbaTypeImpl corbaTypeImpl = this.helper.convertSchemaToCorbaType(schemaType, name, null, null, false);
                if (corbaTypeImpl != null) {
                    MemberType member = new MemberType();
                    member.setName(corbaTypeImpl.getQName().getLocalPart());
                    member.setIdltype(corbaTypeImpl.getQName());
                    if (corbaTypeImpl.isSetQualified() && corbaTypeImpl.isQualified()) {
                        member.setQualified(true);
                    }
                    ((org.apache.cxf.binding.corba.wsdl.Exception)corbaex).getMember().add(member);
                }
            } else {
                corbaex = this.createCorbaException(name, schemaType);
            }
        }
        if (schemaType == null) {
            msgStr = "Fault " + fault.getMessage().getQName().getLocalPart() + " INCORRECT_FAULT_MSG.";
            msg = new Message(msgStr, LOG, new Object[0]);
            throw new Exception(msg.toString());
        }
        if (corbaex == null) {
            msgStr = "Fault " + fault.getMessage().getQName().getLocalPart() + " UNSUPPORTED_FAULT.";
            msg = new Message(msgStr, LOG, new Object[0]);
            throw new Exception(msg.toString());
        }
        String repoId = "IDL:" + corbaex.getName().replace('.', '/') + ":1.0";
        ((NamedType)corbaex).setRepositoryID(repoId);
        CorbaType corbaTypeImpl = corbaex;
        if (!this.helper.isDuplicate((CorbaTypeImpl)corbaTypeImpl)) {
            CorbaTypeImpl dup = this.helper.isDuplicateException((CorbaTypeImpl)corbaTypeImpl);
            if (dup != null) {
                this.typeMappingType.getStructOrExceptionOrUnion().remove(dup);
                this.typeMappingType.getStructOrExceptionOrUnion().add((CorbaTypeImpl)corbaTypeImpl);
            } else {
                this.typeMappingType.getStructOrExceptionOrUnion().add((CorbaTypeImpl)corbaTypeImpl);
            }
        }
        return corbaex;
    }

    private org.apache.cxf.binding.corba.wsdl.Exception createCorbaException(QName schemaTypeName, XmlSchemaType stype) throws Exception {
        org.apache.cxf.binding.corba.wsdl.Exception corbaex = null;
        XmlSchemaComplexType complex = null;
        if (stype instanceof XmlSchemaComplexType) {
            QName defaultName = schemaTypeName;
            complex = (XmlSchemaComplexType)stype;
            corbaex = new org.apache.cxf.binding.corba.wsdl.Exception();
            corbaex.setQName(schemaTypeName);
            corbaex.setType(this.helper.checkPrefix(schemaTypeName));
            corbaex.setName(schemaTypeName.getLocalPart());
            corbaex.setRepositoryID("IDL:/" + defaultName.getLocalPart() + ":1.0");
            String uri = defaultName.getNamespaceURI();
            List<MemberType> attributeMembers = this.helper.processAttributesAsMembers(complex.getAttributes(), uri);
            for (MemberType memberType : attributeMembers) {
                corbaex.getMember().add(memberType);
            }
            List members = this.helper.processContainerAsMembers(complex.getParticle(), stype.getQName(), defaultName);
            for (MemberType memberType : members) {
                corbaex.getMember().add(memberType);
            }
        }
        return corbaex;
    }

    public void setWsdlFile(String file) {
        wsdlFileName = new String(file);
    }

    public String getWsdlFileName() {
        return wsdlFileName;
    }

    public void setIdlNamespace(Definition definition) {
        if (this.idlNamespace == null) {
            String tns = definition.getTargetNamespace();
            if (!tns.endsWith("/")) {
                tns = tns + "/";
            }
            this.idlNamespace = tns + "corba/typemap/";
        }
        this.setNamespace(this.idlNamespace);
    }

    public String getIdlNamespace() {
        return this.idlNamespace;
    }

    public void generateNSPrefix(Definition definition, String namespaceURI, String str) {
        String pfx = this.def.getPrefix(namespaceURI);
        if (pfx != null) {
            return;
        }
        int cnt = 0;
        while (pfx == null) {
            pfx = str + ++cnt;
            if (this.def.getNamespace(pfx) == null) continue;
            pfx = null;
        }
        this.def.addNamespace(pfx, namespaceURI);
    }

    public void setBindingName(String bname) {
        this.bindingName = bname;
    }

    public void mapBindingToInterface(String intfName, String bName) {
        this.bindingNameMap.put(intfName, bName);
    }

    public String getMappedBindingName(String interfaceName) {
        return (String)this.bindingNameMap.get(interfaceName);
    }

    public List<String> getGeneratedBindingNames() {
        return this.bindingNames;
    }

    private String mangleInterfaceName(String name) {
        int idx = name.indexOf("PortType");
        if (idx != -1) {
            return name.substring(0, idx);
        }
        return name;
    }

    public QName convertToQName(String name) {
        String namespaceName = null;
        String nametype = null;
        String pfx = "";
        int i = name.lastIndexOf("}");
        int i2 = name.indexOf("}");
        if (i >= 1) {
            if (i == i2) {
                namespaceName = name.substring(1, i);
                nametype = name.substring(i + 1, name.length());
            } else {
                namespaceName = name.substring(1, i2);
                pfx = name.substring(i2 + 2, i);
                nametype = name.substring(i + 1, name.length());
            }
        }
        return new QName(namespaceName, nametype, pfx);
    }

    public void setOutputDirectory(String dir) {
        File fileOutputDir;
        if (dir != null && !(fileOutputDir = new File(dir)).exists()) {
            fileOutputDir.mkdir();
        }
    }

    public void setExtensionRegistry(ExtensionRegistry reg) {
        this.extReg = reg;
    }

    public ExtensionRegistry getExtensionRegistry() {
        return this.extReg;
    }

    public void setAddress(String addr) {
        this.address = addr;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddressFile(String addrFile) {
        this.addressFile = addrFile;
    }

    public String getAddressFile() {
        return this.addressFile;
    }

    public void setOutputFile(String file) {
        outputFile = new String(file);
    }

    public void setNamespace(String nameSpaceName) {
        this.idlNamespace = nameSpaceName;
        this.helper.setIdlNamespace(this.idlNamespace);
    }

    public void addInterfaceName(String interfaceName) {
        this.interfaceNames.add(interfaceName);
    }

    public List getInterfaceNames() {
        return this.interfaceNames;
    }

    public void setVerboseOn(boolean verbose) {
        verboseOn = verbose;
    }

    public void setAllBindings(boolean all) {
        this.allbindings = all;
    }

    public boolean isGenerateAllBindings() {
        return this.allbindings;
    }

    public void cleanUpTypeMap(TypeMappingType typeMap) {
        List<CorbaTypeImpl> types = typeMap.getStructOrExceptionOrUnion();
        if (types != null) {
            for (int i = 0; i < types.size(); ++i) {
                CorbaTypeImpl type = types.get(i);
                if (type.getQName() == null) continue;
                type.setName(type.getQName().getLocalPart());
                type.setQName(null);
            }
        }
    }

    public void main(String[] args) {
        if (args.length != 6) {
            System.err.println("usage: WSDLToCORBABinding -w <wsdl file> -i <interfaceName> -o <output wsdl file>");
            return;
        }
        try {
            WSDLToCorbaBinding wsdlToCorbaBinding = new WSDLToCorbaBinding();
            wsdlToCorbaBinding.setWsdlFile(args[1]);
            wsdlToCorbaBinding.addInterfaceName(args[3]);
            wsdlToCorbaBinding.setOutputDirectory(".");
            wsdlToCorbaBinding.generateCORBABinding();
        }
        catch (Exception ex) {
            System.err.println("Error : " + ex.getMessage());
            System.err.println();
            if (verboseOn) {
                ex.printStackTrace();
            }
            System.exit(1);
        }
    }
}

