/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.misc.processor;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.apache.cxf.common.WSDLConstants;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.Processor;
import org.apache.cxf.tools.common.ToolConstants;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.dom.ExtendedDocumentBuilder;
import org.apache.cxf.tools.util.FileWriterUtil;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customization.JAXWSBinding;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customization.JAXWSBindingDeserializer;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customization.JAXWSBindingSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XSDToWSDLProcessor
implements Processor {
    private static final Logger LOG = LogUtils.getL7dLogger(XSDToWSDLProcessor.class);
    private static final String XSD_FILE_NAME_EXT = ".xsd";
    private static final String WSDL_FILE_NAME_EXT = ".wsdl";
    private Definition wsdlDefinition;
    private ExtensionRegistry registry;
    private WSDLFactory wsdlFactory;
    private String xsdUrl;
    private final ExtendedDocumentBuilder xsdBuilder = new ExtendedDocumentBuilder();
    private Document xsdDoc;
    private ToolContext env;

    public void process() throws ToolException {
        this.envParamSetting();
        this.initXSD();
        this.initWSDL();
        this.addWSDLTypes();
    }

    public void setEnvironment(ToolContext newEnv) {
        this.env = newEnv;
    }

    private void envParamSetting() {
        this.xsdUrl = (String)this.env.get("xsdurl");
        if (!this.env.optionSet("name")) {
            this.env.put("name", this.xsdUrl.substring(0, this.xsdUrl.length() - 4));
        }
    }

    private void initWSDL() throws ToolException {
        try {
            this.wsdlFactory = WSDLFactory.newInstance();
            this.wsdlDefinition = this.wsdlFactory.newDefinition();
        }
        catch (WSDLException we) {
            Message msg = new Message("FAIL_TO_CREATE_WSDL_DEFINITION", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)we);
        }
    }

    private void initXSD() throws ToolException {
        InputStream in;
        try {
            in = new URL(this.xsdUrl).openStream();
        }
        catch (Exception m) {
            try {
                in = new FileInputStream(this.xsdUrl);
            }
            catch (IOException ioe) {
                Message msg = new Message("FAIL_TO_OPEN_XSD_FILE", LOG, this.xsdUrl);
                throw new ToolException(msg, (Throwable)ioe);
            }
        }
        if (in == null) {
            throw new NullPointerException("Cannot create a ToolSpec object from a null stream");
        }
        try {
            this.xsdBuilder.setValidating(false);
            this.xsdDoc = this.xsdBuilder.parse(in);
        }
        catch (Exception ex) {
            Message msg = new Message("FAIL_TO_PARSE_TOOLSPEC", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)ex);
        }
    }

    private void addWSDLTypes() throws ToolException {
        ExtensibilityElement extElement;
        Element sourceElement = this.xsdDoc.getDocumentElement();
        Element targetElement = (Element)sourceElement.cloneNode(true);
        this.wsdlDefinition.setTargetNamespace((String)this.env.get("namespace"));
        this.wsdlDefinition.setQName(new QName("http://schemas.xmlsoap.org/wsdl/", (String)this.env.get("name")));
        Types types = this.wsdlDefinition.createTypes();
        try {
            this.registry = this.wsdlFactory.newPopulatedExtensionRegistry();
            this.registerJAXWSBinding(Definition.class);
            this.registerJAXWSBinding(Types.class);
            this.registerJAXWSBinding(Schema.class);
            extElement = this.registry.createExtension(Types.class, WSDLConstants.QNAME_SCHEMA);
        }
        catch (WSDLException wse) {
            Message msg = new Message("FAIL_TO_CREATE_SCHEMA_EXTENSION", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)wse);
        }
        ((Schema)extElement).setElement(targetElement);
        types.addExtensibilityElement(extElement);
        this.wsdlDefinition.setTypes(types);
        WSDLWriter wsdlWriter = this.wsdlFactory.newWSDLWriter();
        Writer outputWriter = this.getOutputWriter();
        try {
            wsdlWriter.writeWSDL(this.wsdlDefinition, outputWriter);
        }
        catch (WSDLException wse) {
            Message msg = new Message("FAIL_TO_WRITE_WSDL", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)wse);
        }
        try {
            outputWriter.close();
        }
        catch (IOException ioe) {
            Message msg = new Message("FAIL_TO_CLOSE_WSDL_FILE", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)ioe);
        }
    }

    private void registerJAXWSBinding(Class clz) {
        this.registry.registerSerializer(clz, ToolConstants.JAXWS_BINDINGS, new JAXWSBindingSerializer());
        this.registry.registerDeserializer(clz, ToolConstants.JAXWS_BINDINGS, new JAXWSBindingDeserializer());
        this.registry.mapExtensionTypes(clz, ToolConstants.JAXWS_BINDINGS, JAXWSBinding.class);
    }

    private Writer getOutputWriter() throws ToolException {
        String outputDir;
        Writer writer = null;
        String newName = null;
        if (this.env.get("outputfile") != null) {
            newName = (String)this.env.get("outputfile");
        } else {
            String oldName = (String)this.env.get("xsdurl");
            int position = oldName.lastIndexOf("/");
            if (position < 0) {
                position = oldName.lastIndexOf("\\");
            }
            if (position >= 0) {
                oldName = oldName.substring(position + 1, oldName.length());
            }
            newName = oldName.toLowerCase().indexOf(XSD_FILE_NAME_EXT) >= 0 ? oldName.substring(0, oldName.length() - 4) + WSDL_FILE_NAME_EXT : oldName + WSDL_FILE_NAME_EXT;
        }
        if (this.env.get("outputdir") != null) {
            outputDir = (String)this.env.get("outputdir");
            if (!"/".equals(outputDir.substring(outputDir.length() - 1)) && !"\\".equals(outputDir.substring(outputDir.length() - 1))) {
                outputDir = outputDir + "/";
            }
        } else {
            outputDir = "./";
        }
        FileWriterUtil fw = new FileWriterUtil(outputDir);
        try {
            writer = fw.getWriter("", newName);
        }
        catch (IOException ioe) {
            Message msg = new Message("FAIL_TO_WRITE_FILE", LOG, this.env.get("outputdir") + System.getProperty("file.seperator") + newName);
            throw new ToolException(msg, (Throwable)ioe);
        }
        return writer;
    }
}

