/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.databinding.jaxb;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JPackage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypesCodeWriter
extends CodeWriter {
    private File target;
    private List<String> excludeFileList = new ArrayList<String>();
    private List<String> excludePkgList;
    private List<File> generatedFiles = new ArrayList<File>();

    public TypesCodeWriter(File ftarget, List<String> excludePkgs) throws IOException {
        this.target = ftarget;
        this.excludePkgList = excludePkgs;
    }

    @Override
    public OutputStream openBinary(JPackage pkg, String fileName) throws IOException {
        File f = this.getFile(pkg, fileName);
        this.generatedFiles.add(f);
        return new FileOutputStream(this.getFile(pkg, fileName));
    }

    public List<File> getGeneratedFiles() {
        return this.generatedFiles;
    }

    protected File getFile(JPackage pkg, String fileName) throws IOException {
        File dir;
        String dirName = pkg.name().replace('.', File.separatorChar);
        File file = dir = pkg.isUnnamed() ? this.target : new File(this.target, dirName);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File fn = new File(dir, fileName);
        if (this.excludePkgList.contains(pkg.name())) {
            this.excludeFileList.add(dirName + File.separator + fileName);
        }
        if (fn.exists() && !fn.delete()) {
            throw new IOException(fn + ": Can't delete previous version");
        }
        return fn;
    }

    @Override
    public void close() throws IOException {
    }

    public List<String> getExcludeFileList() {
        return this.excludeFileList;
    }
}

