/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.validator;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.validator.ServiceValidator;

public class UniqueBodyValidator
extends ServiceValidator {
    public static final Logger LOG = LogUtils.getL7dLogger(UniqueBodyValidator.class);

    public UniqueBodyValidator() {
    }

    public UniqueBodyValidator(ServiceInfo s) {
        this.service = s;
    }

    public boolean isValid() {
        return this.checkUniqueBody();
    }

    private boolean checkUniqueBody() {
        Collection<EndpointInfo> endpoints = this.service.getEndpoints();
        if (endpoints != null) {
            for (EndpointInfo endpoint : endpoints) {
                if (this.isValidEndpoint(endpoint)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isValidEndpoint(EndpointInfo endpoint) {
        BindingInfo binding = endpoint.getBinding();
        HashMap<QName, QName> uniqueNames = new HashMap<QName, QName>();
        HashMap<QName, HashSet<String>> actions2 = new HashMap<QName, HashSet<String>>();
        Collection<BindingOperationInfo> bos = binding.getOperations();
        for (BindingOperationInfo bo : bos) {
            OperationInfo op = binding.getInterface().getOperation(bo.getName());
            if (op.getInput() != null && op.getInput().getMessageParts().size() == 1) {
                MessagePartInfo part = op.getInput().getMessageParts().iterator().next();
                if (part.getElementQName() == null) continue;
                QName mName = part.getElementQName();
                String action = this.getWSAAction(op.getInput());
                QName opName = (QName)uniqueNames.get(mName);
                HashSet<String> opActions = (HashSet<String>)actions2.get(mName);
                if (opName != null && opActions != null && !opActions.contains(action)) {
                    opName = null;
                }
                if (opName != null) {
                    Message msg = new Message("NON_UNIQUE_BODY", LOG, endpoint.getName(), op.getName(), opName, mName);
                    this.addErrorMessage(msg.toString());
                    return false;
                }
                uniqueNames.put(mName, op.getName());
                if (action != null) {
                    if (opActions == null) {
                        opActions = new HashSet<String>();
                        actions2.put(mName, opActions);
                    }
                    opActions.add(action);
                }
            }
            for (BindingFaultInfo fault : bo.getFaults()) {
                if (fault.getFaultInfo().getMessageParts().size() <= 1) continue;
                Message msg = new Message("FAULT_WITH_MULTIPLE_PARTS", LOG, fault.getFaultInfo().getName().getLocalPart());
                this.addErrorMessage(msg.toString());
                return false;
            }
        }
        return true;
    }

    private String getWSAAction(MessageInfo input) {
        if (input.getExtensionAttributes() != null) {
            for (Map.Entry<QName, Object> ent : input.getExtensionAttributes().entrySet()) {
                if (!"Action".equals(ent.getKey().getLocalPart())) continue;
                return ent.getValue().toString();
            }
        }
        return null;
    }
}

