/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.IssuedToken;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssuedTokenBuilder
implements AssertionBuilder<Element> {
    private static final String WSA_NAMESPACE_SUB = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
    private static final String WSA_NAMESPACE = "http://www.w3.org/2005/08/addressing";
    private static final QName[] KNOWN_ELEMENTS = new QName[]{SP11Constants.ISSUED_TOKEN, SP12Constants.ISSUED_TOKEN};
    PolicyBuilder builder;

    public IssuedTokenBuilder(PolicyBuilder b) {
        this.builder = b;
    }

    @Override
    public QName[] getKnownElements() {
        return KNOWN_ELEMENTS;
    }

    @Override
    public Assertion build(Element element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        IssuedToken issuedToken = new IssuedToken(consts);
        issuedToken.setOptional(PolicyConstants.isOptional(element));
        issuedToken.setIgnorable(PolicyConstants.isIgnorable(element));
        String includeAttr = DOMUtils.getAttribute(element, consts.getIncludeToken());
        if (includeAttr != null) {
            issuedToken.setInclusion(consts.getInclusionFromAttributeValue(includeAttr));
        }
        Element child = DOMUtils.getFirstElement(element);
        while (child != null) {
            String ln = child.getLocalName();
            if (SP11Constants.ISSUER.getLocalPart().equals(ln)) {
                Element issuerEpr = DOMUtils.getFirstChildWithName(child, new QName(WSA_NAMESPACE, "Address"));
                if (issuerEpr == null) {
                    issuerEpr = DOMUtils.getFirstChildWithName(child, new QName(WSA_NAMESPACE_SUB, "Address"));
                }
                issuedToken.setIssuerEpr(issuerEpr);
                Element issuerMex = DOMUtils.getFirstChildWithName(child, new QName(WSA_NAMESPACE, "Metadata"));
                if (issuerMex == null) {
                    issuerMex = DOMUtils.getFirstChildWithName(child, new QName(WSA_NAMESPACE_SUB, "Metadata"));
                }
                issuedToken.setIssuerMex(issuerMex);
            } else if ("RequestSecurityTokenTemplate".equals(ln)) {
                issuedToken.setRstTemplate(child);
            } else if ("Policy".equals(ln)) {
                Policy policy = this.builder.getPolicy(child);
                Iterator<List<Assertion>> iterator = (policy = policy.normalize(this.builder.getPolicyRegistry(), false)).getAlternatives();
                if (iterator.hasNext()) {
                    this.processAlternative(iterator.next(), issuedToken);
                }
            }
            child = DOMUtils.getNextElement(child);
        }
        return issuedToken;
    }

    private void processAlternative(List assertions, IssuedToken parent) {
        for (Assertion assertion : assertions) {
            QName name = assertion.getName();
            if ("RequireDerivedKeys".equals(name.getLocalPart())) {
                parent.setDerivedKeys(true);
                continue;
            }
            if ("RequireExternalReference".equals(name.getLocalPart())) {
                parent.setRequireExternalReference(true);
                continue;
            }
            if (!"RequireInternalReference".equals(name.getLocalPart())) continue;
            parent.setRequireInternalReference(true);
        }
    }
}

